// $Id: syscall_enternamespace-v21.hc 2817 2008-10-31 04:45:26Z dhozac $    --*- c -*--

// Copyright (C) 2004 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
// Copyright (C) 2006 Daniel Hokka Zakrisson
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "vserver.h"

static inline ALWAYSINLINE int
vc_enter_namespace_spaces(xid_t xid, uint_least64_t mask, uint32_t index)
{
  struct vcmd_space_mask_v1 data = { .mask = mask };
  if (index != 0) {
    errno = EINVAL;
    return -1;
  }
  return vserver(VCMD_enter_space_v1, CTX_USER2KERNEL(xid), &data);
}
