/*
 * splash.c
 *
 * Bootsplash integration into the suspend and resume tools
 *
 * Copyright (C) 2006 Holger Macht <holger@homac.de>
 *
 * This file is released under the GPLv2.
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "splash.h"
#include <libusplash.h>
#include <usplash_backend.h>

extern int xres;
extern int yres;

/**
 *	dummy functions in case if no splash system was found or
 *	bootsplashing is disabled
 */
static int splash_dummy_int_void(void) { return 0; }
static int splash_dummy_int_int(int p) { return 0; }
static void splash_dummy_void_void(void) { return; }

/* Tries to find a splash system and initializes interface functions */
void splash_prepare(struct splash *splash, int enabled)
{
	int error = 0;

	splash->to_silent   = splash_dummy_int_void;
	splash->to_verbose  = splash_dummy_int_void;
	splash->finish      = splash_dummy_int_void;
	splash->progress    = splash_dummy_int_int;
	splash->switch_to   = splash_dummy_void_void;

	if (!enabled)
		return;

	usplash_setup (xres, yres, 0);

	clear_screen ();
	clear_progressbar ();
	clear_text ();

	splash->progress = draw_progressbar;

}
