/* usplash
 *
 * Copyright © 2006 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "usplash-theme.h"

void switch_console(int vt, int vt_fd);
void wait_normal_vt(void);
void flush_stdin();

void clear_screen(void);
void fade_logo(int on, int step);
void pulse_logo(int num_cycles);

void clear_progressbar(void);
void draw_progressbar(int percentage);

void clear_text(void);
void draw_text(const char *string, size_t len);
void draw_text_urgent(const char *string, size_t len);
void draw_line(const char *string, size_t len);
void draw_status(const char *string, size_t len, int mode);
void set_pulsating(int pulsate_enabled);
void request_animate_step();
void process_pending_animation_steps();
void animate_step(int pulsating);

#define USPLASH_THEME_ASSERT(expr) do { \
	if (expr) { \
		fprintf(stderr, \
			"usplash: rejecting theme %s %dx%d (assertion %s failed); please file a bug\n", \
			USPLASH_THEME, \
			theme->theme_width, theme->theme_height, \
			#expr); \
		return -1; \
	} \
} while (0)

int usplash_sanity_check_theme(struct usplash_theme* theme);
int usplash_setup(int xres, int yres, int verbose);
size_t strncspn(const char *s, size_t n, const char *reject);
int handle_input(const char *string, size_t len, int quiet);
int handle_timeout_input(const char *string, size_t len, int quiet,int timeout);
int handle_input_char();
int handle_verbose(int mode);
int usplash_timeout_get_string(char *inputbuf, int length, int quiet, int inputtimeout);
#define usplash_get_string(buf,length,quiet) usplash_timeout_get_string(buf,length,quiet,-1)

/* Default theme, used when no suitable alternative can be found */
extern struct usplash_theme testcard_theme;
extern struct usplash_theme *theme;
extern int usplash_xres, usplash_yres;
extern int top_edge, left_edge;
extern int animation_needed_fd;
