#!/usr/local/bin/perl
# index.cgi
# List the mail messages for the user

require './mailbox-lib.pl';
&ReadParse();

&open_read_hash();
&open_dsn_hash();

@folders = &list_folders_sorted();
if (defined($in{'id'})) {
	# Folder ID specified
	$idf = &find_named_folder($in{'id'}, \@folders);
	$in{'folder'} = $idf->{'index'} if ($idf);
	}
elsif (!defined($in{'folder'}) && $userconfig{'default_folder'}) {
	# No folder specified .. find the default by preferences
	$df = &find_named_folder($userconfig{'default_folder'}, \@folders);
	$in{'folder'} = $df->{'index'} if ($df);
	}
($folder) = grep { $_->{'index'} == $in{'folder'} } @folders;

print "Refresh: $userconfig{'refresh'}\r\n"
	if ($userconfig{'refresh'});
($qtotal, $qcount, $totalquota, $countquota) = &get_user_quota();
if ($totalquota) {
	$qmesg = &text('mail_quota', &nice_size($qtotal),
				     &nice_size($totalquota));
	}
&ui_print_header(undef, $text{'mail_title'}, "", undef, 1, 1, 0, $qmesg);
print &check_clicks_function();

# Check if this is a POP3 or IMAP inbox with no login set
if (($folder->{'type'} == 2 || $folder->{'type'} == 4) &&
    $folder->{'mode'} == 3 && !defined($folder->{'user'})) {
	print "<form action=inbox_login.cgi method=post>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<center><table border>\n";
	print "<tr $tb> <td><b>$text{'mail_loginheader'}</b></td> </tr>\n";
	print "<tr $cb> <td align=middle>",&text('mail_logindesc',
			"<tt>$folder->{'server'}</tt>"),"\n";
	print "<table>\n";

	print "<tr> <td><b>$text{'mail_loginuser'}</b></td>\n";
	print "<td><input name=user size=30 value='$remote_user'></td> </tr>\n";
	print "<tr> <td><b>$text{'mail_loginpass'}</b></td>\n";
	print "<td><input type=password name=pass size=30></td> </tr>\n";
	if ($folder->{'type'} == 4) {
		print "<tr> <td valign=top><b>$text{'mail_loginmailbox'}",
		      "</b></td> <td>\n";
		printf"<input type=radio name=mailbox_def value=1 %s> %s<br>\n",
			"checked", $text{'edit_imapinbox'};
		printf"<input type=radio name=mailbox_def value=0> %s\n",
			$text{'edit_imapother'};
		print "<input name=mailbox size=20></td> </tr>\n";
		}

	print "<tr> <td colspan=2 align=center>\n";
	print "<input type=submit value='$text{'mail_login'}'>\n";
	print "<input type=reset value='$text{'mail_reset'}'></td> </tr>\n";
	print "</table></td></tr></table></form>\n";

	&ui_print_footer("/", $text{'index'});
	exit;
	}

# Get folder-selection HTML
$sel = &folder_select(\@folders, $folder, "folder");

# Work out start from jump page
$perpage = $folder->{'perpage'} || $userconfig{'perpage'} || 20;
if ($in{'jump'} =~ /^\d+$/ && $in{'jump'} > 0) {
	$in{'start'} = ($in{'jump'}-1)*$perpage;
	}

# View mail in sort order
@mail = &mailbox_list_mails_sorted(
		int($in{'start'}), int($in{'start'})+$perpage-1,
	        $folder, 1, \@error);
if ($in{'start'} >= @mail && $in{'jump'}) {
	# Jumped too far!
	$in{'start'} = @mail - $perpage;
	@mail = &mailbox_list_mails_sorted(int($in{'start'}),
					   int($in{'start'})+$perpage-1,
					   $folder, 1, \@error);
	}

# Show page flipping arrows
&show_arrows();

print "<form action=delete_mail.cgi method=post>\n";
print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
print "<input type=hidden name=mod value=",&modification_time($folder),">\n";
print "<input type=hidden name=start value='$in{'start'}'>\n";
if ($userconfig{'top_buttons'} && @mail) {
	&show_mailbox_buttons(1, \@folders, $folder, \@mail);
	print &select_all_link("d", 1, $text{'mail_all'}),"&nbsp;\n";
	print &select_invert_link("d", 1, $text{'mail_invert'}),"&nbsp;\n";
	}

$showto = $folder->{'show_to'};
$showfrom = $folder->{'show_from'};
if (@mail) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td>&nbsp;</td> ",
	      ($showfrom ? "<td>".&field_sort_link($text{'mail_from'}, "from",
				$folder, $in{'start'})."</td>" : ""),
	      ($showto ? "<td>".&field_sort_link($text{'mail_to'}, "to",
				$folder, $in{'start'})."</td>" : ""),
	      "<td>",&field_sort_link($text{'mail_date'}, "date",
				      $folder, $in{'start'}),"</td> ",
	      "<td>",&field_sort_link($text{'mail_size'}, "size",
				      $folder, $in{'start'}),"</td> ",
	      "<td>",&field_sort_link($text{'mail_subject'}, "subject",
				      $folder, $in{'start'}),"</td> ",
	      "</tr>\n";
	}
if (@error) {
	print "<center><b><font color=#ff0000>\n";
	print &text('mail_err', $error[0] == 0 ? $error[1] :
			      &text('save_elogin', $error[1])),"\n";
	print "</font></b></center>\n";
	}

# Show the actual email
for($i=int($in{'start'}); $i<@mail && $i<$in{'start'}+$perpage; $i++) {
	&notes_decode($mail[$i], $folder);
	local $idx = $mail[$i]->{'idx'};
	local $cols = 0;
	print "<tr $cb>\n";
	if (&editable_mail($mail[$i])) {
		print "<td><input type=checkbox name=d value=$i></td>\n";
		}
	else {
		print "<td><br></td>\n";
		}
	$cols++;
	if ($showfrom) {
		print "<td nowrap>",&view_mail_link($folder, $i, $in{'start'},
				$mail[$i]->{'header'}->{'from'}),"</td>\n";
		$cols++;
		}
	if ($showto) {
		print "<td nowrap>",&view_mail_link($folder, $i, $in{'start'},
				$mail[$i]->{'header'}->{'to'}),"</td>\n";
		$cols++;
		}
	print "<td nowrap>",&simplify_date($mail[$i]->{'header'}->{'date'}),
	      "</td>\n";
	print "<td nowrap>",&nice_size($mail[$i]->{'size'}, 1024),"</td>\n";
	print "<td><table border=0 cellpadding=0 cellspacing=0 width=100%>",
	      "<tr><td>",&simplify_subject($mail[$i]->{'header'}->{'subject'}),
	      "</td> <td align=right>";
	local @icons = &message_icons($mail[$i], $showto);
	print join("&nbsp;", @icons);
	print "</td></tr></table></td> </tr>\n";
	$cols+=4;
	&update_delivery_notification($mail[$i], $folder);

	if ($userconfig{'show_body'}) {
		# Show part of the body too
		&parse_mail($mail[$i]);
		local $data = &mail_preview($mail[$i]);
                if ($data) {
                        print "<tr $cb> <td colspan=$cols><tt>",
                                &html_escape($data),"</tt></td> </tr>\n";
                        }
		}
	}
if (@mail) {
	print "</table>\n";
	print &select_all_link("d", 1, $text{'mail_all'}),"&nbsp;\n";
	print &select_invert_link("d", 1, $text{'mail_invert'}),"<br>\n";
	}

&show_mailbox_buttons(2, \@folders, $folder, \@mail);
print "</form>\n";
if ($userconfig{'arrows'}) {
	# Show page flipping arrows
	print "<br>\n";
	&show_arrows();
	}

# Show search form
print "<hr>\n";
print "<table width=100%><tr>\n";

if ($folder->{'searchable'}) {
	print "<form action=mail_search.cgi><td width=33%>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<input type=hidden name=simple value=1>\n";
	print "<input type=submit value='$text{'mail_search2'}'>\n";
	print "<input name=search size=20></td></form>\n";

	$jumpform = (@mail > $perpage);
	print "<form action=search_form.cgi>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<td width=33% align=center><input type=submit name=advanced ",
	      "value='$text{'mail_advanced'}'></td>\n";
	print "</form>\n";
	}

# Show page jump form
if ($jumpform) {
	print "<form action=index.cgi>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<td width=33% align=right>\n";
	print "<input type=submit value='$text{'mail_jump'}'>\n";
	printf "<input name=jump size=3 value='%s'> %s %s\n",
		int($in{'start'} / $perpage)+1, $text{'mail_of'},
		int(@mail / $perpage)+1;
	print "</td></form>\n";
	}
else {
	print "<td width=33% align=right></td>\n";
	}
print "</tr>\n";

# Show various buttons for the address book, folders, sig and logging out
$logout = ($folder->{'type'} == 2 || $folder->{'type'} == 4) &&
	  $folder->{'mode'} == 3 && defined($folder->{'user'});
print "<tr>\n";

print "<form action=list_addresses.cgi>\n";
print "<td align=left width=33%><input type=submit value='$text{'mail_addresses'}'></td>\n";
print "</form>\n";

print "<form action=list_folders.cgi>\n";
print "<td align=",($bc == 2 ? "right" : "center"),
      " width=33%><input type=submit value='$text{'mail_folders'}'></td>\n";
print "</form>\n";

if (&get_signature_file()) {
	print "<form action=edit_sig.cgi>\n";
	print "<td width=33% align=right>",
	      "<input type=submit value='$text{'mail_sig'}'></td>\n";
	print "</form>\n";
	}
else {
	print "<td width=33% align=right></td>\n";
	}
print "</tr>\n";

print "<tr>\n";
if ($folder->{'trash'} || $userconfig{'show_delall'}) {
	# Show button to delete all mail in folder
	print "<form action=delete_mail.cgi>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<input type=hidden name=all value=1>\n";
	print "<td width=33%><input type=submit name=delete value='",
		($folder->{'trash'} ? $text{'mail_deltrash'}
				    : $text{'mail_delall'}),"'></td>\n";
	print "</form>\n";
	}
else {
	print "<td width=33%></td>\n";
	}

print "<td align=center width=33%></td>\n";

if ($logout) {
	# Add button for logging out of inbox
	print "<form action=inbox_logout.cgi>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<td align=right><input type=submit value='",
		$folder->{'type'} == 2 ? $text{'mail_logout'} :
					 $text{'mail_logout2'},"'></td>\n";
	print "</form>\n";
	}
print "</tr>\n";

print "</table>\n";

&ui_print_footer("/", $text{'index'});
&pop3_logout();

# show_arrows()
# Prints HTML for previous/next page arrows
sub show_arrows
{
print "<center>\n";
print "<form action=index.cgi><font size=+1>\n";

# Show left arrow to go to start of folder
if ($in{'start'}) {
	printf "<a href='index.cgi?start=%d&folder=%d'>%s</a>\n",
		0, $in{'folder'},
		'<img src=../images/first.gif border=0 align=middle>';
	}
else {
	print "<img src=../images/first-grey.gif align=middle>\n";
	}

# Show left arrow to decrease start
if ($in{'start'}) {
	printf "<a href='index.cgi?start=%d&folder=%d'>%s</a>\n",
		$in{'start'}-$perpage, $in{'folder'},
		'<img src=../images/left.gif border=0 align=middle>';
	}
else {
	print "<img src=../images/left-grey.gif align=middle>\n";
	}

local $s = $in{'start'}+1;
local $e = $in{'start'}+$perpage;
$e = scalar(@mail) if ($e > @mail);
if (@mail) {
	print &text('mail_pos', $s, $e, scalar(@mail), $sel);
	}
else {
	print &text('mail_none', $sel);
	}
print "</font><input type=submit value='$text{'mail_fchange'}'>\n";

# Show right arrow to increase start
if ($in{'start'}+$perpage < @mail) {
	printf "<a href='index.cgi?start=%d&folder=%d'>%s</a>\n",
		$in{'start'}+$perpage, $in{'folder'},
		'<img src=../images/right.gif border=0 align=middle>';
	}
else {
	print "<img src=../images/right-grey.gif align=middle>\n";
	}

# Show right arrow to go to end
if ($in{'start'}+$perpage < @mail) {
	printf "<a href='index.cgi?start=%d&folder=%d'>%s</a>\n",
		int((scalar(@mail)-$perpage)/$perpage + 1)*$perpage, $in{'folder'},
		'<img src=../images/last.gif border=0 align=middle>';
	}
else {
	print "<img src=../images/last-grey.gif align=middle>\n";
	}

if ($folder->{'msg'}) {
	print "<br>$folder->{'msg'}\n";
	}
print "</form></center>\n";
}

