#!/usr/local/bin/perl
# Save simple email forwarding options

require './forward-lib.pl';
&error_setup($text{'simple_err'});
&ReadParse();

# Validate and store inputs
$simple = &get_simple();
$simple->{'local'} = $in{'local'};
if ($in{'forward'}) {
	$in{'forwardto'} || &error($text{'simple_eforward'});
	$in{'forwardto'} =~ /^\S+$/ || &error($text{'simple_eforward2'});
	$simple->{'forward'} = $in{'forwardto'};
	}
else {
	delete($simple->{'forward'});
	}
if ($in{'autoreply'}) {
	$in{'autotext'} =~ /\S/ || &error($text{'simple_eautotext'});
	$simple->{'autotext'} = $in{'autotext'};
	if (!$simple->{'from'}) {
		($froms, $doms) = &mailbox::list_from_addresses();
		$simple->{'from'} = $froms->[0];
		}
	if ($in{'period_def'}) {
		delete($simple->{'replies'});
		delete($simple->{'period'});
		}
	else {
		$in{'period'} =~ /^\d+$/ || &error($text{'simple_eperiod'});
		$simple->{'period'} = $in{'period'}*60;
		$simple->{'replies'} ||=
			"$user_module_config_directory/replies";
		}
	}
else {
	delete($simple->{'autotext'});
	}

# Save settings
&save_simple($simple);
&redirect("index.cgi?simple=1");

