#!/usr/local/bin/perl
# edit_dbase.cgi
# Show database tables

require './postgresql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
@titles = grep { &can_edit_db($_) } &list_databases();
if (@titles == 1 && $module_info{'usermin'}) {
	# Single-database mode
	&header($text{'dbase_title'}, "", "edit_dbase", 1, 1);
	$single = 1;
	}
else {
	&header($text{'dbase_title'}, "", "edit_dbase");
	}
print "<center><font size=+2><tt>$in{'db'}</tt></font></center>\n";
print "<hr>\n";

# Is this database accepting connections?
@str = &table_structure($config{'basedb'}, "pg_database");
foreach $f (@str) {
	$hasconn++ if ($f->{'field'} eq 'datallowconn');
	}
if ($hasconn) {
	$rv = &execute_sql($config{'basedb'}, "select datallowconn from pg_database where datname = '$in{'db'}'");
	if ($rv->{'data'}->[0]->[0] !~ /^(t|1)/i) {
		print "<p>$text{'dbase_noconn'}</p>\n";
		print "<hr>\n";
		&footer("", $text{'index_return'});
		exit;
		}
	}

@titles = &list_tables($in{'db'});
if (@titles) {
	print "<h3>$text{'dbase_tables'}</h3>\n";
	&show_buttons();
	@icons = map { "images/table.gif" } @titles;
	@links = map { "edit_table.cgi?db=$in{'db'}&table=$_" } @titles;
	@titles = map { &html_escape($_) } @titles;
	&icons_table(\@links, \@titles, \@icons, 5);
	}
else {
	print "<b>$text{'dbase_none'}</b> <p>\n";
	}
&show_buttons();

print "<hr>\n";
if ($single) {
	&footer("/", $text{'index'});
	}
else {
	&footer("", $text{'index_return'});
	}

sub show_buttons
{
print "<table width=100%> <tr>\n";
print "<form action=table_form.cgi>\n";
print "<input type=hidden name=db value='$in{'db'}'>\n";
print "<td width=20% nowrap><input type=submit value='$text{'dbase_add'}'>\n";
print $text{'dbase_fields'},"\n";
print "<input name=fields size=4 value='4'></td>\n";
print "</form>\n";
if ($access{'delete'}) {
	print "<form action=drop_dbase.cgi>\n";
	print "<input type=hidden name=db value='$in{'db'}'>\n";
	print "<td align=middle valign=top width=20%><input type=submit ",
	      "value='$text{'dbase_drop'}'></td></form>\n";
	}

if ( &get_postgresql_version() >= 7.2 ) {
	if ($access{'backup'}) {
	    print "<form action=backup_form.cgi>\n" ;
	    print "<input type=hidden name=db value='$in{'db'}'>\n" ;
	    print "<td align=middle valign=top width=20%><input type=submit " ,
		  "value='$text{'dbase_bkup'}'></td></form>\n"  ;
	}

	if ($access{'restore'}) {
	    print "<form action=restore_form.cgi>\n" ;
	    print "<input type=hidden name=db value='$in{'db'}'>\n" ;
	    print "<td align=middle valign=top width=20%><input type=submit " ,
		  "value='$text{'dbase_rstr'}'></td></form>\n" ;
	}
}

print "<form action=exec_form.cgi>\n";
print "<input type=hidden name=db value='$in{'db'}'>\n";
print "<td align=right valign=top width=20%><input type=submit ",
      "value='$text{'dbase_exec'}'></td>\n";
print "</form>\n";
print "</tr> </table></form>\n";
}

