#!/usr/local/bin/perl
# save_folder.cgi
# Create, modify or delete a folder
# XXX check for external clash

require './mailbox-lib.pl';
&ReadParse();
@folders = &list_folders();
$old = $folders[$in{'idx'}] if (!$in{'new'});
&error_setup($text{'save_err'});

# Validate inputs
if (!$in{'delete'}) {
	$in{'perpage_def'} || $in{'perpage'} =~ /^\d+$/ ||
		&error($text{'save_eperpage'});
	$in{'fromaddr_def'} || $in{'fromaddr'} =~ /\S/ ||
		&error($text{'save_efromaddr'});
	}

# Can this type of folder be edited?
if ($in{'mode'} == 0) {
	$folder_types{'local'} || &error($text{'save_ecannot'});
	}
elsif ($in{'mode'} == 1) {
	$folder_types{'ext'} || &error($text{'save_ecannot'});
	}

if ($in{'mode'} == 0) {
	if ($in{'delete'} && $in{'confirm'}) {
		# Deleting a folder within ~/mail
		if ($old->{'type'} == 0) {
			unlink($old->{'file'});
			}
		else {
			system("rm -rf '$old->{'file'}'");
			}
		delete($userconfig{'perpage_'.$old->{'name'}});
		delete($userconfig{'sent_'.$old->{'name'}});
		delete($userconfig{'fromaddr_'.$old->{'name'}});
		}
	elsif ($in{'delete'} && !$in{'confirm'}) {
		# Confirming a delete
		&header($text{'save_title'}, "");
		print "<hr>\n";
		print "<form action=save_folder.cgi>\n";
		print "<input type=hidden name=idx value='$in{'idx'}'>\n";
		print "<input type=hidden name=mode value='$in{'mode'}'>\n";
		print "<input type=hidden name=confirm value='1'>\n";
		if ($old->{'type'} == 0) {
			@st = stat($old->{'file'});
			$sz = int($st[7]/1024);
			}
		else {
			$sz = &disk_usage_kb($old->{'file'});
			}
		print "<center><b>",&text('save_rusure', $old->{'name'},
				  "<tt>$old->{'file'}</tt>", $sz),"</b><p>\n";
		print "<input type=submit name=delete ",
		      "value='$text{'save_delete'}'>\n";
		print "</center></form>\n";

		print "<hr>\n";
		&footer("list_folders.cgi", $text{'folders_return'});
		exit;
		}
	else {
		# Creating or renaming a folder within ~/mail
		$in{'name'} =~ /^\S+$/ || &error($text{'save_ename'});
		$in{'name'} ne 'sentmail' && $in{'name'} ne 'drafts' ||
			&error($text{'save_esys'});
		$path = "$folders_dir/$in{'name'}";
		if ($old->{'name'} ne $in{'name'}) {
			($clash) = grep { $_->{'file'} eq $path } @folders;
			$clash && &error($text{'save_eclash'});
			}
		mkdir($folders_dir, 0700);
		if ($in{'name'} =~ /\//) {
			local $pp = $path;
			$pp =~ s/\/[^\/]+$//;
			system("mkdir -p '$pp'");
			}
		if ($in{'new'}) {
			# Create the file or directory
			if ($in{'type'} == 0) {
				open(FOLDER, ">>$path");
				close(FOLDER);
				chmod(0700, $path);
				}
			elsif ($in{'type'} == 1) {
				mkdir($path, 0700);
				mkdir("$path/cur", 0700);
				mkdir("$path/new", 0700);
				mkdir("$path/tmp", 0700);
				}
			elsif ($in{'type'} == 3) {
				mkdir($path, 0700);
				}
			}
		elsif ($old->{'name'} ne $in{'name'}) {
			# Just rename
			rename($old->{'file'}, $path);
			}
		if (!$in{'new'}) {
			delete($userconfig{'perpage_'.$old->{'name'}});
			delete($userconfig{'sent_'.$old->{'name'}});
			delete($userconfig{'fromaddr_'.$old->{'name'}});
			}
		$userconfig{'perpage_'.$in{'name'}} = $in{'perpage'}
			if (!$in{'perpage_def'});
		$userconfig{'sent_'.$in{'name'}} = 1 if ($in{'sent'});
		$userconfig{'fromaddr_'.$in{'name'}} = $in{'fromaddr'}
			if (!$in{'fromaddr_def'});
		}
	}
elsif ($in{'mode'} == 1) {
	@mailboxes = split(/\t+/, $userconfig{'mailboxes'});
	if ($in{'delete'}) {
		# Just remove from list of external folders
		@mailboxes = grep { $_ ne $old->{'file'} } @mailboxes;
		delete($userconfig{'folder_'.$old->{'file'}});
		delete($userconfig{'perpage_'.$old->{'file'}});
		delete($userconfig{'sent_'.$old->{'file'}});
		delete($userconfig{'fromaddr_'.$old->{'file'}});
		}
	else {
		# Adding or updating an external folder
		&verify_external($in{'file'});
		if ($in{'file'} ne $old->{'file'}) {
			($clash) = grep { $_->{'file'} eq $in{'file'} }
					@folders;
			$clash && &error($text{'save_eclash'});
			}
		$in{'name'} || &error($text{'save_ename'});
		if ($in{'new'}) {
			push(@mailboxes, $in{'file'});
			}
		else {
			delete($userconfig{'folder_'.$old->{'file'}});
			delete($userconfig{'perpage_'.$old->{'file'}});
			delete($userconfig{'sent_'.$old->{'file'}});
			delete($userconfig{'fromaddr_'.$old->{'file'}});
			$idx = &indexof($old->{'file'}, @mailboxes);
			$mailboxes[$idx] = $in{'file'};
			}
		$userconfig{'folder_'.$in{'file'}} = $in{'name'};
		$userconfig{'perpage_'.$in{'file'}} = $in{'perpage'}
			if (!$in{'perpage_def'});
		$userconfig{'sent_'.$in{'file'}} = 1 if ($in{'sent'});
		$userconfig{'fromaddr_'.$in{'file'}} = $in{'fromaddr'}
			if (!$in{'fromaddr_def'});
		}
	$userconfig{'mailboxes'} = join("\t", @mailboxes);
	}
elsif ($in{'mode'} == 2) {
	# Changing the path to the sent mail folder
	delete($userconfig{'perpage_sent_mail'});
	delete($userconfig{'fromaddr_sent_mail'});
	if ($in{'sent_def'}) {
		delete($userconfig{'sent_mail'});
		}
	else {
		&verify_external($in{'sent'});
		$userconfig{'sent_mail'} = $in{'sent'};
		$userconfig{'perpage_sent_mail'} = $in{'perpage'}
			if (!$in{'perpage_def'});
		$userconfig{'fromaddr_sent_mail'} = $in{'fromaddr'}
			if (!$in{'fromaddr_def'});
		}
	}
&write_file("$user_module_config_directory/config", \%userconfig);
&redirect("list_folders.cgi");

sub verify_external
{
if (-d $_[0]) {
	local ($f, %isdir);
	opendir(DIR, $_[0]);
	foreach $f (readdir(DIR)) {
		$isdir{$f}++ if (-d "$_[0]/$f" && $f ne "." && $f ne "..");
		}
	closedir(DIR);
	if (keys(%isdir)) {
		$isdir{'cur'} && $isdir{'new'} && $isdir{'tmp'} &&
			keys(%isdir) == 3 ||
				&error(&text('save_emaildir', $_[0]));
		}
	}
elsif (-r $_[0]) {
	open(FOLDER, $_[0]);
	local $line = <FOLDER>;
	close(FOLDER);
	!$line || $line =~ /^From\s+(\S+).*\d+/ ||
		&error(&text('save_embox', $_[0]));
	}
else {
	&error(&text('save_efile', $_[0]));
	}
$_[0] =~ /^\Q$folders_dir\E\// && &error(&text('save_eindir', $folders_dir));
}

