window.addEventListener("load", useragentswitcher_initialize, false);
window.addEventListener("unload", useragentswitcher_uninitialize, false);

// Displays the about dialog
function useragentswitcher_about()
{
    window.openDialog("chrome://useragentswitcher/content/about/about.xul", "useragentswitcher-about-dialog", "centerscreen,chrome,modal");
}

// Changes the options
function useragentswitcher_changeOptions()
{
    var hideMenuPreference = false;
    var menu               = document.getElementById("useragentswitcher-menu");

    // If the hide menu preference is set
    if(useragentswitcher_isPreferenceSet("useragentswitcher.menu.hide"))
    {
        hideMenuPreference = useragentswitcher_getBooleanPreference("useragentswitcher.menu.hide", true);
    }

    // If the menu exists
    if(menu)
    {
        menu.setAttribute("hidden", hideMenuPreference);
    }
}

// Displays the user agent switcher menu
function useragentswitcher_displayUserAgentSwitcherMenu(menu, suffix)
{
    var appName               = null;
    var appNamePreference     = null;
    var appVersion            = null;
    var appVersionPreference  = null;
    var defaultMenu           = document.getElementById("useragentswitcher-default-" + suffix);
    var description           = null;
    var descriptionPreference = null;
    var menuItem              = null;
    var mode                  = null;
    var optionsSeparator      = document.getElementById("useragentswitcher-separator2-" + suffix);
    var platform              = null;
    var platformPreference    = null;
    var userAgent             = null;
    var userAgentCount        = 0;
    var userAgentPreference   = null;
    var vendor                = null;
    var vendorPreference      = null;
    var vendorSub             = null;
    var vendorSubPreference   = null;

    // If the user agents count preference is set
    if(useragentswitcher_isPreferenceSet("useragentswitcher.user.agents.count"))
    {
        userAgentCount = useragentswitcher_getIntegerPreference("useragentswitcher.user.agents.count", true);
    }

    useragentswitcher_removeGeneratedMenuItems(menu, "useragentswitcher-default-" + suffix);

    // If the default menu exists
    if(defaultMenu)
    {
        defaultMenu.setAttribute("checked", !useragentswitcher_isPreferenceSet("general.useragent.override"));
    }

    // Loop through the possible user agents
	for(var i = 1; i <= userAgentCount; i++)
	{
	    appName     = "useragentswitcher." + i + ".appname";
	    appVersion  = "useragentswitcher." + i + ".appversion";
	    description = "useragentswitcher." + i + ".description";
	    platform    = "useragentswitcher." + i + ".platform";
	    userAgent   = "useragentswitcher." + i + ".useragent";
	    vendor      = "useragentswitcher." + i + ".vendor";
	    vendorSub   = "useragentswitcher." + i + ".vendorsub";

        // If the description is set
        if(useragentswitcher_isPreferenceSet(description))
        {
            appNamePreference     = "";
            appVersionPreference  = "";
	        descriptionPreference = useragentswitcher_getStringPreference(description, true);
            platformPreference    = "";
            userAgentPreference   = "";
            vendorPreference      = "";
            vendorSubPreference   = "";

            // If the app name is set
            if(useragentswitcher_isPreferenceSet(appName))
            {
    	        appNamePreference = useragentswitcher_getStringPreference(appName, true);
            }

            // If the app version is set
            if(useragentswitcher_isPreferenceSet(appVersion))
            {
    	        appVersionPreference = useragentswitcher_getStringPreference(appVersion, true);
            }

            // If the platform is set
            if(useragentswitcher_isPreferenceSet(platform))
            {
    	        platformPreference = useragentswitcher_getStringPreference(platform, true);
            }

            // If the user agent is set
            if(useragentswitcher_isPreferenceSet(userAgent))
            {
    	        userAgentPreference = useragentswitcher_getStringPreference(userAgent, true);
            }

            // If the vendor is set
            if(useragentswitcher_isPreferenceSet(vendor))
            {
    	        vendorPreference = useragentswitcher_getStringPreference(vendor, true);
            }

            // If the vendor sub is set
            if(useragentswitcher_isPreferenceSet(vendorSub))
            {
    	        vendorSubPreference = useragentswitcher_getStringPreference(vendorSub, true);
            }

            // If the description is not blank
            if(descriptionPreference != "")
            {
                menuItem = document.createElement("menuitem");

                // If all the override values are set to this item's values
                if(useragentswitcher_isPreferenceSet("general.appname.override") && useragentswitcher_getStringPreference("general.appname.override", true) == appNamePreference &&
                   useragentswitcher_isPreferenceSet("general.appversion.override") && useragentswitcher_getStringPreference("general.appversion.override", true) == appVersionPreference &&
                   useragentswitcher_isPreferenceSet("general.platform.override") && useragentswitcher_getStringPreference("general.platform.override", true) == platformPreference &&
                   useragentswitcher_isPreferenceSet("general.useragent.override") && useragentswitcher_getStringPreference("general.useragent.override", true) == userAgentPreference &&
                   useragentswitcher_getStringPreference("general.useragent.vendor", true) == vendorPreference &&
                   useragentswitcher_getStringPreference("general.useragent.vendorSub", true) == vendorSubPreference)
                {
                    menuItem.setAttribute("checked", true);
                }

                menuItem.setAttribute("id", "useragentswitcher-user-agent-" + i + "-" + suffix);
                menuItem.setAttribute("label", descriptionPreference);
                menuItem.setAttribute("oncommand", "useragentswitcher_switchUserAgent('" + useragentswitcher_escapeString(appNamePreference) + "', '" + useragentswitcher_escapeString(appVersionPreference) + "', '" + useragentswitcher_escapeString(platformPreference) + "', '" + useragentswitcher_escapeString(userAgentPreference) + "', '" + useragentswitcher_escapeString(vendorPreference) + "', '" + useragentswitcher_escapeString(vendorSubPreference) + "')");
                menuItem.setAttribute("type", "radio");

                // If the menu, menu item and options separator exist
                if(menu && menuItem && optionsSeparator)
                {
                    menu.insertBefore(menuItem, optionsSeparator);
                }
            }
        }
	}
}

// Escapes all apostrophes and backslashes in a string
function useragentswitcher_escapeString(string)
{
    // If the string is set
    if(string)
    {
        return encodeURIComponent(string).replace(new RegExp("'", "gi"), "\\'");
    }

    return "";
}

// Opens the help
function useragentswitcher_help()
{
    getBrowser().selectedTab = getBrowser().addTab("@home.page@help/");
}

// Initializes the extension
function useragentswitcher_initialize(event)
{
    var windowContent = window.getBrowser();

    // If the window content is set
    if(windowContent)
    {
        var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

        useragentswitcher_setupLocalizedOptions();

        windowContent.addEventListener("load", useragentswitcher_pageLoad, true);

        // If the observer service is set
        if(observerService)
        {
            observerService.addObserver(UserAgentSwitcherQuitObserver, "quit-application-requested", false);
        }

        // Try to remove the event listener
        try
        {
            window.removeEventListener("load", useragentswitcher_initialize, false);
        }
        catch(exception)
        {
            // Do nothing
        }
    }
}

// Opens a toolbar button automatically if another toolbar button is open on the toolbar
function useragentswitcher_openToolbarButton(currentToolbarButton)
{
    // If the toolbar button is set and is not open
    if(currentToolbarButton && !currentToolbarButton.open)
    {
        var toolbarButton        = null;
        var toolbarButtons       = currentToolbarButton.parentNode.getElementsByTagName("toolbarbutton");
        var toolbarButtonsLength = toolbarButtons.length;

        // Loop through the toolbar buttons
        for(var i = 0; i < toolbarButtonsLength; i++)
        {
            toolbarButton = toolbarButtons.item(i);

            // If the toolbar button is set, is not the same toolbar button and is open
            if(toolbarButton && toolbarButton != currentToolbarButton && toolbarButton.open)
            {
                toolbarButton.open        = false;
                currentToolbarButton.open = true;

                break;
            }
        }
    }
}

// Displays the options dialog
function useragentswitcher_options()
{
    window.openDialog("chrome://useragentswitcher/content/options/options.xul", "useragentswitcher-options-dialog", "centerscreen,chrome,modal,resizable");

    useragentswitcher_changeOptions();
}

// Handles the page being loaded
function useragentswitcher_pageLoad(event)
{
    var contentDocument = useragentswitcher_getPageLoadEventContentDocument(event);

    // If the content document is set
    if(contentDocument)
    {
        useragentswitcher_changeOptions();
        useragentswitcher_updateDisplay();
    }
}

// Removes all the generated menu items from the menu
function useragentswitcher_removeGeneratedMenuItems(menu, defaultMenuId)
{
    var menuItem       = null;
    var radioMenuItems = menu.getElementsByAttribute("type", "radio");

    // Loop through the radio menu items
    for(var i = 0; i < radioMenuItems.length; i++)
    {
        menuItem = radioMenuItems[i];

        // If this is not the default menu
        if(!menuItem.hasAttribute("id") || menuItem.getAttribute("id") != defaultMenuId)
        {
            menu.removeChild(menuItem);
        }
    }

    radioMenuItems = menu.getElementsByAttribute("type", "radio");

    // Loop through the menu items again because of the change to the behavior of getElementsByAttribute
    while(radioMenuItems.length > 1)
    {
        menuItem = radioMenuItems[1];

        // If this is not the default menu
        if(!menuItem.hasAttribute("id") || menuItem.getAttribute("id") != defaultMenuId)
        {
            menu.removeChild(menuItem);
        }
    }
}

// Resets the user agent
function useragentswitcher_reset()
{
    // If an override app name is set
    if(useragentswitcher_isPreferenceSet("general.appname.override"))
    {
        useragentswitcher_deletePreference("general.appname.override");
    }

    // If an override app version is set
    if(useragentswitcher_isPreferenceSet("general.appversion.override"))
    {
        useragentswitcher_deletePreference("general.appversion.override");
    }

    // If an override platform is set
    if(useragentswitcher_isPreferenceSet("general.platform.override"))
    {
        useragentswitcher_deletePreference("general.platform.override");
    }

    // If an override user agent is set
    if(useragentswitcher_isPreferenceSet("general.useragent.override"))
    {
        useragentswitcher_deletePreference("general.useragent.override");
    }

    // If an override vendor is set
    if(useragentswitcher_isPreferenceSet("general.useragent.vendor"))
    {
        useragentswitcher_deletePreference("general.useragent.vendor");
    }

    // If an override vendor sub is set
    if(useragentswitcher_isPreferenceSet("general.useragent.vendorSub"))
    {
        useragentswitcher_deletePreference("general.useragent.vendorSub");
    }

    useragentswitcher_updateDisplay();
}

// Sets up the localized options
function useragentswitcher_setupLocalizedOptions()
{
    var stringBundle = document.getElementById("useragentswitcher-string-bundle");

    // If the string bundle is set
    if(stringBundle)
    {
        // Convert maximum user agents preference to user agents count
        if(!useragentswitcher_isPreferenceSet("useragentswitcher.user.agents.count") && useragentswitcher_isPreferenceSet("useragentswitcher.maximum.useragents"))
        {
            useragentswitcher_setIntegerPreference("useragentswitcher.user.agents.count", useragentswitcher_getIntegerPreference("useragentswitcher.maximum.useragents", true));
            useragentswitcher_deletePreference("useragentswitcher.maximum.useragents");
        }
        else if(!useragentswitcher_isPreferenceSet("useragentswitcher.user.agents.count"))
        {
            useragentswitcher_setIntegerPreference("useragentswitcher.user.agents.count", 3);
        }

        // Set default user agents
        if(!useragentswitcher_isPreferenceSet("useragentswitcher.1.description"))
        {
            useragentswitcher_setStringPreference("useragentswitcher.1.appname", "Microsoft Internet Explorer");
            useragentswitcher_setStringPreference("useragentswitcher.1.appversion", "4.0 (compatible; MSIE 7.0; Windows NT 6.0)");
            useragentswitcher_setStringPreference("useragentswitcher.1.description", stringBundle.getString("useragentswitcher_userAgentInternetExplorer"));
            useragentswitcher_setStringPreference("useragentswitcher.1.platform", "Win32");
            useragentswitcher_setStringPreference("useragentswitcher.1.useragent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)");
            useragentswitcher_setStringPreference("useragentswitcher.1.vendor", "");
            useragentswitcher_setStringPreference("useragentswitcher.1.vendorsub", "");
        }
        if(!useragentswitcher_isPreferenceSet("useragentswitcher.2.description"))
        {
            useragentswitcher_setStringPreference("useragentswitcher.2.appname", "Netscape");
            useragentswitcher_setStringPreference("useragentswitcher.2.appversion", "4.8 [en] (Windows NT 6.0; U)");
            useragentswitcher_setStringPreference("useragentswitcher.2.description", stringBundle.getString("useragentswitcher_userAgentNetscape"));
            useragentswitcher_setStringPreference("useragentswitcher.2.platform", "Win32");
            useragentswitcher_setStringPreference("useragentswitcher.2.useragent", "Mozilla/4.8 [en] (Windows NT 6.0; U)");
            useragentswitcher_setStringPreference("useragentswitcher.2.vendor", "");
            useragentswitcher_setStringPreference("useragentswitcher.2.vendorsub", "");
        }
        if(!useragentswitcher_isPreferenceSet("useragentswitcher.3.description"))
        {
            useragentswitcher_setStringPreference("useragentswitcher.3.appname", "Opera");
            useragentswitcher_setStringPreference("useragentswitcher.3.appversion", "9.25 (Windows NT 6.0; U; en)");
            useragentswitcher_setStringPreference("useragentswitcher.3.description", stringBundle.getString("useragentswitcher_userAgentOpera"));
            useragentswitcher_setStringPreference("useragentswitcher.3.platform", "Win32");
            useragentswitcher_setStringPreference("useragentswitcher.3.useragent", "Opera/9.25 (Windows NT 6.0; U; en)");
            useragentswitcher_setStringPreference("useragentswitcher.3.vendor", "");
            useragentswitcher_setStringPreference("useragentswitcher.3.vendorsub", "");
        }
    }
}

// Switches the user agent
function useragentswitcher_switchUserAgent(appName, appVersion, platform, userAgent, vendor, vendorSub)
{
    useragentswitcher_setStringPreference("general.appname.override", decodeURIComponent(appName));
    useragentswitcher_setStringPreference("general.appversion.override", decodeURIComponent(appVersion));
    useragentswitcher_setStringPreference("general.platform.override", decodeURIComponent(platform));
    useragentswitcher_setStringPreference("general.useragent.override", decodeURIComponent(userAgent));
    useragentswitcher_setStringPreference("general.useragent.vendor", decodeURIComponent(vendor));
    useragentswitcher_setStringPreference("general.useragent.vendorSub", decodeURIComponent(vendorSub));

    useragentswitcher_updateDisplay();
}

// Uninitializes the extension
function useragentswitcher_uninitialize(event)
{
    var windowContent = window.getBrowser();

    // If the window content is set
    if(windowContent)
    {
        var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

        // If the observer service is set
        if(observerService)
        {
            // Try to remove the observer
            try
            {
                observerService.removeObserver(UserAgentSwitcherQuitObserver, "quit-application-requested");
            }
            catch(exception)
            {
                // Do nothing
            }
        }

        // Try to remove the event listener
        try
        {
            windowContent.removeEventListener("load", useragentswitcher_pageLoad, true);
        }
        catch(exception)
        {
            // Do nothing
        }

        // If the reset on close preference is not set or is set to true
        if(!useragentswitcher_isPreferenceSet("useragentswitcher.reset.onclose") || useragentswitcher_getBooleanPreference("useragentswitcher.reset.onclose", true))
        {
            var windowCount       = 0;
            var windowEnumeration = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator).getEnumerator("navigator:browser");

            // Loop through the open windows
            while(windowEnumeration.hasMoreElements())
            {
                windowEnumeration.getNext();
                windowCount++;
            }

            // If this is the last window closing
            if(windowCount == 0)
            {
                useragentswitcher_reset();
            }
        }

        // Try to remove the event listener
        try
        {
            window.removeEventListener("close", useragentswitcher_uninitialize, false);
        }
        catch(exception)
        {
            // Do nothing
        }
    }
}

// Updates the display
function useragentswitcher_updateDisplay()
{
    var userAgentButton = document.getElementById("useragentswitcher-button");
    var menu            = document.getElementById("useragentswitcher-menu");

    // If the user agent is overridden
    if(useragentswitcher_isPreferenceSet("general.useragent.override"))
    {
        // If the menu exists
        if(menu)
        {
            menu.setAttribute("image", "chrome://useragentswitcher/skin/non-default.png");
        }
    
        // If the user agent button is set
        if(userAgentButton)
        {
            userAgentButton.setAttribute("default", "false");
        }
    }
    else if(userAgentButton.hasAttribute("default"))
    {
        // If the menu exists
        if(menu)
        {
            menu.setAttribute("image", "chrome://useragentswitcher/skin/default.png");
        }
    
        // If the user agent button is set
        if(userAgentButton)
        {
            userAgentButton.removeAttribute("default");
        }
    }
}

// Quit observer
var UserAgentSwitcherQuitObserver =
{
    // Observes quits
    observe: function(subject, topic, data)
    {
        // If the reset on close preference is not set or is set to true
        if(!useragentswitcher_isPreferenceSet("useragentswitcher.reset.onclose") || useragentswitcher_getBooleanPreference("useragentswitcher.reset.onclose", true))
        {
            useragentswitcher_reset();
        }

        return false;
    }
}
