var useragentswitcher_preferencesService = null;

// Deletes a preference
function useragentswitcher_deletePreference(preference)
{
    // If the preference is set
    if(preference)
    {
        // If a user preference is set
        if(useragentswitcher_isPreferenceSet(preference))
        {
            useragentswitcher_getPreferencesService().clearUserPref(preference);
        }
    }
}

// Deletes a preference branch
function useragentswitcher_deletePreferenceBranch(branch)
{
    // If the branch is set
    if(branch)
    {
        useragentswitcher_getPreferencesService().deleteBranch(branch);
    }
}

// Gets a boolean preference, returning false if the preference is not set
function useragentswitcher_getBooleanPreference(preference, userPreference)
{
    // If the preference is set
    if(preference)
    {
        // If not a user preference or a user preference is set
        if(!userPreference || useragentswitcher_isPreferenceSet(preference))
        {
            try
            {
                return useragentswitcher_getPreferencesService().getBoolPref(preference);
            }
            catch(exception)
            {
                // Do nothing
            }
        }
    }

    return false;
}

// Gets an integer preference, returning 0 if the preference is not set
function useragentswitcher_getIntegerPreference(preference, userPreference)
{
    // If the preference is set
    if(preference)
    {
        // If not a user preference or a user preference is set
        if(!userPreference || useragentswitcher_isPreferenceSet(preference))
        {
            try
            {
                return useragentswitcher_getPreferencesService().getIntPref(preference);
            }
            catch(exception)
            {
                // Do nothing
            }
        }
    }

    return 0;
}

// Gets the preferences service
function useragentswitcher_getPreferencesService()
{
    // If the preferences service is not set
    if(!useragentswitcher_preferencesService)
    {
        useragentswitcher_preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    }

    return useragentswitcher_preferencesService;
}

// Gets a string preference, returning null if the preference is not set
function useragentswitcher_getStringPreference(preference, userPreference)
{
    // If the preference is set
    if(preference)
    {
        // If not a user preference or a user preference is set
        if(!userPreference || useragentswitcher_isPreferenceSet(preference))
        {
            try
            {
                return useragentswitcher_getPreferencesService().getComplexValue(preference, Components.interfaces.nsISupportsString).data.trim();
            }
            catch(exception)
            {
                // Do nothing
            }
        }
    }

    return null;
}

// Is a preference set
function useragentswitcher_isPreferenceSet(preference)
{
    // If the preference is set
    if(preference)
    {
        return useragentswitcher_getPreferencesService().prefHasUserValue(preference);
    }

    return false;
}

// Sets a boolean preference
function useragentswitcher_setBooleanPreference(preference, value)
{
    // If the preference is set
    if(preference)
    {
        useragentswitcher_getPreferencesService().setBoolPref(preference, value);
    }
}

// Sets a boolean preference if it is not already set
function useragentswitcher_setBooleanPreferenceIfNotSet(preference, value)
{
    // If the preference is not set
    if(!useragentswitcher_isPreferenceSet(preference))
    {
        useragentswitcher_getPreferencesService().setBoolPref(preference, value);
    }
}

// Sets an integer preference
function useragentswitcher_setIntegerPreference(preference, value)
{
    // If the preference is set
    if(preference)
    {
        useragentswitcher_getPreferencesService().setIntPref(preference, value);
    }
}

// Sets an integer preference if it is not already set
function useragentswitcher_setIntegerPreferenceIfNotSet(preference, value)
{
    // If the preference is not set
    if(!useragentswitcher_isPreferenceSet(preference))
    {
        useragentswitcher_setIntegerPreference(preference, value);
    }
}

// Sets a string preference
function useragentswitcher_setStringPreference(preference, value)
{
    // If the preference is set
    if(preference)
    {
        var supportsStringInterface = Components.interfaces.nsISupportsString;
        var string                  = Components.classes["@mozilla.org/supports-string;1"].createInstance(supportsStringInterface);

        string.data = value;

        useragentswitcher_getPreferencesService().setComplexValue(preference, supportsStringInterface, string);
    }
}

// Sets a string preference if it is not already set
function useragentswitcher_setStringPreferenceIfNotSet(preference, value)
{
    // If the preference is not set
    if(!useragentswitcher_isPreferenceSet(preference))
    {
        useragentswitcher_setStringPreference(preference, value);
    }
}