/* i386-dos32.watcom.le.h
   created from i386-dos32.watcom.le.bin, 27436 (0x6b2c) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_I386_DOS32_WATCOM_LE_SIZE    27436
#define STUB_I386_DOS32_WATCOM_LE_ADLER32 0x946d1444
#define STUB_I386_DOS32_WATCOM_LE_CRC32   0x39b33888

unsigned char stub_i386_dos32_watcom_le[27436] = {
127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
180, 30,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
160,  0,157,  0,191, 97,108,105, 98,105, 87, 65, 84, 67, 79, 77,   /* 0x  30 */
  6, 30,  7, 87,141,183,  0,  0,  0,  0,141,191,  0,  0,  0,  0,   /* 0x  40 */
185,  0,  0,  0,  0,253,243,165,252,141,119,  4, 95,131,205,255,   /* 0x  50 */
 87,233,252,255,255,255, 85, 80, 88, 33,161,216,208,213,  0,  0,   /* 0x  60 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  70 */
  0,  0,  0,  0,  0, 45,235,  3,164,235,  3,138,  6, 70,136,  7,   /* 0x  80 */
 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,   /* 0x  90 */
 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,   /* 0x  a0 */
131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,   /* 0x  b0 */
 17,219,115,255,  1,219,115,255,117,  9,139, 30,131,238,252, 17,   /* 0x  c0 */
219,115,255, 49,201,131,232,  3,114, 13,193,224,  8,138,  6, 70,   /* 0x  d0 */
131,240,255,116,255,137,197,  1,219,117,  7,139, 30,131,238,252,   /* 0x  e0 */
 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x  f0 */
201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 100 */
201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 48,  1,219,   /* 0x 110 */
115, 48,117,  9,139, 30,131,238,252, 17,219,115, 48, 65, 65,131,   /* 0x 120 */
193,  2,129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,243,   /* 0x 130 */
164, 94,233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,   /* 0x 140 */
118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,   /* 0x 150 */
139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,   /* 0x 160 */
207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7,   /* 0x 170 */
 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,   /* 0x 180 */
 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,   /* 0x 190 */
131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,   /* 0x 1a0 */
 17,219,114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252, 17,   /* 0x 1b0 */
219,114, 15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 1c0 */
192,235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,   /* 0x 1d0 */
131,240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139,   /* 0x 1e0 */
 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,   /* 0x 1f0 */
252, 17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,   /* 0x 200 */
252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 210 */
115, 68,  1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,115,   /* 0x 220 */
 68, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  1, 86,   /* 0x 230 */
141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,253,   /* 0x 240 */
252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,   /* 0x 250 */
252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,   /* 0x 260 */
  4,119,241,  1,207,233,252,255,255,255,235,  3,164,235,  3,138,   /* 0x 270 */
  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 280 */
114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,   /* 0x 290 */
117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139,   /* 0x 2a0 */
 30,131,238,252, 17,219,114, 30,  1,219,115, 11,117, 30,139, 30,   /* 0x 2b0 */
131,238,252, 17,219,114, 30, 72,  1,219,117,  7,139, 30,131,238,   /* 0x 2c0 */
252, 17,219, 17,192,235,255,  1,219,117,  7,139, 30,131,238,252,   /* 0x 2d0 */
 17,219, 17,201,235,255, 49,201,131,232,  3,114, 17,193,224,  8,   /* 0x 2e0 */
138,  6, 70,131,240,255,116,255,209,248,137,197,235, 11,  1,219,   /* 0x 2f0 */
117,  7,139, 30,131,238,252, 17,219,114,204, 65,  1,219,117,  7,   /* 0x 300 */
139, 30,131,238,252, 17,219,114,190,  1,219,117,  7,139, 30,131,   /* 0x 310 */
238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 320 */
219,115, 81,  1,219,115, 81,117,  9,139, 30,131,238,252, 17,219,   /* 0x 330 */
115, 81, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  2,   /* 0x 340 */
 86,141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,   /* 0x 350 */
253,252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,   /* 0x 360 */
233,252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,   /* 0x 370 */
233,  4,119,241,  1,207,233,252,255,255,255,137,229,141,156, 36,   /* 0x 380 */
  0,  0,  0,  0, 49,192, 80, 57,220,117,251, 70, 70, 83,104,  0,   /* 0x 390 */
  0,  0,  0, 87,131,195,  4, 83,104,  0,  0,  0,  0, 86,131,195,   /* 0x 3a0 */
  4, 83, 80,199,  3,  0,  0,  0,  0,137,229,139, 85,  0,172, 74,   /* 0x 3b0 */
136,193, 36,  7,192,233,  3,187,  0,253,255,255,211,227,141,164,   /* 0x 3c0 */
 92,144,241,255,255,131,228,224,106,  0,106,  0,137,227, 83,131,   /* 0x 3d0 */
195,  4,139, 77,  0,255, 49, 87, 83,131,195,  4,136, 67,  2,172,   /* 0x 3e0 */
 74,136,193, 36, 15,136,  3,192,233,  4,136, 75,  1, 82, 86, 83,   /* 0x 3f0 */
 80, 85, 87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,199,   /* 0x 400 */
 68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,   /* 0x 410 */
  0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,   /* 0x 420 */
182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,182,   /* 0x 430 */
 74,  1,211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,  0,   /* 0x 440 */
 15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,   /* 0x 450 */
  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,   /* 0x 460 */
100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,   /* 0x 470 */
  0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,   /* 0x 480 */
  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57,   /* 0x 490 */
 76, 36,116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,192,   /* 0x 4a0 */
  2,226,246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,   /* 0x 4b0 */
255,255,255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36,   /* 0x 4c0 */
 76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,   /* 0x 4d0 */
193,231,  8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,164,   /* 0x 4e0 */
  0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,   /* 0x 4f0 */
116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,   /* 0x 500 */
137,116, 36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141, 44,   /* 0x 510 */
 66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36,   /* 0x 520 */
 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,   /* 0x 530 */
139, 85,  0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,131,   /* 0x 540 */
221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138,   /* 0x 550 */
 76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182,   /* 0x 560 */
 84, 36,115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,   /* 0x 570 */
108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,   /* 0x 580 */
  1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,   /* 0x 590 */
108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68,   /* 0x 5a0 */
 36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,   /* 0x 5b0 */
  2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,   /* 0x 5c0 */
139,108, 36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,   /* 0x 5d0 */
255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59,   /* 0x 5e0 */
 92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,   /* 0x 5f0 */
  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,   /* 0x 600 */
  0,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,137,   /* 0x 610 */
 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,131,   /* 0x 620 */
124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,   /* 0x 630 */
235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,   /* 0x 640 */
  5,102, 41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,   /* 0x 650 */
116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,121,   /* 0x 660 */
129,254,255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,   /* 0x 670 */
213,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,   /* 0x 680 */
132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,   /* 0x 690 */
 67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,   /* 0x 6a0 */
241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,   /* 0x 6b0 */
  0, 41,240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,235,   /* 0x 6c0 */
159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,   /* 0x 6d0 */
102, 41,193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,139,   /* 0x 6e0 */
140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,124,   /* 0x 6f0 */
 36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,   /* 0x 700 */
  0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108, 36,   /* 0x 710 */
 96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,   /* 0x 720 */
  0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,102,   /* 0x 730 */
193,232,  5,102, 41,194,129,249,255,255,255,  0,102,137, 85,  0,   /* 0x 740 */
139,108, 36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59, 92,   /* 0x 750 */
 36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,   /* 0x 760 */
  8, 67,  9,199,139,108, 36, 56,137,200,193,232, 11,102,139,149,   /* 0x 770 */
128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,198,   /* 0x 780 */
184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139, 76,   /* 0x 790 */
 36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,   /* 0x 7a0 */
120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,   /* 0x 7b0 */
137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,193,   /* 0x 7c0 */
100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,   /* 0x 7d0 */
137,206, 41,199, 41,198,137,208,102,193,232,  5,139, 76, 36, 56,   /* 0x 7e0 */
102, 41,194,129,254,255,255,255,  0,102,137,145,128,  1,  0,  0,   /* 0x 7f0 */
119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,   /* 0x 800 */
231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,234,   /* 0x 810 */
 11,102,139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,215,   /* 0x 820 */
 15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,199,   /* 0x 830 */
 68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,139,   /* 0x 840 */
 76, 36, 56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76,   /* 0x 850 */
 36, 68,193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,141,   /* 0x 860 */
 44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,   /* 0x 870 */
  3,193,231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,  0,   /* 0x 880 */
  0,137,240,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 96,   /* 0x 890 */
 41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36,   /* 0x 8a0 */
 72,131,124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,  0,   /* 0x 8b0 */
 15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,   /* 0x 8c0 */
160,  0,  0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,137,   /* 0x 8d0 */
 68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136,   /* 0x 8e0 */
 68, 36,115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0,   /* 0x 8f0 */
 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,102,137,149,   /* 0x 900 */
224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,232,   /* 0x 910 */
  5,139,108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,  0,   /* 0x 920 */
102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,   /* 0x 930 */
  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,   /* 0x 940 */
 76, 36, 56,137,240,193,232, 11,102,139,145,176,  1,  0,  0, 15,   /* 0x 950 */
183,202, 15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,  0,   /* 0x 960 */
 41,200,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,176,   /* 0x 970 */
  1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,199,   /* 0x 980 */
 41,193,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,129,   /* 0x 990 */
249,255,255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59, 92,   /* 0x 9a0 */
 36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,   /* 0x 9b0 */
  8, 67,  9,199,139,116, 36, 56,137,200,193,232, 11,102,139,150,   /* 0x 9c0 */
200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,198,   /* 0x 9d0 */
184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,  4,   /* 0x 9e0 */
  2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206,   /* 0x 9f0 */
 41,199, 41,198,137,208,102,193,232,  5,102, 41,194,139, 68, 36,   /* 0x a00 */
 56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,   /* 0x a10 */
137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,   /* 0x a20 */
137, 68, 36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,139,   /* 0x a30 */
 76, 36,120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,   /* 0x a40 */
137, 68, 36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36, 76,   /* 0x a50 */
 15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,   /* 0x a60 */
  9,199,102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,197,   /* 0x a70 */
 57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,   /* 0x a80 */
100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,   /* 0x a90 */
  4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36,   /* 0x aa0 */
 16,235,114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,   /* 0x ab0 */
129,254,255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,   /* 0x ac0 */
132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,   /* 0x ad0 */
199,102,139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,197,   /* 0x ae0 */
 57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,   /* 0x af0 */
100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,   /* 0x b00 */
  4,  2,139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,   /* 0x b10 */
  0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,   /* 0x b20 */
198, 41,199,137,208,137,116, 36, 72,102,193,232,  5,199, 68, 36,   /* 0x b30 */
 44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,   /* 0x b40 */
102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76,   /* 0x b50 */
 36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116,   /* 0x b60 */
 36, 16,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92,   /* 0x b70 */
 36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,   /* 0x b80 */
193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11,   /* 0x b90 */
 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,   /* 0x ba0 */
  8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,  6,   /* 0x bb0 */
235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,   /* 0x bc0 */
194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,   /* 0x bd0 */
117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3,   /* 0x be0 */
 84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,   /* 0x bf0 */
  0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,  3,   /* 0x c00 */
  0,  0,  0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,   /* 0x c10 */
  0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,   /* 0x c20 */
  0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,255,   /* 0x c30 */
255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,   /* 0x c40 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x c50 */
 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115,   /* 0x c60 */
 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,   /* 0x c70 */
  4,  2,102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,   /* 0x c80 */
208,102,193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,108,   /* 0x c90 */
 36, 36, 77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,137,   /* 0x ca0 */
 20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,230,   /* 0x cb0 */
  1,141, 72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,   /* 0x cc0 */
139,108, 36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,   /* 0x cd0 */
208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,   /* 0x ce0 */
124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,   /* 0x cf0 */
  1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,   /* 0x d00 */
199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36,   /* 0x d10 */
 72,131,206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137, 52,   /* 0x d20 */
 36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68,   /* 0x d30 */
 36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,   /* 0x d40 */
108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,   /* 0x d50 */
255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,   /* 0x d60 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x d70 */
 72,102,139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,199,   /* 0x d80 */
115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,   /* 0x d90 */
141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36,   /* 0x da0 */
 72, 41,199,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 24,   /* 0x db0 */
102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,   /* 0x dc0 */
209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,139,   /* 0x dd0 */
 52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,   /* 0x de0 */
116,131,193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,   /* 0x df0 */
  0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52,   /* 0x e00 */
 40,138,  6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,   /* 0x e10 */
116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,235,   /* 0x e20 */
 17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,   /* 0x e30 */
255,255,129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,   /* 0x e40 */
184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32,   /* 0x e50 */
 67, 43,156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,   /* 0x e60 */
  0,139, 76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,   /* 0x e70 */
131,196,124, 91, 94, 95, 93, 85, 87, 86, 83,131,236,124,139,148,   /* 0x e80 */
 36,144,  0,  0,  0,199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,   /* 0x e90 */
115,  0,139,172, 36,156,  0,  0,  0,141, 66,  4,137, 68, 36,120,   /* 0x ea0 */
184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,   /* 0x eb0 */
137, 76, 36,108, 15,182, 74,  1,211,224, 72,137, 68, 36,104,139,   /* 0x ec0 */
132, 36,168,  0,  0,  0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,   /* 0x ed0 */
199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,   /* 0x ee0 */
  3,  0,  0,137,116, 36,100,199, 68, 36, 92,  1,  0,  0,  0,199,   /* 0x ef0 */
 68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,  1,  0,  0,  0,199,   /* 0x f00 */
 68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,   /* 0x f10 */
136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,139, 68, 36,120,102,   /* 0x f20 */
199,  0,  0,  4,131,192,  2,226,246,139,156, 36,148,  0,  0,  0,   /* 0x f30 */
 49,255,199, 68, 36, 72,255,255,255,255,137,218,  3,148, 36,152,   /* 0x f40 */
  0,  0,  0,137, 84, 36, 76, 49,210, 59, 92, 36, 76, 15,132,124,   /* 0x f50 */
  9,  0,  0, 15,182,  3,193,231,  8, 66, 67,  9,199,131,250,  4,   /* 0x f60 */
126,231,139,140, 36,164,  0,  0,  0, 57, 76, 36,116, 15,131,100,   /* 0x f70 */
  9,  0,  0,139,116, 36,116, 35,116, 36,108,139, 68, 36, 96,139,   /* 0x f80 */
 84, 36,120,193,224,  4,137,116, 36, 68,  1,240,129,124, 36, 72,   /* 0x f90 */
255,255,255,  0,141, 44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,   /* 0x fa0 */
  9,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,   /* 0x fb0 */
199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,202, 15,   /* 0x fc0 */
175,193, 57,199, 15,131,221,  1,  0,  0,137, 68, 36, 72,184,  0,   /* 0x fd0 */
  8,  0,  0, 41,200,138, 76, 36,100,193,248,  5,190,  1,  0,  0,   /* 0x fe0 */
  0,141,  4,  2, 15,182, 84, 36,115,102,137, 69,  0,139, 68, 36,   /* 0x ff0 */
116, 35, 68, 36,104,139,108, 36,120,211,224,185,  8,  0,  0,  0,   /* 0x1000 */
 43, 76, 36,100,211,250,  1,208,105,192,  0,  6,  0,  0,131,124,   /* 0x1010 */
 36, 96,  6,141,132,  5,108, 14,  0,  0,137, 68, 36, 20, 15,142,   /* 0x1020 */
202,  0,  0,  0,139, 68, 36,116, 43, 68, 36, 92,139,148, 36,160,   /* 0x1030 */
  0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,209,100, 36, 64,139,   /* 0x1040 */
 76, 36, 64,141, 20, 54,139,108, 36, 20,129,225,  0,  1,  0,  0,   /* 0x1050 */
129,124, 36, 72,255,255,255,  0,141, 68, 77,  0,137, 76, 36, 60,   /* 0x1060 */
141, 44, 16,119, 24, 59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,   /* 0x1070 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x1080 */
 72,102,139,141,  0,  2,  0,  0,193,232, 11, 15,183,241, 15,175,   /* 0x1090 */
198, 57,199,115, 35,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,   /* 0x10a0 */
137,214,193,248,  5,131,124, 36, 60,  0,141,  4,  1,102,137,133,   /* 0x10b0 */
  0,  2,  0,  0,116, 34,235, 46, 41, 68, 36, 72, 41,199,137,200,   /* 0x10c0 */
141,114,  1,102,193,232,  5,102, 41,193,131,124, 36, 60,  0,102,   /* 0x10d0 */
137,141,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142,   /* 0x10e0 */
 87,255,255,255,235,121,129,254,255,  0,  0,  0,127,113,141, 20,   /* 0x10f0 */
 54,139,108, 36, 20,  1,213,129,124, 36, 72,255,255,255,  0,119,   /* 0x1100 */
 24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,193,100, 36, 72,  8,   /* 0x1110 */
 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 77,   /* 0x1120 */
  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 25,137, 68,   /* 0x1130 */
 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,141,  4,   /* 0x1140 */
  1,102,137, 69,  0,235,159, 41, 68, 36, 72, 41,199,137,200,141,   /* 0x1150 */
114,  1,102,193,232,  5,102, 41,193,102,137, 77,  0,235,135,139,   /* 0x1160 */
 84, 36,116,137,240,139,140, 36,160,  0,  0,  0,136, 68, 36,115,   /* 0x1170 */
136,  4, 10, 66,131,124, 36, 96,  3,137, 84, 36,116,127, 13,199,   /* 0x1180 */
 68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,  0,131,124, 36, 96,   /* 0x1190 */
  9,127, 10,131,108, 36, 96,  3,233, 10,  7,  0,  0,131,108, 36,   /* 0x11a0 */
 96,  6,233,  0,  7,  0,  0,139, 76, 36, 72, 41,199,139,116, 36,   /* 0x11b0 */
 96, 41,193,137,208,102,193,232,  5,102, 41,194,129,249,255,255,   /* 0x11c0 */
255,  0,102,137, 85,  0,139,108, 36,120,141,116,117,  0,137,116,   /* 0x11d0 */
 36, 56,119, 22, 59, 92, 36, 76, 15,132,241,  6,  0,  0, 15,182,   /* 0x11e0 */
  3,193,231,  8,193,225,  8, 67,  9,199,139,108, 36, 56,137,200,   /* 0x11f0 */
193,232, 11,102,139,149,128,  1,  0,  0, 15,183,234, 15,175,197,   /* 0x1200 */
 57,199,115, 82,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36,   /* 0x1210 */
 88,193,248,  5,139, 76, 36, 84,141,  4,  2,139, 84, 36, 56,137,   /* 0x1220 */
 76, 36, 80,139, 76, 36,120,102,137,130,128,  1,  0,  0,139, 68,   /* 0x1230 */
 36, 92,137,108, 36, 84,137, 68, 36, 88, 49,192,131,124, 36, 96,   /* 0x1240 */
  6, 15,159,192,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,   /* 0x1250 */
 96,233,116,  2,  0,  0,137,206, 41,199, 41,198,137,208,102,193,   /* 0x1260 */
232,  5,139, 76, 36, 56,102, 41,194,129,254,255,255,255,  0,102,   /* 0x1270 */
137,145,128,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,   /* 0x1280 */
  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,108,   /* 0x1290 */
 36, 56,137,242,193,234, 11,102,139,141,152,  1,  0,  0, 15,183,   /* 0x12a0 */
193, 15,175,208, 57,215, 15,131,227,  0,  0,  0,189,  0,  8,  0,   /* 0x12b0 */
  0,137,214, 41,197,199, 68, 36, 52,  0,  8,  0,  0,137,232,193,   /* 0x12c0 */
248,  5,141,  4,  1,139, 76, 36, 56,102,137,129,152,  1,  0,  0,   /* 0x12d0 */
139, 68, 36, 96,139, 76, 36, 68,193,224,  5,  3, 68, 36,120,129,   /* 0x12e0 */
250,255,255,255,  0,141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,   /* 0x12f0 */
219,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,   /* 0x1300 */
102,139,149,224,  1,  0,  0,137,240,193,232, 11, 15,183,202, 15,   /* 0x1310 */
175,193, 57,199,115, 96, 41, 76, 36, 52,193,124, 36, 52,  5,139,   /* 0x1320 */
116, 36, 52,137, 68, 36, 72,131,124, 36,116,  0,141,  4, 50,102,   /* 0x1330 */
137,133,224,  1,  0,  0, 15,132,147,  5,  0,  0, 49,192,131,124,   /* 0x1340 */
 36, 96,  6,139,172, 36,160,  0,  0,  0,139, 84, 36,116, 15,159,   /* 0x1350 */
192,141, 68,  0,  9,137, 68, 36, 96,139, 68, 36,116, 43, 68, 36,   /* 0x1360 */
 92,138, 68,  5,  0,136, 68, 36,115,136,  4, 42, 66,137, 84, 36,   /* 0x1370 */
116,233, 49,  5,  0,  0, 41,198, 41,199,137,208,102,193,232,  5,   /* 0x1380 */
102, 41,194,102,137,149,224,  1,  0,  0,233, 31,  1,  0,  0,137,   /* 0x1390 */
200, 41,214,102,193,232,  5,139,108, 36, 56,102, 41,193, 41,215,   /* 0x13a0 */
129,254,255,255,255,  0,102,137,141,152,  1,  0,  0,119, 22, 59,   /* 0x13b0 */
 92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,  3,193,231,  8,193,   /* 0x13c0 */
230,  8, 67,  9,199,139, 76, 36, 56,137,240,193,232, 11,102,139,   /* 0x13d0 */
145,176,  1,  0,  0, 15,183,202, 15,175,193, 57,199,115, 35,137,   /* 0x13e0 */
198,184,  0,  8,  0,  0, 41,200,139,108, 36, 56,193,248,  5,141,   /* 0x13f0 */
  4,  2,102,137,133,176,  1,  0,  0,139, 68, 36, 88,233,160,  0,   /* 0x1400 */
  0,  0,137,241, 41,199, 41,193,137,208,102,193,232,  5,102, 41,   /* 0x1410 */
194,139, 68, 36, 56,129,249,255,255,255,  0,102,137,144,176,  1,   /* 0x1420 */
  0,  0,119, 22, 59, 92, 36, 76, 15,132,161,  4,  0,  0, 15,182,   /* 0x1430 */
  3,193,231,  8,193,225,  8, 67,  9,199,139,116, 36, 56,137,200,   /* 0x1440 */
193,232, 11,102,139,150,200,  1,  0,  0, 15,183,234, 15,175,197,   /* 0x1450 */
 57,199,115, 32,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36,   /* 0x1460 */
 56,193,248,  5,141,  4,  2,102,137,133,200,  1,  0,  0,139, 68,   /* 0x1470 */
 36, 84,235, 38,137,206, 41,199, 41,198,137,208,102,193,232,  5,   /* 0x1480 */
102, 41,194,139, 68, 36, 56,102,137,144,200,  1,  0,  0,139, 84,   /* 0x1490 */
 36, 84,139, 68, 36, 80,137, 84, 36, 80,139, 76, 36, 88,137, 76,   /* 0x14a0 */
 36, 84,139,108, 36, 92,137, 68, 36, 92,137,108, 36, 88, 49,192,   /* 0x14b0 */
131,124, 36, 96,  6,139, 76, 36,120, 15,159,192,129,193,104, 10,   /* 0x14c0 */
  0,  0,141, 68, 64,  8,137, 68, 36, 96,129,254,255,255,255,  0,   /* 0x14d0 */
119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,  0, 15,182,  3,193,   /* 0x14e0 */
231,  8,193,230,  8, 67,  9,199,102,139, 17,137,240,193,232, 11,   /* 0x14f0 */
 15,183,234, 15,175,197, 57,199,115, 47,137, 68, 36, 72,184,  0,   /* 0x1500 */
  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36,   /* 0x1510 */
 44,  0,  0,  0,  0,141,  4,  2,102,137,  1,139, 68, 36, 68,141,   /* 0x1520 */
 76,  1,  4,137, 76, 36, 16,235,114, 41,198, 41,199,137,208,102,   /* 0x1530 */
193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 17,119,   /* 0x1540 */
 22, 59, 92, 36, 76, 15,132,132,  3,  0,  0, 15,182,  3,193,231,   /* 0x1550 */
  8,193,230,  8, 67,  9,199,102,139, 81,  2,137,240,193,232, 11,   /* 0x1560 */
 15,183,234, 15,175,197, 57,199,115, 59,137, 68, 36, 72,184,  0,   /* 0x1570 */
  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36,   /* 0x1580 */
 44,  8,  0,  0,  0,141,  4,  2,139, 84, 36, 68,102,137, 65,  2,   /* 0x1590 */
141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,   /* 0x15a0 */
  0,  0,  0,235, 47, 41,198, 41,199,137,208,137,116, 36, 72,102,   /* 0x15b0 */
193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,102, 41,194,199, 68,   /* 0x15c0 */
 36, 48,  8,  0,  0,  0,102,137, 81,  2,129,193,  4,  2,  0,  0,   /* 0x15d0 */
137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,  0,  0,137, 76, 36,   /* 0x15e0 */
 40,141, 44, 18,139,116, 36, 16,  1,238,129,124, 36, 72,255,255,   /* 0x15f0 */
255,  0,119, 24, 59, 92, 36, 76, 15,132,209,  2,  0,  0,193,100,   /* 0x1600 */
 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,   /* 0x1610 */
102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,   /* 0x1620 */
137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,   /* 0x1630 */
  2,137,234,102,137,  6,235, 21, 41, 68, 36, 72, 41,199,137,208,   /* 0x1640 */
102,193,232,  5,102, 41,194,102,137, 22,141, 85,  1,139,116, 36,   /* 0x1650 */
 40, 78,137,116, 36, 40,117,137,138, 76, 36, 48,184,  1,  0,  0,   /* 0x1660 */
  0,211,224, 41,194,  3, 84, 36, 44,131,124, 36, 96,  3,137, 84,   /* 0x1670 */
 36, 12, 15,143,231,  1,  0,  0,131, 68, 36, 96,  7,131,250,  3,   /* 0x1680 */
137,208,126,  5,184,  3,  0,  0,  0,139,116, 36,120,193,224,  7,   /* 0x1690 */
199, 68, 36, 36,  6,  0,  0,  0,141,132,  6, 96,  3,  0,  0,137,   /* 0x16a0 */
 68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,139,116, 36,  8,  1,   /* 0x16b0 */
238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,   /* 0x16c0 */
132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,   /* 0x16d0 */
 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202,   /* 0x16e0 */
 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0,   /* 0x16f0 */
 41,200,193,248,  5,141,  4,  2,102,137,  6,137,232,235, 21, 41,   /* 0x1700 */
 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,141, 69,   /* 0x1710 */
  1,102,137, 22,139,108, 36, 36, 77,137,108, 36, 36,117,137,141,   /* 0x1720 */
 80,192,131,250,  3,137, 20, 36, 15,142, 39,  1,  0,  0,137,208,   /* 0x1730 */
137,214,209,248,131,230,  1,141, 72,255,131,206,  2,131,250, 13,   /* 0x1740 */
137, 76, 36, 32,127, 28,139,108, 36,120,211,230,  1,210,137, 52,   /* 0x1750 */
 36,141, 68,117,  0, 41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,   /* 0x1760 */
235, 86,141, 80,251,129,124, 36, 72,255,255,255,  0,119, 24, 59,   /* 0x1770 */
 92, 36, 76, 15,132, 86,  1,  0,  0,193,100, 36, 72,  8, 15,182,   /* 0x1780 */
  3,193,231,  8, 67,  9,199,209,108, 36, 72,  1,246, 59,124, 36,   /* 0x1790 */
 72,114,  7, 43,124, 36, 72,131,206,  1, 74,117,200,139, 68, 36,   /* 0x17a0 */
120,193,230,  4,137, 52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,   /* 0x17b0 */
  4,  0,  0,  0,137, 68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,   /* 0x17c0 */
184,  1,  0,  0,  0,139,108, 36,  4,  1,192,137, 68, 36, 24,  1,   /* 0x17d0 */
197,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,   /* 0x17e0 */
132,234,  0,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,   /* 0x17f0 */
 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,   /* 0x1800 */
242, 15,175,198, 57,199,115, 27,137, 68, 36, 72,184,  0,  8,  0,   /* 0x1810 */
  0, 41,240,193,248,  5,141,  4,  2,102,137, 69,  0,139, 68, 36,   /* 0x1820 */
 24,235, 31, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102,   /* 0x1830 */
 41,194,139, 68, 36, 24,102,137, 85,  0,139, 84, 36, 28, 64,  9,   /* 0x1840 */
 20, 36,139, 76, 36, 32,209,100, 36, 28, 73,137, 76, 36, 32, 15,   /* 0x1850 */
133,112,255,255,255,139, 52, 36, 70,137,116, 36, 92,116, 89,139,   /* 0x1860 */
 76, 36, 12,139,108, 36,116,131,193,  2, 57,108, 36, 92,119, 95,   /* 0x1870 */
139,132, 36,160,  0,  0,  0,137,234, 43, 68, 36, 92,  3,148, 36,   /* 0x1880 */
160,  0,  0,  0,141, 52, 40,138,  6, 70,136, 68, 36,115,136,  2,   /* 0x1890 */
 66,255, 68, 36,116, 73,116, 15,139,172, 36,164,  0,  0,  0, 57,   /* 0x18a0 */
108, 36,116,114,226,235, 17,139,132, 36,164,  0,  0,  0, 57, 68,   /* 0x18b0 */
 36,116, 15,130,187,246,255,255,129,124, 36, 72,255,255,255,  0,   /* 0x18c0 */
119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,116, 41,235,  7,184,   /* 0x18d0 */
  1,  0,  0,  0,235, 32, 67, 43,156, 36,148,  0,  0,  0, 49,192,   /* 0x18e0 */
139,148, 36,156,  0,  0,  0,139, 76, 36,116,137, 26,139,156, 36,   /* 0x18f0 */
168,  0,  0,  0,137, 11,131,196,124, 91, 94, 95, 93,  3,115,252,   /* 0x1900 */
  3,123,248, 49,192,141,140, 36,  0,255,255,255,137,236, 80, 57,   /* 0x1910 */
204,117,251,137,236, 49,201, 93, 86,141,181,  0,  0,  0,  0, 86,   /* 0x1920 */
141,189,  0,  0,  0,  0,137,239,185,  0,  0,  0,  0,138,  7, 71,   /* 0x1930 */
 44,232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138, 95,  4,   /* 0x1940 */
102,193,232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,   /* 0x1950 */
  1,232,137,  7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,   /* 0x1960 */
176,232,176,233,242,174,117,  6,128, 63,  0,117,255,139,  7,102,   /* 0x1970 */
193,232,  8,134,196,193,192, 16,134,196, 41,248,  1,232,171,235,   /* 0x1980 */
  4,185,  0,  0,  0,  0,235, 30,138,  7,131,199,  1, 60,128,114,   /* 0x1990 */
 10, 60,143,119,  6,128,127,254, 15,116,  5, 44,232, 60,  1,119,   /* 0x19a0 */
255,128, 63,  0,117,255,139,  7,102,193,232,  8,193,192, 16,134,   /* 0x19b0 */
196, 41,248,  1,232,137,  7,131,199,  4,131,233,  4,138,  7,131,   /* 0x19c0 */
199,  1,226, 13,131,233,  1,127,  6,141,125,252, 49,192,138,  6,   /* 0x19d0 */
 70,  9,192,116,  1, 60,239,119, 17,  1,199,139,  7,134,196,193,   /* 0x19e0 */
192, 16,134,196,  1,232,137,  7,235,226, 36, 15,193,224, 16,102,   /* 0x19f0 */
139,  6,131,198,  2,  9,192,117, 12,139,  6,131,198,  4,235, 12,   /* 0x1a00 */
255,214, 95, 89, 41,249,193,233,  2,243,171,  7,141,165,  0,  0,   /* 0x1a10 */
  0,  0,233,252,255,255,255,116,109,112, 47,105, 51, 56, 54, 45,   /* 0x1a20 */
100,111,115, 51, 50, 46,119, 97,116, 99,111,109, 46,108,101, 46,   /* 0x1a30 */
 98,105,110, 58, 32, 32, 32, 32, 32,102,105,108,101, 32,102,111,   /* 0x1a40 */
114,109, 97,116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10,   /* 0x1a50 */
 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78,   /* 0x1a60 */
 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,   /* 0x1a70 */
101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32,   /* 0x1a80 */
 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,   /* 0x1a90 */
111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115,   /* 0x1aa0 */
 10, 32, 32, 48, 32, 87, 67, 76, 69, 77, 65, 73, 78, 32, 32, 32,   /* 0x1ab0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 57, 32, 32, 48, 48, 48,   /* 0x1ac0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1ad0 */
 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32,   /* 0x1ae0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x1af0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 87,   /* 0x1b00 */
 67, 76, 69, 77, 65, 73, 78, 48, 50, 32, 32, 32, 32, 48, 48, 48,   /* 0x1b10 */
 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1b20 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1b30 */
 48, 53,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1b40 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,   /* 0x1b50 */
 50, 32, 87, 67, 76, 69, 77, 65, 73, 78, 48, 51, 32, 32, 32, 32,   /* 0x1b60 */
 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1b70 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1b80 */
 48, 48, 48, 48, 54, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x1b90 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x1ba0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 85, 80, 88, 49,   /* 0x1bb0 */
 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1bc0 */
 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1bd0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 54,   /* 0x1be0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1bf0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 87,   /* 0x1c00 */
 67, 76, 69, 67, 85, 84, 80, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1c10 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1c20 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1c30 */
 48, 56, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1c40 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,   /* 0x1c50 */
 53, 32, 78, 50, 66, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32,   /* 0x1c60 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1c70 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1c80 */
 48, 48, 48, 48, 56, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x1c90 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x1ca0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 78, 50, 66, 70,   /* 0x1cb0 */
 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1cc0 */
 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1cd0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 57,   /* 0x1ce0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1cf0 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1d00 */
 89, 10, 32, 32, 55, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 32,   /* 0x1d10 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48,   /* 0x1d20 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1d30 */
 32, 32, 48, 48, 48, 48, 48, 48, 56, 98, 32, 32, 50, 42, 42, 48,   /* 0x1d40 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x1d50 */
 79, 78, 76, 89, 10, 32, 32, 56, 32, 78, 50, 66, 68, 69, 67, 49,   /* 0x1d60 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32,   /* 0x1d70 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1d80 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 49, 32, 32, 50,   /* 0x1d90 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x1da0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 78, 50, 66, 83,   /* 0x1db0 */
 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1dc0 */
 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1dd0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 99,   /* 0x1de0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1df0 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1e00 */
 89, 10, 32, 49, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 32,   /* 0x1e10 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48,   /* 0x1e20 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e30 */
 32, 32, 48, 48, 48, 48, 48, 48, 97, 49, 32, 32, 50, 42, 42, 48,   /* 0x1e40 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x1e50 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32,   /* 0x1e60 */
 78, 50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x1e70 */
 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e80 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1e90 */
 48, 48, 97, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1ea0 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x1eb0 */
 49, 50, 32, 78, 50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32,   /* 0x1ec0 */
 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48,   /* 0x1ed0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1ee0 */
 48, 48, 48, 48, 48, 98, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1ef0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x1f00 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 78, 50, 66,   /* 0x1f10 */
 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x1f20 */
 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1f30 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 99,   /* 0x1f40 */
 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x1f50 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x1f60 */
 76, 89, 10, 32, 49, 52, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32,   /* 0x1f70 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51,101, 32, 32, 48,   /* 0x1f80 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f90 */
 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 51, 32, 32, 50, 42, 42,   /* 0x1fa0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x1fb0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 53,   /* 0x1fc0 */
 32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x1fd0 */
 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1fe0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1ff0 */
 48, 48, 49, 49, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2000 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x2010 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 54, 32, 78, 50, 66, 70, 65,   /* 0x2020 */
 83, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2030 */
102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2040 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49,101, 32,   /* 0x2050 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2060 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2070 */
 10, 32, 49, 55, 32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32,   /* 0x2080 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x2090 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x20a0 */
 32, 48, 48, 48, 48, 48, 49, 50,100, 32, 32, 50, 42, 42, 48, 32,   /* 0x20b0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x20c0 */
 78, 76, 89, 10, 32, 49, 56, 32, 78, 50, 66, 70, 65, 83, 53, 48,   /* 0x20d0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32,   /* 0x20e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x20f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 50,102, 32, 32, 50, 42,   /* 0x2100 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2110 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32, 78, 50, 66, 68, 69,   /* 0x2120 */
 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2130 */
 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2140 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51, 50, 32,   /* 0x2150 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2160 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 48, 32, 78, 50,   /* 0x2170 */
 66, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2180 */
 48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2190 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,   /* 0x21a0 */
 51, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x21b0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x21c0 */
 78, 76, 89, 10, 32, 50, 49, 32, 78, 50, 66, 70, 65, 83, 54, 48,   /* 0x21d0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 57, 32, 32,   /* 0x21e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x21f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 52, 55, 32, 32, 50, 42,   /* 0x2200 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2210 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,   /* 0x2220 */
 50, 32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32,   /* 0x2230 */
 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2240 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2250 */
 48, 48, 48, 49, 54, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2260 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x2270 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 78, 50, 66, 68,   /* 0x2280 */
 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2290 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x22a0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55, 54,   /* 0x22b0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x22c0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 52, 32, 78,   /* 0x22d0 */
 50, 68, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x22e0 */
 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x22f0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2300 */
 49, 55, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2310 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x2320 */
 79, 78, 76, 89, 10, 32, 50, 53, 32, 78, 50, 68, 70, 65, 83, 49,   /* 0x2330 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,   /* 0x2340 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2350 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55, 57, 32, 32, 50,   /* 0x2360 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2370 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2380 */
 50, 54, 32, 78, 50, 68, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32,   /* 0x2390 */
 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48,   /* 0x23a0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x23b0 */
 48, 48, 48, 48, 49, 55, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x23c0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x23d0 */
 89, 10, 32, 50, 55, 32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 32,   /* 0x23e0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48,   /* 0x23f0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2400 */
 32, 32, 48, 48, 48, 48, 48, 49, 56, 49, 32, 32, 50, 42, 42, 48,   /* 0x2410 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x2420 */
 79, 78, 76, 89, 10, 32, 50, 56, 32, 78, 50, 68, 83, 77, 65, 50,   /* 0x2430 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,   /* 0x2440 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2450 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 56, 99, 32, 32, 50,   /* 0x2460 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2470 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2480 */
 50, 57, 32, 78, 50, 68, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32,   /* 0x2490 */
 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48,   /* 0x24a0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x24b0 */
 48, 48, 48, 48, 49, 57, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x24c0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x24d0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32, 78, 50, 68,   /* 0x24e0 */
 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x24f0 */
 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2500 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 57,   /* 0x2510 */
 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2520 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 49, 32,   /* 0x2530 */
 78, 50, 68, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2540 */
 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2550 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2560 */
 48, 49, 97, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2570 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x2580 */
 68, 79, 78, 76, 89, 10, 32, 51, 50, 32, 78, 50, 68, 70, 65, 83,   /* 0x2590 */
 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102,   /* 0x25a0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x25b0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 98, 52, 32, 32,   /* 0x25c0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x25d0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x25e0 */
 32, 51, 51, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32,   /* 0x25f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 53, 50, 32, 32, 48, 48, 48, 48,   /* 0x2600 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2610 */
 48, 48, 48, 48, 48, 49, 99, 51, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2620 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x2630 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 52, 32, 78, 50,   /* 0x2640 */
 68, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2650 */
 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2660 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x2670 */
 49, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2680 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x2690 */
 78, 76, 89, 10, 32, 51, 53, 32, 78, 50, 68, 70, 65, 83, 52, 48,   /* 0x26a0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32,   /* 0x26b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x26c0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 50, 50, 32, 32, 50, 42,   /* 0x26d0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x26e0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,   /* 0x26f0 */
 54, 32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32,   /* 0x2700 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2710 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2720 */
 48, 48, 48, 50, 51, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2730 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2740 */
 10, 32, 51, 55, 32, 78, 50, 68, 70, 65, 83, 53, 48, 32, 32, 32,   /* 0x2750 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,   /* 0x2760 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2770 */
 32, 48, 48, 48, 48, 48, 50, 51, 51, 32, 32, 50, 42, 42, 48, 32,   /* 0x2780 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x2790 */
 78, 76, 89, 10, 32, 51, 56, 32, 78, 50, 68, 68, 69, 67, 53, 48,   /* 0x27a0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32,   /* 0x27b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x27c0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 51, 54, 32, 32, 50, 42,   /* 0x27d0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x27e0 */
 65, 68, 79, 78, 76, 89, 10, 32, 51, 57, 32, 78, 50, 68, 83, 77,   /* 0x27f0 */
 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2800 */
 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2810 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 51,102, 32,   /* 0x2820 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2830 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2840 */
 10, 32, 52, 48, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 32, 32,   /* 0x2850 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48,   /* 0x2860 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2870 */
 32, 48, 48, 48, 48, 48, 50, 52, 98, 32, 32, 50, 42, 42, 48, 32,   /* 0x2880 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x2890 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 49, 32, 78,   /* 0x28a0 */
 50, 68, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x28b0 */
 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x28c0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x28d0 */
 50, 54, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x28e0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x28f0 */
 79, 78, 76, 89, 10, 32, 52, 50, 32, 78, 50, 68, 68, 69, 67, 54,   /* 0x2900 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2910 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2920 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 55, 97, 32, 32, 50,   /* 0x2930 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2940 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 51, 32, 78, 50, 69, 83,   /* 0x2950 */
 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2960 */
 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2970 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 55, 97,   /* 0x2980 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2990 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x29a0 */
 89, 10, 32, 52, 52, 32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32,   /* 0x29b0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,   /* 0x29c0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x29d0 */
 32, 32, 48, 48, 48, 48, 48, 50, 55,100, 32, 32, 50, 42, 42, 48,   /* 0x29e0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x29f0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 53, 32,   /* 0x2a00 */
 78, 50, 69, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2a10 */
 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2a20 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2a30 */
 48, 50, 55,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2a40 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2a50 */
 52, 54, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32,   /* 0x2a60 */
 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48,   /* 0x2a70 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2a80 */
 48, 48, 48, 48, 50, 56, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2a90 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2aa0 */
 89, 10, 32, 52, 55, 32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 32,   /* 0x2ab0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48,   /* 0x2ac0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2ad0 */
 32, 32, 48, 48, 48, 48, 48, 50, 57, 48, 32, 32, 50, 42, 42, 48,   /* 0x2ae0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x2af0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 56, 32,   /* 0x2b00 */
 78, 50, 69, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2b10 */
 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2b20 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2b30 */
 48, 50, 57, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2b40 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x2b50 */
 68, 79, 78, 76, 89, 10, 32, 52, 57, 32, 78, 50, 69, 68, 69, 67,   /* 0x2b60 */
 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100,   /* 0x2b70 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2b80 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 57,101, 32, 32,   /* 0x2b90 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x2ba0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 48, 32, 78, 50, 69,   /* 0x2bb0 */
 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2bc0 */
 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2bd0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 97,   /* 0x2be0 */
 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2bf0 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x2c00 */
 76, 89, 10, 32, 53, 49, 32, 78, 50, 69, 70, 65, 83, 51, 48, 32,   /* 0x2c10 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48,   /* 0x2c20 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2c30 */
 48, 32, 32, 48, 48, 48, 48, 48, 50, 98, 56, 32, 32, 50, 42, 42,   /* 0x2c40 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x2c50 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 50,   /* 0x2c60 */
 32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x2c70 */
 48, 48, 48, 48, 48, 53,102, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2c80 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2c90 */
 48, 48, 50, 99, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2ca0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x2cb0 */
 65, 68, 79, 78, 76, 89, 10, 32, 53, 51, 32, 78, 50, 69, 83, 77,   /* 0x2cc0 */
 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2cd0 */
100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2ce0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 50, 54, 32,   /* 0x2cf0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2d00 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2d10 */
 10, 32, 53, 52, 32, 78, 50, 69, 70, 65, 83, 52, 48, 32, 32, 32,   /* 0x2d20 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48,   /* 0x2d30 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2d40 */
 32, 48, 48, 48, 48, 48, 51, 51, 51, 32, 32, 50, 42, 42, 48, 32,   /* 0x2d50 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x2d60 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 53, 32, 78,   /* 0x2d70 */
 50, 69, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2d80 */
 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2d90 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2da0 */
 51, 52, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2db0 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53,   /* 0x2dc0 */
 54, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32,   /* 0x2dd0 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2de0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2df0 */
 48, 48, 48, 51, 52, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2e00 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2e10 */
 10, 32, 53, 55, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 32, 32,   /* 0x2e20 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48,   /* 0x2e30 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2e40 */
 32, 48, 48, 48, 48, 48, 51, 52, 55, 32, 32, 50, 42, 42, 48, 32,   /* 0x2e50 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x2e60 */
 78, 76, 89, 10, 32, 53, 56, 32, 78, 50, 69, 83, 77, 65, 54, 48,   /* 0x2e70 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32,   /* 0x2e80 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2e90 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 53, 48, 32, 32, 50, 42,   /* 0x2ea0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2eb0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53,   /* 0x2ec0 */
 57, 32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32,   /* 0x2ed0 */
 48, 48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2ee0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2ef0 */
 48, 48, 48, 51, 53, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2f00 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x2f10 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 48, 32, 78, 50, 69, 70,   /* 0x2f20 */
 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2f30 */
 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2f40 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 55, 53,   /* 0x2f50 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2f60 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2f70 */
 89, 10, 32, 54, 49, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32,   /* 0x2f80 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2f90 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2fa0 */
 32, 32, 48, 48, 48, 48, 48, 51, 56, 98, 32, 32, 50, 42, 42, 48,   /* 0x2fb0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x2fc0 */
 79, 78, 76, 89, 10, 32, 54, 50, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x2fd0 */
 67, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,101, 32,   /* 0x2fe0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2ff0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 56, 98, 32, 32, 50,   /* 0x3000 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3010 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x3020 */
 54, 51, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32,   /* 0x3030 */
 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 48, 48, 48, 48, 48,   /* 0x3040 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3050 */
 48, 48, 48, 48, 51, 98, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x3060 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x3070 */
 89, 10, 32, 54, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x3080 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48, 48,   /* 0x3090 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x30a0 */
 32, 32, 48, 48, 48, 48, 48, 52, 48, 49, 32, 32, 50, 42, 42, 48,   /* 0x30b0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x30c0 */
 79, 78, 76, 89, 10, 32, 54, 53, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x30d0 */
 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32,   /* 0x30e0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x30f0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 56, 55, 32, 32, 50,   /* 0x3100 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3110 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 54, 32, 76, 90, 77, 65,   /* 0x3120 */
 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3130 */
 49, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3140 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 48,100,   /* 0x3150 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x3160 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 55, 32, 87,   /* 0x3170 */
 67, 76, 69, 77, 65, 73, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x3180 */
 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3190 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x31a0 */
 57, 50, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x31b0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x31c0 */
 79, 78, 76, 89, 10, 32, 54, 56, 32, 87, 67, 67, 84, 84, 80, 79,   /* 0x31d0 */
 83, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32,   /* 0x31e0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x31f0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 51, 48, 32, 32, 50,   /* 0x3200 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3210 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x3220 */
 54, 57, 32, 87, 67, 67, 84, 84, 78, 85, 76, 32, 32, 32, 32, 32,   /* 0x3230 */
 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,   /* 0x3240 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3250 */
 48, 48, 48, 49, 57, 51, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x3260 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x3270 */
 89, 10, 32, 55, 48, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 32,   /* 0x3280 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48,   /* 0x3290 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x32a0 */
 32, 32, 48, 48, 48, 48, 49, 57, 51, 56, 32, 32, 50, 42, 42, 48,   /* 0x32b0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x32c0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 49, 32,   /* 0x32d0 */
 67, 84, 67, 76, 69, 86, 69, 49, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x32e0 */
 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x32f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3300 */
 49, 57, 52, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3310 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3320 */
 68, 79, 78, 76, 89, 10, 32, 55, 50, 32, 67, 65, 76, 76, 84, 82,   /* 0x3330 */
 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53,   /* 0x3340 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3350 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 52, 98, 32, 32,   /* 0x3360 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3370 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 51, 32, 67, 84, 66,   /* 0x3380 */
 83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3390 */
 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x33a0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 53,   /* 0x33b0 */
 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x33c0 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 52, 32,   /* 0x33d0 */
 67, 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x33e0 */
 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x33f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3400 */
 49, 57, 53, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3410 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x3420 */
 55, 53, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32,   /* 0x3430 */
 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48,   /* 0x3440 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3450 */
 48, 48, 48, 49, 57, 53, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x3460 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x3470 */
 89, 10, 32, 55, 54, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32,   /* 0x3480 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48,   /* 0x3490 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x34a0 */
 32, 32, 48, 48, 48, 48, 49, 57, 53, 98, 32, 32, 50, 42, 42, 48,   /* 0x34b0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x34c0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 55, 32,   /* 0x34d0 */
 67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x34e0 */
 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x34f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3500 */
 49, 57, 54, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3510 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3520 */
 68, 79, 78, 76, 89, 10, 32, 55, 56, 32, 67, 65, 76, 76, 84, 82,   /* 0x3530 */
 69, 56, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0x3540 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3550 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55, 48, 32, 32,   /* 0x3560 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3570 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 57, 32, 67, 65, 76,   /* 0x3580 */
 76, 84, 82, 69, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3590 */
 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x35a0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55,   /* 0x35b0 */
 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x35c0 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 48, 32,   /* 0x35d0 */
 67, 65, 76, 76, 84, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x35e0 */
 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x35f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3600 */
 49, 57, 55, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3610 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3620 */
 68, 79, 78, 76, 89, 10, 32, 56, 49, 32, 67, 84, 67, 76, 69, 86,   /* 0x3630 */
 69, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53,   /* 0x3640 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3650 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55, 56, 32, 32,   /* 0x3660 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3670 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3680 */
 32, 56, 50, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32,   /* 0x3690 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x36a0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x36b0 */
 48, 48, 48, 48, 49, 57, 55,100, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x36c0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x36d0 */
 76, 89, 10, 32, 56, 51, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32,   /* 0x36e0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48,   /* 0x36f0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3700 */
 48, 32, 32, 48, 48, 48, 48, 49, 57, 55,102, 32, 32, 50, 42, 42,   /* 0x3710 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x3720 */
 68, 79, 78, 76, 89, 10, 32, 56, 52, 32, 67, 84, 66, 82, 79, 82,   /* 0x3730 */
 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0x3740 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3750 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 56, 51, 32, 32,   /* 0x3760 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3770 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 53, 32, 67, 84, 66,   /* 0x3780 */
 83, 87, 65, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3790 */
 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x37a0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 56,   /* 0x37b0 */
 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x37c0 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 54, 32,   /* 0x37d0 */
 67, 65, 76, 76, 84, 82, 49, 51, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x37e0 */
 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x37f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3800 */
 49, 57, 56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3810 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3820 */
 68, 79, 78, 76, 89, 10, 32, 56, 55, 32, 99,116,111,107, 51, 50,   /* 0x3830 */
 46, 48, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99,   /* 0x3840 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3850 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 57, 49, 32, 32,   /* 0x3860 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x3870 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x3880 */
 32, 56, 56, 32, 99,116,111,107, 51, 50, 46, 49, 48, 32, 32, 32,   /* 0x3890 */
 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48,   /* 0x38a0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x38b0 */
 48, 48, 48, 48, 49, 57, 57,100, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x38c0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x38d0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 57, 32, 99,116,   /* 0x38e0 */
111,107, 51, 50, 46, 50, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x38f0 */
 48, 48, 50, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3900 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,   /* 0x3910 */
 97, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3920 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x3930 */
 78, 76, 89, 10, 32, 57, 48, 32, 99,116,111,107, 51, 50, 46, 51,   /* 0x3940 */
 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32,   /* 0x3950 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3960 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 99,100, 32, 32, 50, 42,   /* 0x3970 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3980 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57,   /* 0x3990 */
 49, 32, 99,116,111,107, 51, 50, 46, 52, 48, 32, 32, 32, 32, 32,   /* 0x39a0 */
 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x39b0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x39c0 */
 48, 48, 49, 57,100, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x39d0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x39e0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 50, 32, 87, 67, 82, 69,   /* 0x39f0 */
 76, 79, 67, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3a00 */
 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3a10 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,100, 57,   /* 0x3a20 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x3a30 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 51, 32, 82,   /* 0x3a40 */
 69, 76, 79, 67, 51, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x3a50 */
 48, 48, 48, 50, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3a60 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x3a70 */
 57,100, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x3a80 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x3a90 */
 79, 78, 76, 89, 10, 32, 57, 52, 32, 82, 69, 76, 51, 50, 66, 73,   /* 0x3aa0 */
 71, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32,   /* 0x3ab0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3ac0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 48, 53, 32, 32, 50,   /* 0x3ad0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3ae0 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x3af0 */
 57, 53, 32, 82, 69, 76, 79, 67, 51, 50, 74, 32, 32, 32, 32, 32,   /* 0x3b00 */
 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,   /* 0x3b10 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3b20 */
 48, 48, 48, 49, 97, 48,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x3b30 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x3b40 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 54, 32, 82, 69, 76,   /* 0x3b50 */
 51, 50, 69, 78, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3b60 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3b70 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 49,   /* 0x3b80 */
 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x3b90 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 55, 32,   /* 0x3ba0 */
 87, 67, 82, 69, 76, 83, 69, 76, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x3bb0 */
 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3bc0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3bd0 */
 49, 97, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3be0 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x3bf0 */
 57, 56, 32, 87, 67, 76, 69, 77, 65, 73, 52, 32, 32, 32, 32, 32,   /* 0x3c00 */
 32, 48, 48, 48, 48, 48, 48, 49, 53, 32, 32, 48, 48, 48, 48, 48,   /* 0x3c10 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3c20 */
 48, 48, 48, 49, 97, 49, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x3c30 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x3c40 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32,   /* 0x3c50 */
 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3c60 */
108, 32, 32, 32, 32,100, 32, 32, 87, 67, 76, 69, 67, 85, 84, 80,   /* 0x3c70 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 87, 67, 76, 69, 67, 85,   /* 0x3c80 */
 84, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3c90 */
 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48,  9, 48, 48, 48,   /* 0x3ca0 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 48,   /* 0x3cb0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3cc0 */
 78, 50, 66, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3cd0 */
 48, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48,   /* 0x3ce0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68,   /* 0x3cf0 */
 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3d00 */
 66, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3d10 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48,   /* 0x3d20 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67,   /* 0x3d30 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3d40 */
 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,  9, 48, 48, 48,   /* 0x3d50 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48,   /* 0x3d60 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3d70 */
 78, 50, 66, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3d80 */
 48, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,   /* 0x3d90 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,   /* 0x3da0 */
 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3db0 */
 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3dc0 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 54, 48,   /* 0x3dd0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67,   /* 0x3de0 */
 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3df0 */
 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48,  9, 48, 48, 48,   /* 0x3e00 */
 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 48,   /* 0x3e10 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3e20 */
 78, 50, 68, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3e30 */
 48, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48,   /* 0x3e40 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68,   /* 0x3e50 */
 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3e60 */
 68, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3e70 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48,   /* 0x3e80 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67,   /* 0x3e90 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3ea0 */
 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,  9, 48, 48, 48,   /* 0x3eb0 */
 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48,   /* 0x3ec0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3ed0 */
 78, 50, 68, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3ee0 */
 48, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,   /* 0x3ef0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70,   /* 0x3f00 */
 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3f10 */
 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3f20 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48,   /* 0x3f30 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67,   /* 0x3f40 */
 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3f50 */
 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48,  9, 48, 48, 48,   /* 0x3f60 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 48,   /* 0x3f70 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3f80 */
 78, 50, 69, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3f90 */
 48, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48,   /* 0x3fa0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68,   /* 0x3fb0 */
 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3fc0 */
 69, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3fd0 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48,   /* 0x3fe0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67,   /* 0x3ff0 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4000 */
 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,  9, 48, 48, 48,   /* 0x4010 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48,   /* 0x4020 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4030 */
 78, 50, 69, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4040 */
 48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,   /* 0x4050 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,   /* 0x4060 */
 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4070 */
 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4080 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48,   /* 0x4090 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67,   /* 0x40a0 */
 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x40b0 */
 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48,  9, 48, 48, 48,   /* 0x40c0 */
 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 48,   /* 0x40d0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x40e0 */
 67, 65, 76, 76, 84, 82, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x40f0 */
 48, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x4100 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76,   /* 0x4110 */
 84, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65,   /* 0x4120 */
 76, 76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4130 */
108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51,   /* 0x4140 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82,   /* 0x4150 */
 49, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4160 */
 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48,  9, 48, 48,   /* 0x4170 */
 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 48, 48,   /* 0x4180 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4190 */
 32, 32, 99,116,111,107, 51, 50, 46, 49, 48,  9, 48, 48, 48, 48,   /* 0x41a0 */
 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 48,   /* 0x41b0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x41c0 */
 99,116,111,107, 51, 50, 46, 50, 48,  9, 48, 48, 48, 48, 48, 48,   /* 0x41d0 */
 48, 48, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 48, 48, 48,   /* 0x41e0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,   /* 0x41f0 */
111,107, 51, 50, 46, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4200 */
 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48,   /* 0x4210 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 79,   /* 0x4220 */
 67, 51, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 69,   /* 0x4230 */
 76, 79, 67, 51, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4240 */
108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 79, 67, 51, 50, 74,   /* 0x4250 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 69, 76, 79, 67, 51,   /* 0x4260 */
 50, 74, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4270 */
 32,100, 32, 32, 87, 67, 76, 69, 77, 65, 73, 78,  9, 48, 48, 48,   /* 0x4280 */
 48, 48, 48, 48, 48, 32, 87, 67, 76, 69, 77, 65, 73, 78, 10, 48,   /* 0x4290 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x42a0 */
 87, 67, 76, 69, 77, 65, 73, 78, 48, 50,  9, 48, 48, 48, 48, 48,   /* 0x42b0 */
 48, 48, 48, 32, 87, 67, 76, 69, 77, 65, 73, 78, 48, 50, 10, 48,   /* 0x42c0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x42d0 */
 87, 67, 76, 69, 77, 65, 73, 78, 48, 51,  9, 48, 48, 48, 48, 48,   /* 0x42e0 */
 48, 48, 48, 32, 87, 67, 76, 69, 77, 65, 73, 78, 48, 51, 10, 48,   /* 0x42f0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4300 */
 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4310 */
 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48,   /* 0x4320 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,   /* 0x4330 */
 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4340 */
 66, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4350 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 50, 48,   /* 0x4360 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65,   /* 0x4370 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4380 */
 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48,  9, 48, 48, 48,   /* 0x4390 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48,   /* 0x43a0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x43b0 */
 78, 50, 66, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x43c0 */
 48, 32, 78, 50, 66, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48,   /* 0x43d0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,   /* 0x43e0 */
 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x43f0 */
 66, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4400 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48,   /* 0x4410 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65,   /* 0x4420 */
 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4430 */
 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 52, 48,  9, 48, 48, 48,   /* 0x4440 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10, 48,   /* 0x4450 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4460 */
 78, 50, 66, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4470 */
 48, 32, 78, 50, 66, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48,   /* 0x4480 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,   /* 0x4490 */
 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x44a0 */
 66, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x44b0 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 54, 48,   /* 0x44c0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65,   /* 0x44d0 */
 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x44e0 */
 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 48,  9, 48, 48, 48,   /* 0x44f0 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48, 10, 48,   /* 0x4500 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4510 */
 78, 50, 68, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4520 */
 48, 32, 78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x4530 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83,   /* 0x4540 */
 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4550 */
 68, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4560 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 50, 48,   /* 0x4570 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83,   /* 0x4580 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4590 */
 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48,  9, 48, 48, 48,   /* 0x45a0 */
 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 51, 48, 10, 48,   /* 0x45b0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x45c0 */
 78, 50, 68, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x45d0 */
 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48,   /* 0x45e0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83,   /* 0x45f0 */
 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4600 */
 68, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4610 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 52, 48,   /* 0x4620 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83,   /* 0x4630 */
 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4640 */
 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48,  9, 48, 48, 48,   /* 0x4650 */
 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48,   /* 0x4660 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4670 */
 78, 50, 68, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4680 */
 48, 32, 78, 50, 68, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48,   /* 0x4690 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83,   /* 0x46a0 */
 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x46b0 */
 68, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x46c0 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48,   /* 0x46d0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83,   /* 0x46e0 */
 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x46f0 */
 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 48,  9, 48, 48, 48,   /* 0x4700 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10, 48,   /* 0x4710 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4720 */
 78, 50, 69, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4730 */
 48, 32, 78, 50, 69, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x4740 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,   /* 0x4750 */
 65, 83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4760 */
 69, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4770 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 51, 48,   /* 0x4780 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65,   /* 0x4790 */
 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x47a0 */
 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 51, 48,  9, 48, 48, 48,   /* 0x47b0 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48, 10, 48,   /* 0x47c0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x47d0 */
 78, 50, 69, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x47e0 */
 48, 32, 78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48,   /* 0x47f0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,   /* 0x4800 */
 65, 83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4810 */
 69, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4820 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 53, 48,   /* 0x4830 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65,   /* 0x4840 */
 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4850 */
 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48,  9, 48, 48, 48,   /* 0x4860 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 53, 48, 10, 48,   /* 0x4870 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4880 */
 78, 50, 69, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4890 */
 48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48,   /* 0x48a0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,   /* 0x48b0 */
 65, 83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x48c0 */
 69, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x48d0 */
108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x48e0 */
 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65,   /* 0x48f0 */
 95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4900 */
108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70,   /* 0x4910 */
 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65,   /* 0x4920 */
 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4930 */
108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x4940 */
 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65,   /* 0x4950 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4960 */
108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x4970 */
 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65,   /* 0x4980 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4990 */
108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x49a0 */
 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65,   /* 0x49b0 */
 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x49c0 */
108, 32, 32, 32, 32,100, 32, 32, 87, 67, 76, 69, 77, 65, 73, 50,   /* 0x49d0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 87, 67, 76, 69, 77, 65,   /* 0x49e0 */
 73, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x49f0 */
 32,100, 32, 32, 87, 67, 67, 84, 84, 80, 79, 83,  9, 48, 48, 48,   /* 0x4a00 */
 48, 48, 48, 48, 48, 32, 87, 67, 67, 84, 84, 80, 79, 83, 10, 48,   /* 0x4a10 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4a20 */
 87, 67, 67, 84, 84, 78, 85, 76,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4a30 */
 48, 32, 87, 67, 67, 84, 84, 78, 85, 76, 10, 48, 48, 48, 48, 48,   /* 0x4a40 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76,   /* 0x4a50 */
 69, 86, 69, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84,   /* 0x4a60 */
 67, 76, 69, 86, 69, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4a70 */
108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 49,   /* 0x4a80 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82,   /* 0x4a90 */
 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4aa0 */
 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 48, 49,  9, 48, 48, 48,   /* 0x4ab0 */
 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48,   /* 0x4ac0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4ad0 */
 67, 84, 66, 82, 79, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4ae0 */
 48, 32, 67, 84, 66, 82, 79, 82, 48, 49, 10, 48, 48, 48, 48, 48,   /* 0x4af0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83,   /* 0x4b00 */
 87, 65, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84,   /* 0x4b10 */
 66, 83, 87, 65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4b20 */
108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 50,   /* 0x4b30 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82,   /* 0x4b40 */
 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4b50 */
 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69, 56,  9, 48, 48, 48,   /* 0x4b60 */
 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 69, 56, 10, 48,   /* 0x4b70 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4b80 */
 67, 65, 76, 76, 84, 82, 69, 57,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4b90 */
 48, 32, 67, 65, 76, 76, 84, 82, 69, 57, 10, 48, 48, 48, 48, 48,   /* 0x4ba0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76,   /* 0x4bb0 */
 69, 86, 69, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84,   /* 0x4bc0 */
 67, 76, 69, 86, 69, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4bd0 */
108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 50,   /* 0x4be0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82,   /* 0x4bf0 */
 49, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4c00 */
 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 49, 49,  9, 48, 48, 48,   /* 0x4c10 */
 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 10, 48,   /* 0x4c20 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4c30 */
 67, 84, 66, 82, 79, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4c40 */
 48, 32, 67, 84, 66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48, 48,   /* 0x4c50 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83,   /* 0x4c60 */
 87, 65, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84,   /* 0x4c70 */
 66, 83, 87, 65, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4c80 */
108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 51,   /* 0x4c90 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51,   /* 0x4ca0 */
 50, 46, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4cb0 */
 32, 32, 32,100, 32, 32, 87, 67, 82, 69, 76, 79, 67, 49,  9, 48,   /* 0x4cc0 */
 48, 48, 48, 48, 48, 48, 48, 32, 87, 67, 82, 69, 76, 79, 67, 49,   /* 0x4cd0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4ce0 */
 32, 32, 82, 69, 76, 51, 50, 66, 73, 71,  9, 48, 48, 48, 48, 48,   /* 0x4cf0 */
 48, 48, 48, 32, 82, 69, 76, 51, 50, 66, 73, 71, 10, 48, 48, 48,   /* 0x4d00 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69,   /* 0x4d10 */
 76, 51, 50, 69, 78, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4d20 */
 82, 69, 76, 51, 50, 69, 78, 68, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4d30 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 87, 67, 82, 69, 76, 83,   /* 0x4d40 */
 69, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 87, 67, 82, 69,   /* 0x4d50 */
 76, 83, 69, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4d60 */
 32, 32, 32,100, 32, 32, 87, 67, 76, 69, 77, 65, 73, 52,  9, 48,   /* 0x4d70 */
 48, 48, 48, 48, 48, 48, 48, 32, 87, 67, 76, 69, 77, 65, 73, 52,   /* 0x4d80 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x4d90 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4da0 */
 32, 99,111,112,121, 95,115,111,117,114, 99,101, 10, 48, 48, 48,   /* 0x4db0 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x4dc0 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,112,   /* 0x4dd0 */
121, 95,100,101,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4de0 */
 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,   /* 0x4df0 */
 48, 48, 48, 48, 48, 48, 32,119,111,114,100,115, 95,116,111, 95,   /* 0x4e00 */
 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,   /* 0x4e10 */
 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,   /* 0x4e20 */
 48, 48, 48, 48, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95,   /* 0x4e30 */
 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4e40 */
 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,   /* 0x4e50 */
 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,117, 95,108,101,   /* 0x4e60 */
110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,   /* 0x4e70 */
 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4e80 */
 48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48,   /* 0x4e90 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x4ea0 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109,   /* 0x4eb0 */
 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 48, 48, 48,   /* 0x4ec0 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x4ed0 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,   /* 0x4ee0 */
114,116, 95,111,102, 95,114,101,108,111, 99,115, 10, 48, 48, 48,   /* 0x4ef0 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x4f00 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,   /* 0x4f10 */
116,101,114, 95, 98,117,102,102,101,114, 95,115,116, 97,114,116,   /* 0x4f20 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x4f30 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4f40 */
 32,102,105,108,116,101,114, 95,108,101,110,103,116,104, 10, 48,   /* 0x4f50 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4f60 */
 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,   /* 0x4f70 */
105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48,   /* 0x4f80 */
 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,   /* 0x4f90 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,103,105,110,   /* 0x4fa0 */
 97,108, 95,115,116, 97, 99,107, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4fb0 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x4fc0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,103,105,110, 97,   /* 0x4fd0 */
108, 95,101,110,116,114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x4fe0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x4ff0 */
 91, 87, 67, 76, 69, 77, 65, 73, 78, 93, 58, 10, 79, 70, 70, 83,   /* 0x5000 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x5010 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x5020 */
 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,   /* 0x5030 */
 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,121, 95,115,111,117,   /* 0x5040 */
114, 99,101, 10, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 51,   /* 0x5050 */
 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,   /* 0x5060 */
111,112,121, 95,100,101,115,116, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x5070 */
100, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x5080 */
 32, 32, 32, 32,119,111,114,100,115, 95,116,111, 95, 99,111,112,   /* 0x5090 */
121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x50a0 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 87, 67, 76, 69, 77,   /* 0x50b0 */
 65, 73, 78, 48, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x50c0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x50d0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x50e0 */
 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,   /* 0x50f0 */
 32, 32, 32, 32, 87, 67, 76, 69, 67, 85, 84, 80, 10, 10, 82, 69,   /* 0x5100 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x5110 */
 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 49, 48, 93, 58,   /* 0x5120 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x5130 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x5140 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0x5150 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,   /* 0x5160 */
 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x5170 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x5180 */
 50, 66, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x5190 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x51a0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x51b0 */
 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x51c0 */
 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10,   /* 0x51d0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x51e0 */
 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 50, 48,   /* 0x51f0 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x5200 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x5210 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0x5220 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x5230 */
 50, 66, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x5240 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x5250 */
 91, 78, 50, 66, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x5260 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x5270 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x5280 */
 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x5290 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49,   /* 0x52a0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x52b0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65,   /* 0x52c0 */
 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x52d0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x52e0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,   /* 0x52f0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5300 */
 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x5310 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x5320 */
 82, 32, 91, 78, 50, 66, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70,   /* 0x5330 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5340 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5350 */
 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5360 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,   /* 0x5370 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56,   /* 0x5380 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5390 */
 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x53a0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x53b0 */
 78, 50, 66, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x53c0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x53d0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x53e0 */
 48, 48, 49, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x53f0 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10,   /* 0x5400 */
 48, 48, 48, 48, 48, 48, 50,102, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5410 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,   /* 0x5420 */
 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x5430 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,   /* 0x5440 */
 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x5450 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5460 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5470 */
 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5480 */
 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69,   /* 0x5490 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x54a0 */
 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 52, 48, 93, 58,   /* 0x54b0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x54c0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x54d0 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54,   /* 0x54e0 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,   /* 0x54f0 */
 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82,   /* 0x5500 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5510 */
 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x5520 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x5530 */
 82, 32, 91, 78, 50, 66, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70,   /* 0x5540 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5550 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5560 */
 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5570 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,   /* 0x5580 */
 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x5590 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70,   /* 0x55a0 */
 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x55b0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x55c0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97,   /* 0x55d0 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x55e0 */
 32, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48,   /* 0x55f0 */
 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,   /* 0x5600 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10,   /* 0x5610 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x5620 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54,   /* 0x5630 */
 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x5640 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x5650 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95,   /* 0x5660 */
 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5670 */
 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x5680 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x5690 */
 32, 91, 78, 50, 68, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70,   /* 0x56a0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x56b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x56c0 */
 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x56d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49,   /* 0x56e0 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x56f0 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65,   /* 0x5700 */
 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x5710 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5720 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x5730 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x5740 */
 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,   /* 0x5750 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5760 */
 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 50, 48, 93, 58, 10, 79,   /* 0x5770 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5780 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5790 */
 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x57a0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 83, 77,   /* 0x57b0 */
 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x57c0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,   /* 0x57d0 */
 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x57e0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x57f0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5800 */
 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5810 */
 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 10, 82, 69,   /* 0x5820 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x5830 */
 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 51, 48, 93, 58,   /* 0x5840 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x5850 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x5860 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54,   /* 0x5870 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,   /* 0x5880 */
 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x5890 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x58a0 */
 50, 68, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x58b0 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x58c0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x58d0 */
 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x58e0 */
 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48,   /* 0x58f0 */
 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5900 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,   /* 0x5910 */
 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x5920 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 68,   /* 0x5930 */
 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x5940 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5950 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102,   /* 0x5960 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x5970 */
 32, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x5980 */
 48, 48, 50, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x5990 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10,   /* 0x59a0 */
 48, 48, 48, 48, 48, 48, 52, 51, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x59b0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,   /* 0x59c0 */
 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x59d0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,   /* 0x59e0 */
 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x59f0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5a00 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5a10 */
 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5a20 */
 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69,   /* 0x5a30 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x5a40 */
 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 52, 48, 93, 58,   /* 0x5a50 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x5a60 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x5a70 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54,   /* 0x5a80 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,   /* 0x5a90 */
 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82,   /* 0x5aa0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5ab0 */
 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x5ac0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x5ad0 */
 82, 32, 91, 78, 50, 68, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70,   /* 0x5ae0 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5af0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5b00 */
 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5b10 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,   /* 0x5b20 */
 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x5b30 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70,   /* 0x5b40 */
 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x5b50 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5b60 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97,   /* 0x5b70 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x5b80 */
 32, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48,   /* 0x5b90 */
 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,   /* 0x5ba0 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10,   /* 0x5bb0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x5bc0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54,   /* 0x5bd0 */
 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x5be0 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x5bf0 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95,   /* 0x5c00 */
 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5c10 */
 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x5c20 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x5c30 */
 32, 91, 78, 50, 69, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70,   /* 0x5c40 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x5c50 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x5c60 */
 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x5c70 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49,   /* 0x5c80 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x5c90 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65,   /* 0x5ca0 */
 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x5cb0 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5cc0 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x5cd0 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x5ce0 */
 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,   /* 0x5cf0 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5d00 */
 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 50, 48, 93, 58, 10, 79,   /* 0x5d10 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5d20 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5d30 */
 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5d40 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 83, 77,   /* 0x5d50 */
 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x5d60 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,   /* 0x5d70 */
 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x5d80 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5d90 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5da0 */
 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5db0 */
 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 10, 82, 69,   /* 0x5dc0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x5dd0 */
 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 51, 48, 93, 58,   /* 0x5de0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x5df0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x5e00 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54,   /* 0x5e10 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,   /* 0x5e20 */
 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x5e30 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x5e40 */
 50, 69, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x5e50 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5e60 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x5e70 */
 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x5e80 */
 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48,   /* 0x5e90 */
 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5ea0 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,   /* 0x5eb0 */
 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x5ec0 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 68,   /* 0x5ed0 */
 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x5ee0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5ef0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102,   /* 0x5f00 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x5f10 */
 32, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x5f20 */
 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x5f30 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10,   /* 0x5f40 */
 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5f50 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,   /* 0x5f60 */
 67, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x5f70 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,   /* 0x5f80 */
 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x5f90 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5fa0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5fb0 */
 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5fc0 */
 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69,   /* 0x5fd0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x5fe0 */
 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 52, 48, 93, 58,   /* 0x5ff0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x6000 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x6010 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54,   /* 0x6020 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,   /* 0x6030 */
 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82,   /* 0x6040 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6050 */
 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x6060 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x6070 */
 82, 32, 91, 78, 50, 69, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70,   /* 0x6080 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x6090 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x60a0 */
 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x60b0 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,   /* 0x60c0 */
 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x60d0 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70,   /* 0x60e0 */
 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x60f0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6100 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97,   /* 0x6110 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x6120 */
 32, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48,   /* 0x6130 */
 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,   /* 0x6140 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10,   /* 0x6150 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x6160 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54,   /* 0x6170 */
 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x6180 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x6190 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95,   /* 0x61a0 */
 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x61b0 */
 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x61c0 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x61d0 */
 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 93, 58, 10, 79,   /* 0x61e0 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x61f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x6200 */
 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 51,   /* 0x6210 */
 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,   /* 0x6220 */
115,116, 97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48,   /* 0x6230 */
 48, 48, 48, 49, 52, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,   /* 0x6240 */
 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,117, 95,108,   /* 0x6250 */
101,110, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56,   /* 0x6260 */
 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,   /* 0x6270 */
109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 50,   /* 0x6280 */
 97, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x6290 */
 32, 32, 32, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,   /* 0x62a0 */
105,101,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x62b0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 87, 67, 76,   /* 0x62c0 */
 69, 77, 65, 73, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x62d0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x62e0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x62f0 */
 52, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x6300 */
 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,114,101,108,   /* 0x6310 */
111, 99,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x6320 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 87, 67, 67,   /* 0x6330 */
 84, 84, 80, 79, 83, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x6340 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6350 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x6360 */
 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x6370 */
 32, 32, 32, 32,102,105,108,116,101,114, 95, 98,117,102,102,101,   /* 0x6380 */
114, 95,115,116, 97,114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x6390 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x63a0 */
 91, 67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x63b0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x63c0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x63d0 */
 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,   /* 0x63e0 */
 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,   /* 0x63f0 */
101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x6400 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,   /* 0x6410 */
 84, 67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x6420 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6430 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x6440 */
 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32,   /* 0x6450 */
 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111,   /* 0x6460 */
 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95,   /* 0x6470 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76,   /* 0x6480 */
 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x6490 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,   /* 0x64a0 */
 76, 76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x64b0 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x64c0 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x64d0 */
 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x64e0 */
 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82,   /* 0x64f0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x6500 */
 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93,   /* 0x6510 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x6520 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x6530 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,   /* 0x6540 */
 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,   /* 0x6550 */
108,116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76,   /* 0x6560 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x6570 */
 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10,   /* 0x6580 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x6590 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x65a0 */
 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,   /* 0x65b0 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76,   /* 0x65c0 */
 84, 82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x65d0 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84,   /* 0x65e0 */
 67, 76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x65f0 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6600 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x6610 */
 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32,   /* 0x6620 */
 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10,   /* 0x6630 */
 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x6640 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,   /* 0x6650 */
 82, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x6660 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76,   /* 0x6670 */
 76, 84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x6680 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6690 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x66a0 */
 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x66b0 */
 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 10, 82, 69,   /* 0x66c0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x66d0 */
 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 48, 48, 93,   /* 0x66e0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x66f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x6700 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,   /* 0x6710 */
 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,   /* 0x6720 */
108,116,101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48,   /* 0x6730 */
 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x6740 */
 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48,   /* 0x6750 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x6760 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,   /* 0x6770 */
 46, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x6780 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6790 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32,   /* 0x67a0 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x67b0 */
 32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76,   /* 0x67c0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x67d0 */
 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 50, 48, 93, 58,   /* 0x67e0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x67f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x6800 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54,   /* 0x6810 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,   /* 0x6820 */
107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,   /* 0x6830 */
 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6840 */
 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48,   /* 0x6850 */
 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x6860 */
 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,   /* 0x6870 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x6880 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,   /* 0x6890 */
 50, 46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x68a0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x68b0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54,   /* 0x68c0 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x68d0 */
 32, 32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 10, 82, 69,   /* 0x68e0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x68f0 */
 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 52, 48, 93,   /* 0x6900 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x6910 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x6920 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56,   /* 0x6930 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,   /* 0x6940 */
111,107, 51, 50, 46, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x6950 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x6960 */
 91, 82, 69, 76, 79, 67, 51, 50, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x6970 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x6980 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x6990 */
 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x69a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51, 50, 74,   /* 0x69b0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x69c0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 51, 50, 66,   /* 0x69d0 */
 73, 71, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x69e0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x69f0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,   /* 0x6a00 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6a10 */
 32, 82, 69, 76, 79, 67, 51, 50, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x6a20 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x6a30 */
 82, 32, 91, 82, 69, 76, 79, 67, 51, 50, 74, 93, 58, 10, 79, 70,   /* 0x6a40 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x6a50 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x6a60 */
 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x6a70 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51,   /* 0x6a80 */
 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x6a90 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 87, 67, 76, 69,   /* 0x6aa0 */
 77, 65, 73, 52, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x6ab0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6ac0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99,   /* 0x6ad0 */
 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0x6ae0 */
 32, 32, 32,111,114,105,103,105,110, 97,108, 95,115,116, 97, 99,   /* 0x6af0 */
107, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56, 54,   /* 0x6b00 */
 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,111,114,105,   /* 0x6b10 */
103,105,110, 97,108, 95,101,110,116,114,121, 10                    /* 0x6b20 */
};
