/*
	file automatically generated by make_test_files.pl
	Wed Mar 16 14:50:45 2022
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for HITRO
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_hitro_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

int unur_hitro_set_pedantic( UNUR_PAR *par, int pedantic );

#define COMPARE_SAMPLE_SIZE   (9999)
#define VIOLATE_SAMPLE_SIZE   (20)

/* For running chi2 tests we use a thinning of dimension * THINNING */
#define THINNING (2)

/* HITRO is a Markov Chain Monte Carlo method and thus it is likely to   */
/* fail the chi-square goodness-of-fit test with the used sample size.   */
/* Thus we accept one "hard" failer and more "soft" failures then usual. */
#define CHI2_FAILURES_TOLERATED (1010)


/* we need marginal distributions for the chi2 tests */
#define unur_distr_multicauchy   unur_distr_multicauchy_w_marginals
#define unur_distr_multinormal   unur_distr_multinormal_w_marginals
#define unur_distr_multistudent  unur_distr_multistudent_w_marginals

/* HITRO tests are sensitive against SEED.                 */
/* So we at least ignore the random seed from the script   */
/* the transforms t_hitro.conf to t_hitro.c.               */
#ifndef SEED
#define SEED (123456)
#endif




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/* dummy function */
int unur_hitro_set_pedantic( UNUR_PAR *par ATTRIBUTE__UNUSED, int pedantic ATTRIBUTE__UNUSED)
{ return 1; }

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,49,(unur_hitro_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,49,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,56,(unur_hitro_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,56,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* missing data */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cvec_new(3); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,63,(unur_hitro_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,63,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   double x0[] = {1., 2., 3.};
   double umin[] = {0.,0.,0.};
   double umax[] = {1.,1.,1.};
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,77,(unur_hitro_set_variant_coordinate( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,77,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,80,(unur_hitro_set_variant_random_direction( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,80,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,83,(unur_hitro_set_startingpoint( par, x0)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,83,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,86,(unur_hitro_set_thinning( par, 3 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,86,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,89,(unur_hitro_set_burnin( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,89,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,92,(unur_hitro_set_use_adaptiveline( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,92,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,95,(unur_hitro_set_use_boundingrectangle( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,95,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,98,(unur_hitro_set_use_adaptiverectangle( par, TRUE ) ))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,98,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,101,(unur_hitro_set_r( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,101,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,104,(unur_hitro_set_v( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,104,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,107,(unur_hitro_set_u( par, umin, umax )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,107,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,110,(unur_hitro_set_adaptive_multiplier( par, 1.1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,110,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double x0[] = {1., 2., 3.};
   double umin[] = {0.,0.,0.};
   double umax[] = {1.,1.,1.};
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,122,(unur_hitro_set_variant_coordinate( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,122,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,125,(unur_hitro_set_variant_random_direction( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,125,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,128,(unur_hitro_set_startingpoint( par, x0)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,128,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,131,(unur_hitro_set_thinning( par, 3 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,131,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,134,(unur_hitro_set_burnin( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,134,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,137,(unur_hitro_set_use_adaptiveline( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,137,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,140,(unur_hitro_set_use_boundingrectangle( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,140,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,143,(unur_hitro_set_use_adaptiverectangle( par, TRUE ) ))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,143,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,146,(unur_hitro_set_r( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,146,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,149,(unur_hitro_set_v( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,149,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,152,(unur_hitro_set_u( par, umin, umax )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,152,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,155,(unur_hitro_set_adaptive_multiplier( par, 1.1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,155,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double umin[] = {0.,0.,0.};
   double umax[] = {1.,-1.,1.};
   double umaxinf[] = {1.,UNUR_INFINITY,1.};
   distr = unur_distr_multinormal( 3, NULL, NULL );
   par = unur_hitro_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,168,(unur_hitro_set_thinning( par, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,168,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,171,(unur_hitro_set_burnin( par, -1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,171,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,174,(unur_hitro_set_r( par, 0. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,174,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,177,(unur_hitro_set_v( par, 0. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,177,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,180,(unur_hitro_set_v( par, UNUR_INFINITY )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,180,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,183,(unur_hitro_set_u( par, umin, umax )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,183,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,186,(unur_hitro_set_u( par, umin, umaxinf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,186,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,189,(unur_hitro_set_adaptive_multiplier( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,189,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [get] */

void test_get (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[get "); fflush(stdout);
	fprintf(TESTLOG,"\n[get]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 201,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,205,(unur_hitro_get_state(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,205,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_get() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double x[] = {0.,0.};
   distr = unur_distr_normal(NULL,0);
   par = unur_ssr_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 215,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,219,(unur_hitro_chg_state(gen,x)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,219,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid NULL */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_multinormal(2,NULL,NULL);
   par = unur_hitro_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 223,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,227,(unur_hitro_chg_state(gen,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,227,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid state */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double state[] = {1000.,1000.,1000.};
   distr = unur_distr_multinormal(2,NULL,NULL);
   par = unur_hitro_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 232,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,236,(unur_hitro_chg_state(gen,state)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,236,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* does not exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double x[3];
   distr = unur_distr_multinormal(3,NULL,NULL);
   par = unur_hitro_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 250,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,254,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,254,UNUR_ERR_NO_REINIT)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_sample_vec( gen, x );
n_tests_failed += (check_expected_INFINITY(TESTLOG,258,(x[0]))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,258,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* test clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   UNUR_GEN *clone;
   distr = unur_distr_multinormal( dim, mean, covar );
   par = unur_hitro_new(distr);
   unur_hitro_set_variant_coordinate(par);
   unur_hitro_set_use_adaptiveline(par,TRUE);
   unur_hitro_set_use_adaptiverectangle(par,FALSE);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 274,    gen );


unur_reset_errno();
;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,278,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
unur_hitro_reset_state(gen);
n_tests_failed += (compare_sequence_gen(TESTLOG,285,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* test clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   UNUR_GEN *clone;
   distr = unur_distr_multinormal( dim, mean, covar );
   par = unur_hitro_new(distr);
   unur_hitro_set_variant_random_direction(par);
   unur_hitro_set_use_adaptiveline(par,TRUE);
   unur_hitro_set_use_adaptiverectangle(par,FALSE);
   unur_hitro_set_use_boundingrectangle(par,TRUE);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 299,    gen );


unur_reset_errno();
;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,303,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
unur_hitro_reset_state(gen);
n_tests_failed += (compare_sequence_gen(TESTLOG,310,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	/* suppress GCC compiler warning */
GCC_DIAG_OFF(unused-variable)

	UNUR_DISTR *distr[37];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	double *darray;
	double fpm[10];
	int n_tests_failed;
	int rcode;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 37 */
{
distr[0] = unur_distr_multinormal(1,NULL,NULL);
}

{
distr[1] = unur_distr_multinormal(2,NULL,NULL);
}

{
distr[2] = unur_distr_multinormal(3,NULL,NULL);
}

{
double mean[]  = { -1. };
double covar[] = { 2. };
distr[3] = unur_distr_multinormal(1,mean,covar);
unur_distr_cvec_set_center(distr[3],NULL);
}

{
double mean[]  = { 1., 2., 3. };
double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
distr[4] = unur_distr_multinormal(3,mean,covar);
}

{
distr[5] = unur_distr_multinormal_ar1(3,NULL,0.9);
}

{
distr[6] = unur_distr_multinormal_ar1(4,NULL,0.9);
}

{
distr[7] = unur_distr_multinormal_ar1(5,NULL,0.9);
}

{
distr[8] = unur_distr_multinormal_ar1(10,NULL,0.7);
}

{
double mean[]  = { -1., -2., -3., 4., 5., 6., 7., 8., 9., 10. };
distr[9] = unur_distr_multinormal_ar1(3,mean,0.9);
}

{
double mean[]  = { -1., -2., -3., 4., 5., 6., 7., 8., 9., 10. };
distr[10] = unur_distr_multinormal_ar1(4,mean,0.9);
}

{
double mean[]  = { -1., -2., -3., 4., 5., 6., 7., 8., 9., 10. };
distr[11] = unur_distr_multinormal_ar1(5,mean,0.9);
}

{
double mean[]  = { -1., -2., -3., 4., 5., 6., 7., 8., 9., 10. };
distr[12] = unur_distr_multinormal_ar1(10,mean,0.7);
}

{
distr[13] = unur_distr_multinormal_constantrho(3,NULL,0.9);
}

{
distr[14] = unur_distr_multinormal_constantrho(4,NULL,0.9);
}

{
distr[15] = unur_distr_multinormal_constantrho(5,NULL,0.9);
}

{
distr[16] = unur_distr_multinormal_constantrho(10,NULL,0.7);
}

{
distr[17] = unur_distr_multicauchy(2,NULL,NULL);
}

{
distr[18] = unur_distr_multicauchy(3,NULL,NULL);
}

{
double mean[]  = { 1., 2., 3. };
double covar[] = { 1., 0.5, 0.25,  0.5, 1., 0.5,   0.25, 0.5, 1. };
distr[19] = unur_distr_multicauchy(3,mean,covar);
}

{
distr[20] = unur_distr_multicauchy_ar1(3,NULL,0.9);
}

{
distr[21] = unur_distr_multicauchy_ar1(4,NULL,0.9);
}

{
distr[22] = unur_distr_multicauchy_ar1(5,NULL,0.9);
}

{
distr[23] = unur_distr_multicauchy_ar1(10,NULL,0.7);
}

{
distr[24] = unur_distr_multistudent_ar1(2,3.,NULL,0.9);
}

{
distr[25] = unur_distr_multistudent_ar1(2,5.,NULL,0.9);
}

{
distr[26] = unur_distr_multistudent_ar1(2,15.,NULL,0.9);
}

{
distr[27] = unur_distr_multistudent_ar1(2,0.5,NULL,0.9);
}

{
distr[28] = unur_distr_multistudent_ar1(2,1.5,NULL,0.9);
}

{
distr[29] = unur_distr_multistudent_ar1(2,2.5,NULL,0.9);
}

{
double ll[3] = {0.,0.,0.};
double ru[3] = {UNUR_INFINITY,UNUR_INFINITY,UNUR_INFINITY};
distr[30] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[30],ll,ru);
}

{
double ll[3] = {-0.5,-0.5,-0.5};
double ru[3] = {UNUR_INFINITY,UNUR_INFINITY,UNUR_INFINITY};
distr[34] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[34],ll,ru);
}

{
double ll[3] = {0.,0.,0.};
double ru[3] = {1.,UNUR_INFINITY,UNUR_INFINITY};
distr[31] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[31],ll,ru);
}

{
double ll[3] = {-0.5,-0.5,-0.5};
double ru[3] = {1.,UNUR_INFINITY,UNUR_INFINITY};
distr[35] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[35],ll,ru);
}

{
double ll[3] = {-1.,-1.,1.};
double ru[3] = {1.,0.,2.};
double center[3] = {0.,0.,1.};
distr[32] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[32],ll,ru);
unur_distr_cvec_set_center(distr[32],center);
}

{
double ll[3] = {-1.,-1.,1.};
double ru[3] = {1.,0.,2.};
double center[3] = {0.,-0.5,1.5};
distr[36] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[36],ll,ru);
unur_distr_cvec_set_center(distr[36],center);
}

{
double ll[3] = {-1.,-1.,1.};
double ru[3] = {1.,0.,2.};
distr[33] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[33],ll,ru);
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 333 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [9] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [11] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [12] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [13] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [14] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [15] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [16] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [17] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [18] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [19] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [20] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [21] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [22] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [23] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [24] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [25] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [26] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [28] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [29] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [30] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [34] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [31] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [35] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [32] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [36] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [33] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,FALSE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,FALSE);
unur_hitro_set_use_boundingrectangle(par,FALSE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_coordinate(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hitro_new(distr_localcopy);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,3.);
unur_hitro_set_use_adaptiveline(par,TRUE);
unur_hitro_set_use_adaptiverectangle(par,TRUE);
unur_hitro_set_use_boundingrectangle(par,TRUE);
unur_hitro_set_thinning(par,THINNING*(1+unur_distr_get_dim(distr_localcopy)));
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);
	unur_distr_free(distr[23]);
	unur_distr_free(distr[24]);
	unur_distr_free(distr[25]);
	unur_distr_free(distr[26]);
	unur_distr_free(distr[27]);
	unur_distr_free(distr[28]);
	unur_distr_free(distr[29]);
	unur_distr_free(distr[30]);
	unur_distr_free(distr[31]);
	unur_distr_free(distr[32]);
	unur_distr_free(distr[33]);
	unur_distr_free(distr[34]);
	unur_distr_free(distr[35]);
	unur_distr_free(distr[36]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_validate */

/* enable GCC compiler warning */
GCC_DIAG_ON(unused-variable)


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_hitro_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_hitro_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_hitro_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_hitro_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 200868;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 200868;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("hitro: ");

	/* run tests */
test_new();
test_set();
test_get();
test_chg();
test_reinit();
test_sample();
test_validate();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

