function UnityViewManager (contextManager, plugin) {
    this.activeViewWindow = null;
    this.contextManager = contextManager;
    this.plugin = plugin;

    this.currentTabId = null;
    chrome.runtime.sendRequest ("get_this_tab", function (response) {
        this.currentTabId = response.tabId;
    });

    this.isWindowCurrentlySelected = true;
    chrome.runtime.onRequest.addListener (function (request, sender, response) {
        if (request.method && request.method === "on_tab_active_changed") {
            console.log ("From content script: tab id changed " + request.tabId);
            this.isWindowCurrentlySelected = (this.currentTabId === request.tabId);
            console.log ("From content script: isWindowCurrentlySelected " + this.isWindowCurrentlySelected);
        }
    });
}

UnityViewManager.prototype.windowIsSelected = function () {
    return this.isWindowCurrentlySelected;
}

UnityViewManager.prototype.setActiveView = function (context, window) {
    if (this.activeViewWindow != null) {
    	if (this.activeViewWindow == window) {
    	    return;
    	}

    	var activeContext = this.contextManager.findContextByWindow (this.activeViewWindow);
    	
    	if (activeContext != null) {
    	    this.plugin.context_set_view_is_active (activeContext, 0);
    	}

    	this.activeViewWindow = null;
    }

    if (context == null) {
    	return;
    }

    this.plugin.context_set_view_is_active (context.context, 1);

    this.activeViewWindow = window;
}
