/* umockdev-run.c generated by valac 0.38.2, the Vala compiler
 * generated from umockdev-run.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <stdio.h>
#include <errno.h>
#include "config.h"
#include <umockdev.h>
#include <glib/gstdio.h>
#include <sys/socket.h>
#include <sys/wait.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);


extern gchar** opt_device;
gchar** opt_device = NULL;
extern gchar** opt_ioctl;
gchar** opt_ioctl = NULL;
extern gchar** opt_script;
gchar** opt_script = NULL;
extern gchar** opt_unix_stream;
gchar** opt_unix_stream = NULL;
extern gchar** opt_evemu_events;
gchar** opt_evemu_events = NULL;
extern gchar** opt_program;
gchar** opt_program = NULL;
extern gboolean opt_version;
gboolean opt_version = FALSE;
extern GPid child_pid;
GPid child_pid = 0;

void child_sig_handler (gint sig);
gint _vala_main (gchar** args, int args_length1);
static void _child_sig_handler_sighandler_t (gint signal);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[8] = {{"device", 'd', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_device, "Load an umockdev-record device description into the testbed. Can be sp" \
"ecified multiple times.", "filename"}, {"ioctl", 'i', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_ioctl, "Load an umockdev-record ioctl dump into the testbed. Can be specified " \
"multiple times.", "devname=ioctlfilename"}, {"script", 's', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_script, "Load an umockdev-record script into the testbed. Can be specified mult" \
"iple times.", "devname=scriptfilename"}, {"unix-stream", 'u', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_unix_stream, "Load an umockdev-record script for a mocked Unix stream socket. Can be" \
" specified multiple times.", "socket_path=scriptfilename"}, {"evemu-events", 'e', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_evemu_events, "Load an evemu .events file into the testbed. Can be specified multiple" \
" times.", "devname=eventsfilename"}, {"", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &opt_program, "", ""}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &opt_version, "Output version information and exit"}, {NULL}};

void child_sig_handler (gint sig) {
	gint _tmp0_;
	GPid _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = sig;
	g_debug ("umockdev-run.vala:61: umockdev-run: caught signal %i, propagating to c" \
"hild\n", _tmp0_);
	_tmp1_ = child_pid;
	_tmp2_ = sig;
	_tmp3_ = kill ((pid_t) _tmp1_, _tmp2_);
	if (_tmp3_ != 0) {
		FILE* _tmp4_;
		gint _tmp5_;
		GPid _tmp6_;
		gint _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = stderr;
		_tmp5_ = sig;
		_tmp6_ = child_pid;
		_tmp7_ = errno;
		_tmp8_ = g_strerror (_tmp7_);
		fprintf (_tmp4_, "umockdev-run: unable to propagate signal %i to child %i: %s\n", _tmp5_, (gint) _tmp6_, _tmp8_);
	}
}


static void _child_sig_handler_sighandler_t (gint signal) {
	child_sig_handler (signal);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* oc = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	gboolean _tmp10_;
	gchar* preload = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	UMockdevTestbed* testbed = NULL;
	UMockdevTestbed* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** _tmp38_;
	gint _tmp38__length1;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gchar** _tmp78_;
	gint _tmp78__length1;
	gchar** _tmp98_;
	gint _tmp98__length1;
	gchar** _tmp118_;
	gint _tmp118__length1;
	gint status = 0;
	struct sigaction act = {0};
	struct sigaction _tmp127_ = {0};
	struct sigaction _tmp128_;
	sigset_t _tmp129_;
	struct sigaction _tmp130_;
	gint _tmp131_;
	struct sigaction _tmp132_;
	gint _tmp133_;
	struct sigaction _tmp134_;
	gint _tmp135_;
	struct sigaction _tmp136_;
	gint _tmp137_;
	struct sigaction _tmp138_;
	gint _tmp139_;
	GPid _tmp140_;
	gint _tmp141_ = 0;
	GPid _tmp142_;
	gint _tmp143_;
	gboolean _tmp144_;
	gint _tmp147_;
	gboolean _tmp148_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("-- program [args..]");
	oc = _tmp0_;
	_tmp1_ = oc;
	g_option_context_set_summary (_tmp1_, "Run a program under an umockdev testbed.");
	_tmp2_ = oc;
	g_option_context_add_main_entries (_tmp2_, options, NULL);
	{
		GOptionContext* _tmp3_;
		_tmp3_ = oc;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = args;
		_tmp7__length1 = args_length1;
		_tmp8_ = _tmp7_[0];
		fprintf (_tmp4_, "Error: %s\nRun %s --help for how to use this program\n", _tmp6_, _tmp8_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp9_ = 0;
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp9_;
	}
	_tmp10_ = opt_version;
	if (_tmp10_) {
		FILE* _tmp11_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "%s\n", VERSION);
		result = 0;
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp12_ = g_getenv ("LD_PRELOAD");
	_tmp13_ = g_strdup (_tmp12_);
	preload = _tmp13_;
	_tmp14_ = preload;
	if (_tmp14_ == NULL) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("");
		_g_free0 (preload);
		preload = _tmp15_;
	} else {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = preload;
		_tmp17_ = g_strconcat (_tmp16_, ":", NULL);
		_g_free0 (preload);
		preload = _tmp17_;
	}
	_tmp18_ = preload;
	_tmp19_ = g_strconcat (_tmp18_, "libumockdev-preload.so.0", NULL);
	_tmp20_ = _tmp19_;
	g_setenv ("LD_PRELOAD", _tmp20_, TRUE);
	_g_free0 (_tmp20_);
	_tmp21_ = umockdev_testbed_new ();
	testbed = _tmp21_;
	_tmp22_ = opt_device;
	_tmp22__length1 = _vala_array_length (opt_device);
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp22_;
		path_collection_length1 = _tmp22__length1;
		for (path_it = 0; path_it < _tmp22__length1; path_it = path_it + 1) {
			gchar* _tmp23_;
			gchar* path = NULL;
			_tmp23_ = g_strdup (path_collection[path_it]);
			path = _tmp23_;
			{
				gchar* record = NULL;
				{
					const gchar* _tmp24_;
					gchar* _tmp25_ = NULL;
					_tmp24_ = path;
					g_file_get_contents (_tmp24_, &_tmp25_, NULL, &_inner_error_);
					_g_free0 (record);
					record = _tmp25_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					FILE* _tmp26_;
					const gchar* _tmp27_;
					GError* _tmp28_;
					const gchar* _tmp29_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp26_ = stderr;
					_tmp27_ = path;
					_tmp28_ = e;
					_tmp29_ = _tmp28_->message;
					fprintf (_tmp26_, "Error: Cannot open %s: %s\n", _tmp27_, _tmp29_);
					result = 1;
					_g_error_free0 (e);
					_g_free0 (record);
					_g_free0 (path);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally1:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gint _tmp30_ = 0;
					_g_free0 (record);
					_g_free0 (path);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp30_;
				}
				{
					UMockdevTestbed* _tmp31_;
					const gchar* _tmp32_;
					_tmp31_ = testbed;
					_tmp32_ = record;
					umockdev_testbed_add_from_string (_tmp31_, _tmp32_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* e = NULL;
					FILE* _tmp33_;
					const gchar* _tmp34_;
					GError* _tmp35_;
					const gchar* _tmp36_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp33_ = stderr;
					_tmp34_ = path;
					_tmp35_ = e;
					_tmp36_ = _tmp35_->message;
					fprintf (_tmp33_, "Error: Invalid record file %s: %s\n", _tmp34_, _tmp36_);
					result = 1;
					_g_error_free0 (e);
					_g_free0 (record);
					_g_free0 (path);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally2:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gint _tmp37_ = 0;
					_g_free0 (record);
					_g_free0 (path);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp37_;
				}
				_g_free0 (record);
				_g_free0 (path);
			}
		}
	}
	_tmp38_ = opt_ioctl;
	_tmp38__length1 = _vala_array_length (opt_ioctl);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp38_;
		i_collection_length1 = _tmp38__length1;
		for (i_it = 0; i_it < _tmp38__length1; i_it = i_it + 1) {
			gchar* _tmp39_;
			gchar* i = NULL;
			_tmp39_ = g_strdup (i_collection[i_it]);
			i = _tmp39_;
			{
				gchar** parts = NULL;
				const gchar* _tmp40_;
				gchar** _tmp41_;
				gchar** _tmp42_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp43_;
				gint _tmp43__length1;
				_tmp40_ = i;
				_tmp42_ = _tmp41_ = g_strsplit (_tmp40_, "=", 2);
				parts = _tmp42_;
				parts_length1 = _vala_array_length (_tmp41_);
				_parts_size_ = parts_length1;
				_tmp43_ = parts;
				_tmp43__length1 = parts_length1;
				if (_tmp43__length1 != 2) {
					FILE* _tmp44_;
					_tmp44_ = stderr;
					fprintf (_tmp44_, "Error: --ioctl argument must be devname=filename\n");
					result = 1;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				{
					UMockdevTestbed* _tmp45_;
					gchar** _tmp46_;
					gint _tmp46__length1;
					const gchar* _tmp47_;
					gchar** _tmp48_;
					gint _tmp48__length1;
					const gchar* _tmp49_;
					_tmp45_ = testbed;
					_tmp46_ = parts;
					_tmp46__length1 = parts_length1;
					_tmp47_ = _tmp46_[0];
					_tmp48_ = parts;
					_tmp48__length1 = parts_length1;
					_tmp49_ = _tmp48_[1];
					umockdev_testbed_load_ioctl (_tmp45_, _tmp47_, _tmp49_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch3_g_error;
					}
				}
				goto __finally3;
				__catch3_g_error:
				{
					GError* e = NULL;
					FILE* _tmp50_;
					gchar** _tmp51_;
					gint _tmp51__length1;
					const gchar* _tmp52_;
					gchar** _tmp53_;
					gint _tmp53__length1;
					const gchar* _tmp54_;
					GError* _tmp55_;
					const gchar* _tmp56_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp50_ = stderr;
					_tmp51_ = parts;
					_tmp51__length1 = parts_length1;
					_tmp52_ = _tmp51_[1];
					_tmp53_ = parts;
					_tmp53__length1 = parts_length1;
					_tmp54_ = _tmp53_[0];
					_tmp55_ = e;
					_tmp56_ = _tmp55_->message;
					fprintf (_tmp50_, "Error: Cannot install %s for device %s: %s\n", _tmp52_, _tmp54_, _tmp56_);
					result = 1;
					_g_error_free0 (e);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally3:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gint _tmp57_ = 0;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp57_;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (i);
			}
		}
	}
	_tmp58_ = opt_script;
	_tmp58__length1 = _vala_array_length (opt_script);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp58_;
		i_collection_length1 = _tmp58__length1;
		for (i_it = 0; i_it < _tmp58__length1; i_it = i_it + 1) {
			gchar* _tmp59_;
			gchar* i = NULL;
			_tmp59_ = g_strdup (i_collection[i_it]);
			i = _tmp59_;
			{
				gchar** parts = NULL;
				const gchar* _tmp60_;
				gchar** _tmp61_;
				gchar** _tmp62_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp63_;
				gint _tmp63__length1;
				_tmp60_ = i;
				_tmp62_ = _tmp61_ = g_strsplit (_tmp60_, "=", 2);
				parts = _tmp62_;
				parts_length1 = _vala_array_length (_tmp61_);
				_parts_size_ = parts_length1;
				_tmp63_ = parts;
				_tmp63__length1 = parts_length1;
				if (_tmp63__length1 != 2) {
					FILE* _tmp64_;
					_tmp64_ = stderr;
					fprintf (_tmp64_, "Error: --script argument must be devname=filename\n");
					result = 1;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				{
					UMockdevTestbed* _tmp65_;
					gchar** _tmp66_;
					gint _tmp66__length1;
					const gchar* _tmp67_;
					gchar** _tmp68_;
					gint _tmp68__length1;
					const gchar* _tmp69_;
					_tmp65_ = testbed;
					_tmp66_ = parts;
					_tmp66__length1 = parts_length1;
					_tmp67_ = _tmp66_[0];
					_tmp68_ = parts;
					_tmp68__length1 = parts_length1;
					_tmp69_ = _tmp68_[1];
					umockdev_testbed_load_script (_tmp65_, _tmp67_, _tmp69_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* e = NULL;
					FILE* _tmp70_;
					gchar** _tmp71_;
					gint _tmp71__length1;
					const gchar* _tmp72_;
					gchar** _tmp73_;
					gint _tmp73__length1;
					const gchar* _tmp74_;
					GError* _tmp75_;
					const gchar* _tmp76_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp70_ = stderr;
					_tmp71_ = parts;
					_tmp71__length1 = parts_length1;
					_tmp72_ = _tmp71_[1];
					_tmp73_ = parts;
					_tmp73__length1 = parts_length1;
					_tmp74_ = _tmp73_[0];
					_tmp75_ = e;
					_tmp76_ = _tmp75_->message;
					fprintf (_tmp70_, "Error: Cannot install %s for device %s: %s\n", _tmp72_, _tmp74_, _tmp76_);
					result = 1;
					_g_error_free0 (e);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally4:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gint _tmp77_ = 0;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp77_;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (i);
			}
		}
	}
	_tmp78_ = opt_unix_stream;
	_tmp78__length1 = _vala_array_length (opt_unix_stream);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp78_;
		i_collection_length1 = _tmp78__length1;
		for (i_it = 0; i_it < _tmp78__length1; i_it = i_it + 1) {
			gchar* _tmp79_;
			gchar* i = NULL;
			_tmp79_ = g_strdup (i_collection[i_it]);
			i = _tmp79_;
			{
				gchar** parts = NULL;
				const gchar* _tmp80_;
				gchar** _tmp81_;
				gchar** _tmp82_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp83_;
				gint _tmp83__length1;
				_tmp80_ = i;
				_tmp82_ = _tmp81_ = g_strsplit (_tmp80_, "=", 2);
				parts = _tmp82_;
				parts_length1 = _vala_array_length (_tmp81_);
				_parts_size_ = parts_length1;
				_tmp83_ = parts;
				_tmp83__length1 = parts_length1;
				if (_tmp83__length1 != 2) {
					FILE* _tmp84_;
					_tmp84_ = stderr;
					fprintf (_tmp84_, "Error: --unix-stream argument must be socket_path=filename\n");
					result = 1;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				{
					UMockdevTestbed* _tmp85_;
					gchar** _tmp86_;
					gint _tmp86__length1;
					const gchar* _tmp87_;
					gchar** _tmp88_;
					gint _tmp88__length1;
					const gchar* _tmp89_;
					_tmp85_ = testbed;
					_tmp86_ = parts;
					_tmp86__length1 = parts_length1;
					_tmp87_ = _tmp86_[0];
					_tmp88_ = parts;
					_tmp88__length1 = parts_length1;
					_tmp89_ = _tmp88_[1];
					umockdev_testbed_load_socket_script (_tmp85_, _tmp87_, SOCK_STREAM, _tmp89_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch5_g_error;
					}
				}
				goto __finally5;
				__catch5_g_error:
				{
					GError* e = NULL;
					FILE* _tmp90_;
					gchar** _tmp91_;
					gint _tmp91__length1;
					const gchar* _tmp92_;
					gchar** _tmp93_;
					gint _tmp93__length1;
					const gchar* _tmp94_;
					GError* _tmp95_;
					const gchar* _tmp96_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp90_ = stderr;
					_tmp91_ = parts;
					_tmp91__length1 = parts_length1;
					_tmp92_ = _tmp91_[1];
					_tmp93_ = parts;
					_tmp93__length1 = parts_length1;
					_tmp94_ = _tmp93_[0];
					_tmp95_ = e;
					_tmp96_ = _tmp95_->message;
					fprintf (_tmp90_, "Error: Cannot install %s for stream socket %s: %s\n", _tmp92_, _tmp94_, _tmp96_);
					result = 1;
					_g_error_free0 (e);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally5:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gint _tmp97_ = 0;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp97_;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (i);
			}
		}
	}
	_tmp98_ = opt_evemu_events;
	_tmp98__length1 = _vala_array_length (opt_evemu_events);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp98_;
		i_collection_length1 = _tmp98__length1;
		for (i_it = 0; i_it < _tmp98__length1; i_it = i_it + 1) {
			gchar* _tmp99_;
			gchar* i = NULL;
			_tmp99_ = g_strdup (i_collection[i_it]);
			i = _tmp99_;
			{
				gchar** parts = NULL;
				const gchar* _tmp100_;
				gchar** _tmp101_;
				gchar** _tmp102_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp103_;
				gint _tmp103__length1;
				_tmp100_ = i;
				_tmp102_ = _tmp101_ = g_strsplit (_tmp100_, "=", 2);
				parts = _tmp102_;
				parts_length1 = _vala_array_length (_tmp101_);
				_parts_size_ = parts_length1;
				_tmp103_ = parts;
				_tmp103__length1 = parts_length1;
				if (_tmp103__length1 != 2) {
					FILE* _tmp104_;
					_tmp104_ = stderr;
					fprintf (_tmp104_, "Error: --evemu-events argument must be devname=filename\n");
					result = 1;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				{
					UMockdevTestbed* _tmp105_;
					gchar** _tmp106_;
					gint _tmp106__length1;
					const gchar* _tmp107_;
					gchar** _tmp108_;
					gint _tmp108__length1;
					const gchar* _tmp109_;
					_tmp105_ = testbed;
					_tmp106_ = parts;
					_tmp106__length1 = parts_length1;
					_tmp107_ = _tmp106_[0];
					_tmp108_ = parts;
					_tmp108__length1 = parts_length1;
					_tmp109_ = _tmp108_[1];
					umockdev_testbed_load_evemu_events (_tmp105_, _tmp107_, _tmp109_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch6_g_error;
					}
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					FILE* _tmp110_;
					gchar** _tmp111_;
					gint _tmp111__length1;
					const gchar* _tmp112_;
					gchar** _tmp113_;
					gint _tmp113__length1;
					const gchar* _tmp114_;
					GError* _tmp115_;
					const gchar* _tmp116_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp110_ = stderr;
					_tmp111_ = parts;
					_tmp111__length1 = parts_length1;
					_tmp112_ = _tmp111_[1];
					_tmp113_ = parts;
					_tmp113__length1 = parts_length1;
					_tmp114_ = _tmp113_[0];
					_tmp115_ = e;
					_tmp116_ = _tmp115_->message;
					fprintf (_tmp110_, "Error: Cannot install %s for device %s: %s\n", _tmp112_, _tmp114_, _tmp116_);
					result = 1;
					_g_error_free0 (e);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally6:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gint _tmp117_ = 0;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp117_;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (i);
			}
		}
	}
	_tmp118_ = opt_program;
	_tmp118__length1 = _vala_array_length (opt_program);
	if (_tmp118__length1 == 0) {
		FILE* _tmp119_;
		_tmp119_ = stderr;
		fprintf (_tmp119_, "No program specified. See --help for how to use umockdev-run\n");
		result = 1;
		_g_object_unref0 (testbed);
		_g_free0 (preload);
		_g_option_context_free0 (oc);
		return result;
	}
	{
		gchar** _tmp120_;
		gint _tmp120__length1;
		GPid _tmp121_ = 0;
		_tmp120_ = opt_program;
		_tmp120__length1 = _vala_array_length (opt_program);
		g_spawn_async (NULL, _tmp120_, NULL, (G_SPAWN_SEARCH_PATH | G_SPAWN_CHILD_INHERITS_STDIN) | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp121_, &_inner_error_);
		child_pid = _tmp121_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp122_;
		gchar** _tmp123_;
		gint _tmp123__length1;
		const gchar* _tmp124_;
		const gchar* _tmp125_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp122_ = stderr;
		_tmp123_ = opt_program;
		_tmp123__length1 = _vala_array_length (opt_program);
		_tmp124_ = _tmp123_[0];
		_tmp125_ = e->message;
		fprintf (_tmp122_, "Cannot run %s: %s\n", _tmp124_, _tmp125_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp126_ = 0;
		_g_object_unref0 (testbed);
		_g_free0 (preload);
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp126_;
	}
	memset (&_tmp127_, 0, sizeof (struct sigaction));
	_tmp127_.sa_handler = _child_sig_handler_sighandler_t;
	_tmp127_.sa_flags = SA_RESETHAND;
	act = _tmp127_;
	_tmp128_ = act;
	_tmp129_ = _tmp128_.sa_mask;
	sigemptyset (&_tmp129_);
	_tmp130_ = act;
	_tmp131_ = sigaction (SIGTERM, &_tmp130_, NULL);
	_vala_assert (_tmp131_ == 0, "Posix.sigaction (Posix.SIGTERM, act, null) == 0");
	_tmp132_ = act;
	_tmp133_ = sigaction (SIGHUP, &_tmp132_, NULL);
	_vala_assert (_tmp133_ == 0, "Posix.sigaction (Posix.SIGHUP, act, null) == 0");
	_tmp134_ = act;
	_tmp135_ = sigaction (SIGINT, &_tmp134_, NULL);
	_vala_assert (_tmp135_ == 0, "Posix.sigaction (Posix.SIGINT, act, null) == 0");
	_tmp136_ = act;
	_tmp137_ = sigaction (SIGQUIT, &_tmp136_, NULL);
	_vala_assert (_tmp137_ == 0, "Posix.sigaction (Posix.SIGQUIT, act, null) == 0");
	_tmp138_ = act;
	_tmp139_ = sigaction (SIGABRT, &_tmp138_, NULL);
	_vala_assert (_tmp139_ == 0, "Posix.sigaction (Posix.SIGABRT, act, null) == 0");
	_tmp140_ = child_pid;
	waitpid ((pid_t) _tmp140_, &_tmp141_, 0);
	status = _tmp141_;
	_tmp142_ = child_pid;
	g_spawn_close_pid (_tmp142_);
	_g_object_unref0 (testbed);
	testbed = NULL;
	_tmp143_ = status;
	_tmp144_ = WIFEXITED (_tmp143_);
	if (_tmp144_) {
		gint _tmp145_;
		gint _tmp146_;
		_tmp145_ = status;
		_tmp146_ = WEXITSTATUS (_tmp145_);
		result = _tmp146_;
		_g_object_unref0 (testbed);
		_g_free0 (preload);
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp147_ = status;
	_tmp148_ = WIFSIGNALED (_tmp147_);
	if (_tmp148_) {
		gint _tmp149_;
		int _tmp150_;
		_tmp149_ = status;
		_tmp150_ = WTERMSIG (_tmp149_);
		raise (_tmp150_);
	}
	result = status;
	_g_object_unref0 (testbed);
	_g_free0 (preload);
	_g_option_context_free0 (oc);
	return result;
}


int main (int argc, char ** argv) {
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



