/* umockdev-record.c generated by valac 0.38.2, the Vala compiler
 * generated from umockdev-record.vala, do not modify */

/*
 * Record Linux devices and their ancestors from sysfs/udev.
 * All attributes and properties are included, non-ASCII ones get printed in hex.
 * The record is written to the standard output.
 *
 * Copyright (C) 2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <errno.h>
#include <sys/types.h>
#include <glib/gstdio.h>
#include <fcntl.h>
#include <unistd.h>
#include "config.h"

#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))


extern guint record_script_counter;
guint record_script_counter = (guint) 0;
extern gchar** opt_devices;
gchar** opt_devices = NULL;
extern gboolean opt_all;
gboolean opt_all = FALSE;
extern gchar* opt_ioctl;
gchar* opt_ioctl = NULL;
extern gchar** opt_script;
gchar** opt_script = NULL;
extern gchar** opt_evemu_events;
gchar** opt_evemu_events = NULL;
extern gboolean opt_version;
gboolean opt_version = FALSE;

void exit_error (const gchar* message, ...);
void devices_from_dir (const gchar* dir, GPtrArray* * devs);
gchar** all_devices (void);
static void _g_free0_ (gpointer var);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar* resolve (const gchar* dev);
gchar* parent (const gchar* dev);
gchar* format_hex (guint8* bytes, int bytes_length1, gint len);
void write_attr (const gchar* name, guint8* val, int val_length1);
gchar* dev_contents (const gchar* dev);
void print_device_attributes (const gchar* devpath, const gchar* subdir);
static inline void _g_list_free__g_free0_ (GList* self);
void record_device (const gchar* dev);
void dump_devices (gchar** devices, int devices_length1);
void split_devfile_arg (const gchar* arg, gchar* * dev, gchar* * devnum, gchar* * fname);
void record_ioctl (const gchar* arg);
void record_script (const gchar* arg, const gchar* format);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[7] = {{"all", 'a', 0, G_OPTION_ARG_NONE, &opt_all, "Record all devices"}, {"ioctl", 'i', 0, G_OPTION_ARG_FILENAME, &opt_ioctl, "Trace ioctls on the device, record into given file. In this case, all " \
"positional arguments are a command (and its arguments) to run that get" \
"s traced.", "devname=FILE"}, {"script", 's', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_script, "Trace reads and writes on the device, record into given file. In this " \
"case, all positional arguments are a command (and its arguments) to ru" \
"n that gets traced. Can be specified multiple times.", "devname=FILE"}, {"evemu-events", 'e', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_evemu_events, "Trace evdev event reads on the device, record into given file in EVEMU" \
" event format. In this case, all positional arguments are a command (a" \
"nd its arguments) to run that gets traced. Can be specified multiple t" \
"imes.", "devname=FILE"}, {"", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &opt_devices, "Path of a device in /dev or /sys, or command and arguments with --ioct" \
"l.", "DEVICE [...]"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &opt_version, "Output version information and exit"}, {NULL}};

void exit_error (const gchar* message, ...) {
	FILE* _tmp0_;
	const gchar* _tmp1_;
	va_list _tmp2_ = {0};
	FILE* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = stderr;
	_tmp1_ = message;
	va_start (_tmp2_, message);
	vfprintf (_tmp0_, _tmp1_, _tmp2_);
	va_end (_tmp2_);
	_tmp3_ = stderr;
	fputs ("\n", _tmp3_);
	exit (1);
}


void devices_from_dir (const gchar* dir, GPtrArray* * devs) {
	GDir* d = NULL;
	gboolean has_uevent = FALSE;
	gboolean has_subsystem = FALSE;
	gchar* entry = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dir != NULL);
	g_return_if_fail (*devs != NULL);
	{
		GDir* _tmp0_ = NULL;
		const gchar* _tmp1_;
		GDir* _tmp2_;
		GDir* _tmp3_;
		_tmp1_ = dir;
		_tmp2_ = g_dir_open (_tmp1_, (guint) 0, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_dir_close0 (d);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_dir_close0 (d);
		d = _tmp3_;
		_g_dir_close0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
		_g_dir_close0 (d);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_dir_close0 (d);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	has_uevent = FALSE;
	has_subsystem = FALSE;
	while (TRUE) {
		GDir* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = d;
		_tmp5_ = g_dir_read_name (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (entry);
		entry = _tmp6_;
		_tmp7_ = entry;
		if (!(_tmp7_ != NULL)) {
			break;
		}
		_tmp8_ = entry;
		if (g_strcmp0 (_tmp8_, "uevent") == 0) {
			has_uevent = TRUE;
		} else {
			const gchar* _tmp9_;
			_tmp9_ = entry;
			if (g_strcmp0 (_tmp9_, "subsystem") == 0) {
				has_subsystem = TRUE;
			} else {
				gchar* p = NULL;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				struct stat st = {0};
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				const gchar* _tmp15_;
				struct stat _tmp16_ = {0};
				gint _tmp17_;
				_tmp10_ = dir;
				_tmp11_ = entry;
				_tmp12_ = g_build_filename (_tmp10_, _tmp11_, NULL);
				p = _tmp12_;
				_tmp15_ = p;
				_tmp17_ = lstat (_tmp15_, &_tmp16_);
				st = _tmp16_;
				if (_tmp17_ == 0) {
					struct stat _tmp18_;
					mode_t _tmp19_;
					gboolean _tmp20_;
					_tmp18_ = st;
					_tmp19_ = _tmp18_.st_mode;
					_tmp20_ = S_ISDIR (_tmp19_);
					_tmp14_ = _tmp20_;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					struct stat _tmp21_;
					mode_t _tmp22_;
					gboolean _tmp23_;
					_tmp21_ = st;
					_tmp22_ = _tmp21_.st_mode;
					_tmp23_ = S_ISLNK (_tmp22_);
					_tmp13_ = !_tmp23_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					const gchar* _tmp24_;
					_tmp24_ = p;
					devices_from_dir (_tmp24_, devs);
				}
				_g_free0 (p);
			}
		}
	}
	_tmp26_ = has_uevent;
	if (_tmp26_) {
		gboolean _tmp27_;
		_tmp27_ = has_subsystem;
		_tmp25_ = _tmp27_;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		GPtrArray* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp28_ = *devs;
		_tmp29_ = dir;
		_tmp30_ = g_strdup (_tmp29_);
		g_ptr_array_add (_tmp28_, _tmp30_);
	}
	_g_free0 (entry);
	_g_dir_close0 (d);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar** all_devices (void) {
	gchar** result = NULL;
	GPtrArray* devs = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	devs = _tmp0_;
	devices_from_dir ("/sys/devices", &devs);
	_tmp1_ = devs;
	_tmp2_ = _tmp1_->pdata;
	_tmp2__length1 = (gint) _tmp1_->len;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	result = _tmp3_;
	_g_ptr_array_unref0 (devs);
	return result;
}


gchar* resolve (const gchar* dev) {
	gchar* result = NULL;
	struct stat st = {0};
	const gchar* _tmp0_;
	struct stat _tmp1_ = {0};
	gint _tmp2_;
	guint major = 0U;
	struct stat _tmp6_;
	dev_t _tmp7_;
	guint _tmp8_;
	guint minor = 0U;
	struct stat _tmp9_;
	dev_t _tmp10_;
	guint _tmp11_;
	gchar* link = NULL;
	struct stat _tmp12_;
	mode_t _tmp13_;
	gboolean _tmp14_;
	gchar* real = NULL;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = dev;
	_tmp2_ = stat (_tmp0_, &_tmp1_);
	st = _tmp1_;
	if (_tmp2_ != 0) {
		const gchar* _tmp3_;
		gint _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = dev;
		_tmp4_ = errno;
		_tmp5_ = g_strerror (_tmp4_);
		exit_error ("Cannot access device %s: %s", _tmp3_, _tmp5_, NULL);
	}
	_tmp6_ = st;
	_tmp7_ = _tmp6_.st_rdev;
	_tmp8_ = major (_tmp7_);
	major = _tmp8_;
	_tmp9_ = st;
	_tmp10_ = _tmp9_.st_rdev;
	_tmp11_ = minor (_tmp10_);
	minor = _tmp11_;
	_tmp12_ = st;
	_tmp13_ = _tmp12_.st_mode;
	_tmp14_ = S_ISCHR (_tmp13_);
	if (_tmp14_) {
		guint _tmp15_;
		guint _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = major;
		_tmp16_ = minor;
		_tmp17_ = g_strdup_printf ("/sys/dev/char/%u:%u", _tmp15_, _tmp16_);
		_g_free0 (link);
		link = _tmp17_;
	} else {
		struct stat _tmp18_;
		mode_t _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = st;
		_tmp19_ = _tmp18_.st_mode;
		_tmp20_ = S_ISBLK (_tmp19_);
		if (_tmp20_) {
			guint _tmp21_;
			guint _tmp22_;
			gchar* _tmp23_;
			_tmp21_ = major;
			_tmp22_ = minor;
			_tmp23_ = g_strdup_printf ("/sys/dev/block/%u:%u", _tmp21_, _tmp22_);
			_g_free0 (link);
			link = _tmp23_;
		} else {
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp24_ = dev;
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (link);
			link = _tmp25_;
		}
	}
	_tmp26_ = link;
	_tmp27_ = realpath (_tmp26_, NULL);
	real = _tmp27_;
	_tmp28_ = real;
	if (_tmp28_ == NULL) {
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp29_ = link;
		_tmp30_ = g_strdup (_tmp29_);
		_g_free0 (real);
		real = _tmp30_;
	}
	_tmp31_ = real;
	_tmp32_ = g_build_filename (_tmp31_, "uevent", NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_file_test (_tmp33_, G_FILE_TEST_EXISTS);
	_tmp35_ = !_tmp34_;
	_g_free0 (_tmp33_);
	if (_tmp35_) {
		const gchar* _tmp36_;
		_tmp36_ = real;
		exit_error ("Invalid device %s, has no uevent attribute", _tmp36_, NULL);
	}
	result = real;
	_g_free0 (link);
	return result;
}


gchar* parent (const gchar* dev) {
	gchar* result = NULL;
	gchar* p = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = dev;
	_tmp1_ = g_path_get_dirname (_tmp0_);
	p = _tmp1_;
	_tmp2_ = p;
	_tmp3_ = g_str_has_prefix (_tmp2_, "/sys");
	if (!_tmp3_) {
		result = NULL;
		_g_free0 (p);
		return result;
	}
	_tmp5_ = p;
	_tmp6_ = g_build_filename (_tmp5_, "uevent", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	if (_tmp9_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = p;
		_tmp11_ = g_build_filename (_tmp10_, "subsystem", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_test (_tmp12_, G_FILE_TEST_EXISTS);
		_tmp4_ = _tmp13_;
		_g_free0 (_tmp12_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = p;
		return result;
	}
	_tmp14_ = p;
	_tmp15_ = parent (_tmp14_);
	result = _tmp15_;
	_g_free0 (p);
	return result;
}


gchar* format_hex (guint8* bytes, int bytes_length1, gint len) {
	gchar* result = NULL;
	gint _tmp0_;
	GString* _result_ = NULL;
	GString* _tmp2_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	_tmp0_ = len;
	if (_tmp0_ < 0) {
		guint8* _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = bytes;
		_tmp1__length1 = bytes_length1;
		len = _tmp1__length1;
	}
	_tmp2_ = g_string_new ("");
	_result_ = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				GString* _tmp7_;
				guint8* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				guint8 _tmp10_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = len;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _result_;
				_tmp8_ = bytes;
				_tmp8__length1 = bytes_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				g_string_append_printf (_tmp7_, "%02X", (guint) _tmp10_);
			}
		}
	}
	_tmp11_ = _result_;
	_tmp12_ = _tmp11_->str;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	_g_string_free0 (_result_);
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchomp (_tmp1_);
	result = _result_;
	return result;
}


void write_attr (const gchar* name, guint8* val, int val_length1) {
	gchar* strval = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	guint8* _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	FILE* _tmp21_;
	g_return_if_fail (name != NULL);
	_tmp0_ = val;
	_tmp0__length1 = val_length1;
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	strval = _tmp1_;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	_tmp4_ = strval;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp3__length1 == _tmp6_) {
		const gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = strval;
		_tmp8_ = g_utf8_validate (_tmp7_, (gssize) -1, NULL);
		_tmp2_ = _tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		FILE* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp9_ = stdout;
		_tmp10_ = name;
		_tmp11_ = strval;
		_tmp12_ = string_chomp (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strescape (_tmp13_, "");
		_tmp15_ = _tmp14_;
		fprintf (_tmp9_, "A: %s=%s", _tmp10_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
	} else {
		FILE* _tmp16_;
		const gchar* _tmp17_;
		guint8* _tmp18_;
		gint _tmp18__length1;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = stdout;
		_tmp17_ = name;
		_tmp18_ = val;
		_tmp18__length1 = val_length1;
		_tmp19_ = format_hex (_tmp18_, _tmp18__length1, -1);
		_tmp20_ = _tmp19_;
		fprintf (_tmp16_, "H: %s=%s", _tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
	}
	_tmp21_ = stdout;
	fputc ('\n', _tmp21_);
	_g_free0 (strval);
}


gchar* dev_contents (const gchar* dev) {
	gchar* result = NULL;
	struct stat st = {0};
	const gchar* _tmp0_;
	struct stat _tmp1_ = {0};
	gint _tmp2_;
	gboolean _tmp4_ = FALSE;
	struct stat _tmp5_;
	mode_t _tmp6_;
	gboolean _tmp7_;
	gint fd = 0;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	guint8* buffer = NULL;
	guint8* _tmp16_;
	gint buffer_length1;
	gint _buffer_size_;
	gssize len = 0L;
	gint _tmp17_;
	guint8* _tmp18_;
	gint _tmp18__length1;
	gssize _tmp19_;
	gchar* _result_ = NULL;
	gchar* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gssize _tmp22_;
	gint _tmp29_;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = dev;
	_tmp2_ = lstat (_tmp0_, &_tmp1_);
	st = _tmp1_;
	if (_tmp2_ != 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	_tmp5_ = st;
	_tmp6_ = _tmp5_.st_mode;
	_tmp7_ = S_ISCHR (_tmp6_);
	if (!_tmp7_) {
		_tmp4_ = TRUE;
	} else {
		struct stat _tmp8_;
		dev_t _tmp9_;
		guint _tmp10_;
		_tmp8_ = st;
		_tmp9_ = _tmp8_.st_rdev;
		_tmp10_ = major (_tmp9_);
		_tmp4_ = _tmp10_ != ((guint) 189);
	}
	if (_tmp4_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("");
		result = _tmp11_;
		return result;
	}
	_tmp12_ = dev;
	_tmp13_ = open (_tmp12_, O_RDONLY | O_NONBLOCK, (mode_t) 0);
	fd = _tmp13_;
	_tmp14_ = fd;
	if (_tmp14_ < 0) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("");
		result = _tmp15_;
		return result;
	}
	_tmp16_ = g_new0 (guint8, 1025);
	buffer = _tmp16_;
	buffer_length1 = 1025;
	_buffer_size_ = buffer_length1;
	_tmp17_ = fd;
	_tmp18_ = buffer;
	_tmp18__length1 = buffer_length1;
	_tmp19_ = read (_tmp17_, _tmp18_, (gsize) 1025);
	len = _tmp19_;
	_tmp20_ = g_strdup ("");
	_result_ = _tmp20_;
	_tmp22_ = len;
	if (_tmp22_ > ((gssize) 0)) {
		gssize _tmp23_;
		_tmp23_ = len;
		_tmp21_ = _tmp23_ <= ((gssize) 1024);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		guint8* _tmp24_;
		gint _tmp24__length1;
		gssize _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = buffer;
		_tmp24__length1 = buffer_length1;
		_tmp25_ = len;
		_tmp26_ = format_hex (_tmp24_, _tmp24__length1, (gint) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("=", _tmp27_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp28_;
		_g_free0 (_tmp27_);
	}
	_tmp29_ = fd;
	close (_tmp29_);
	result = _result_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static inline void _g_list_free__g_free0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}


void print_device_attributes (const gchar* devpath, const gchar* subdir) {
	GDir* d = NULL;
	gchar* attr_dir = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GList* attributes = NULL;
	gchar* entry = NULL;
	GCompareFunc _tmp26_;
	GList* _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (subdir != NULL);
	_tmp0_ = devpath;
	_tmp1_ = subdir;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, NULL);
	attr_dir = _tmp2_;
	{
		GDir* _tmp3_ = NULL;
		const gchar* _tmp4_;
		GDir* _tmp5_;
		GDir* _tmp6_;
		_tmp4_ = attr_dir;
		_tmp5_ = g_dir_open (_tmp4_, (guint) 0, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_dir_close0 (d);
		d = _tmp6_;
		_g_dir_close0 (_tmp3_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = subdir;
		if (g_strcmp0 (_tmp7_, "") == 0) {
			const gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = attr_dir;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			exit_error ("Cannot open directory %s: %s", _tmp8_, _tmp10_, NULL);
		} else {
			const gchar* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = attr_dir;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_debug ("umockdev-record.vala:180: Cannot open directory %s: %s", _tmp11_, _tmp13_);
		}
		_g_error_free0 (e);
		_g_free0 (attr_dir);
		_g_dir_close0 (d);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (attr_dir);
		_g_dir_close0 (d);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	attributes = NULL;
	while (TRUE) {
		GDir* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_;
		_tmp14_ = d;
		_tmp15_ = g_dir_read_name (_tmp14_);
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (entry);
		entry = _tmp16_;
		_tmp17_ = entry;
		if (!(_tmp17_ != NULL)) {
			break;
		}
		_tmp20_ = entry;
		if (g_strcmp0 (_tmp20_, "subsystem") != 0) {
			const gchar* _tmp21_;
			_tmp21_ = entry;
			_tmp19_ = g_strcmp0 (_tmp21_, "firmware_node") != 0;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			const gchar* _tmp22_;
			_tmp22_ = entry;
			_tmp18_ = g_strcmp0 (_tmp22_, "uevent") != 0;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp23_ = entry;
			_tmp24_ = g_strdup (_tmp23_);
			attributes = g_list_append (attributes, _tmp24_);
		} else {
			const gchar* _tmp25_;
			_tmp25_ = subdir;
			if (g_strcmp0 (_tmp25_, "") != 0) {
				_g_free0 (entry);
				__g_list_free__g_free0_0 (attributes);
				_g_free0 (attr_dir);
				_g_dir_close0 (d);
				return;
			}
		}
	}
	_tmp26_ = g_strcmp0;
	attributes = g_list_sort (attributes, _tmp26_);
	_tmp27_ = attributes;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp27_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			gchar* _tmp28_;
			gchar* attr = NULL;
			_tmp28_ = g_strdup ((const gchar*) attr_it->data);
			attr = _tmp28_;
			{
				gchar* attr_path = NULL;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* attr_name = NULL;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				gboolean _tmp36_;
				_tmp29_ = attr_dir;
				_tmp30_ = attr;
				_tmp31_ = g_build_filename (_tmp29_, _tmp30_, NULL);
				attr_path = _tmp31_;
				_tmp32_ = subdir;
				_tmp33_ = attr;
				_tmp34_ = g_build_filename (_tmp32_, _tmp33_, NULL);
				attr_name = _tmp34_;
				_tmp35_ = attr_path;
				_tmp36_ = g_file_test (_tmp35_, G_FILE_TEST_IS_SYMLINK);
				if (_tmp36_) {
					{
						gchar* _tmp37_ = NULL;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						FILE* _tmp40_;
						const gchar* _tmp41_;
						_tmp38_ = attr_path;
						_tmp39_ = g_file_read_link (_tmp38_, &_inner_error_);
						_tmp37_ = _tmp39_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch2_g_error;
						}
						_tmp40_ = stdout;
						_tmp41_ = attr_name;
						fprintf (_tmp40_, "L: %s=%s\n", _tmp41_, _tmp37_);
						_g_free0 (_tmp37_);
					}
					goto __finally2;
					__catch2_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp42_;
						GError* _tmp43_;
						const gchar* _tmp44_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp42_ = attr_path;
						_tmp43_ = e;
						_tmp44_ = _tmp43_->message;
						exit_error ("Cannot read link %s: %s", _tmp42_, _tmp44_, NULL);
						_g_error_free0 (e);
					}
					__finally2:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (attr_name);
						_g_free0 (attr_path);
						_g_free0 (attr);
						_g_free0 (entry);
						__g_list_free__g_free0_0 (attributes);
						_g_free0 (attr_dir);
						_g_dir_close0 (d);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					const gchar* _tmp45_;
					gboolean _tmp46_;
					_tmp45_ = attr_path;
					_tmp46_ = g_file_test (_tmp45_, G_FILE_TEST_IS_REGULAR);
					if (_tmp46_) {
						guint8* contents = NULL;
						gint contents_length1 = 0;
						gint _contents_size_ = 0;
						{
							const gchar* _tmp47_;
							guint8* _tmp48_ = NULL;
							size_t _tmp49_;
							const gchar* _tmp50_;
							guint8* _tmp51_;
							gint _tmp51__length1;
							_tmp47_ = attr_path;
							g_file_get_contents (_tmp47_, (gchar**) (&_tmp48_), &_tmp49_, &_inner_error_);
							contents = (g_free (contents), NULL);
							contents = _tmp48_;
							contents_length1 = _tmp49_;
							_contents_size_ = contents_length1;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == G_FILE_ERROR) {
									goto __catch3_g_file_error;
								}
								contents = (g_free (contents), NULL);
								_g_free0 (attr_name);
								_g_free0 (attr_path);
								_g_free0 (attr);
								_g_free0 (entry);
								__g_list_free__g_free0_0 (attributes);
								_g_free0 (attr_dir);
								_g_dir_close0 (d);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp50_ = attr_name;
							_tmp51_ = contents;
							_tmp51__length1 = contents_length1;
							write_attr (_tmp50_, _tmp51_, _tmp51__length1);
						}
						goto __finally3;
						__catch3_g_file_error:
						{
							GError* e = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (e);
						}
						__finally3:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							contents = (g_free (contents), NULL);
							_g_free0 (attr_name);
							_g_free0 (attr_path);
							_g_free0 (attr);
							_g_free0 (entry);
							__g_list_free__g_free0_0 (attributes);
							_g_free0 (attr_dir);
							_g_dir_close0 (d);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						contents = (g_free (contents), NULL);
					} else {
						const gchar* _tmp52_;
						gboolean _tmp53_;
						_tmp52_ = attr_path;
						_tmp53_ = g_file_test (_tmp52_, G_FILE_TEST_IS_DIR);
						if (_tmp53_) {
							const gchar* _tmp54_;
							const gchar* _tmp55_;
							_tmp54_ = devpath;
							_tmp55_ = attr;
							print_device_attributes (_tmp54_, _tmp55_);
						}
					}
				}
				_g_free0 (attr_name);
				_g_free0 (attr_path);
				_g_free0 (attr);
			}
		}
	}
	_g_free0 (entry);
	__g_list_free__g_free0_0 (attributes);
	_g_free0 (attr_dir);
	_g_dir_close0 (d);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void record_device (const gchar* dev) {
	const gchar* _tmp0_;
	gchar* u_out = NULL;
	gchar* u_err = NULL;
	gint exitcode = 0;
	const gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	const gchar* _tmp56_;
	gboolean _tmp57_;
	const gchar* _tmp59_;
	FILE* _tmp60_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dev != NULL);
	_tmp0_ = dev;
	g_debug ("umockdev-record.vala:222: recording device %s", _tmp0_);
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_;
		_tmp1_ = g_strdup ("udevadm");
		_tmp2_ = g_strdup ("info");
		_tmp3_ = g_strdup ("--query=all");
		_tmp4_ = g_strdup ("--path");
		_tmp5_ = dev;
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = g_new0 (gchar*, 5 + 1);
		_tmp7_[0] = _tmp1_;
		_tmp7_[1] = _tmp2_;
		_tmp7_[2] = _tmp3_;
		_tmp7_[3] = _tmp4_;
		_tmp7_[4] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 5;
		g_spawn_sync (NULL, _tmp8_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, &_tmp10_, &_tmp11_, &_inner_error_);
		_g_free0 (u_out);
		u_out = _tmp9_;
		_g_free0 (u_err);
		u_err = _tmp10_;
		exitcode = _tmp11_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp12_ = exitcode;
		if (_tmp12_ != 0) {
			gint _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GError* _tmp17_;
			GError* _tmp18_;
			_tmp13_ = exitcode;
			_tmp14_ = u_err;
			_tmp15_ = g_strdup_printf ("udevadm exited with code %i\n%s", _tmp13_, _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp16_);
			_tmp18_ = _tmp17_;
			_g_free0 (_tmp16_);
			_inner_error_ = _tmp18_;
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		exit_error ("Cannot call udevadm: %s", _tmp20_, NULL);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (u_err);
		_g_free0 (u_out);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp21_ = u_out;
	_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp23_;
		line_collection_length1 = _vala_array_length (_tmp22_);
		for (line_it = 0; line_it < _vala_array_length (_tmp22_); line_it = line_it + 1) {
			gchar* _tmp24_;
			gchar* line = NULL;
			_tmp24_ = g_strdup (line_collection[line_it]);
			line = _tmp24_;
			{
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				const gchar* _tmp40_;
				gboolean _tmp41_;
				FILE* _tmp53_;
				const gchar* _tmp54_;
				FILE* _tmp55_;
				_tmp29_ = line;
				_tmp30_ = strlen (_tmp29_);
				_tmp31_ = _tmp30_;
				if (_tmp31_ == 0) {
					_tmp28_ = TRUE;
				} else {
					const gchar* _tmp32_;
					gboolean _tmp33_;
					_tmp32_ = line;
					_tmp33_ = g_str_has_prefix (_tmp32_, "E: DEVPATH=");
					_tmp28_ = _tmp33_;
				}
				if (_tmp28_) {
					_tmp27_ = TRUE;
				} else {
					const gchar* _tmp34_;
					gboolean _tmp35_;
					_tmp34_ = line;
					_tmp35_ = g_str_has_prefix (_tmp34_, "E: UDEV_LOG=");
					_tmp27_ = _tmp35_;
				}
				if (_tmp27_) {
					_tmp26_ = TRUE;
				} else {
					const gchar* _tmp36_;
					gboolean _tmp37_;
					_tmp36_ = line;
					_tmp37_ = g_str_has_prefix (_tmp36_, "E: USEC_INITIALIZED=");
					_tmp26_ = _tmp37_;
				}
				if (_tmp26_) {
					_tmp25_ = TRUE;
				} else {
					const gchar* _tmp38_;
					gboolean _tmp39_;
					_tmp38_ = line;
					_tmp39_ = g_str_has_prefix (_tmp38_, "L: ");
					_tmp25_ = _tmp39_;
				}
				if (_tmp25_) {
					_g_free0 (line);
					continue;
				}
				_tmp40_ = line;
				_tmp41_ = g_str_has_prefix (_tmp40_, "N: ");
				if (_tmp41_) {
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					_tmp42_ = line;
					_tmp43_ = line;
					_tmp44_ = string_substring (_tmp43_, (glong) 3, (glong) -1);
					_tmp45_ = _tmp44_;
					_tmp46_ = string_chomp (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = g_strconcat ("/dev/", _tmp47_, NULL);
					_tmp49_ = _tmp48_;
					_tmp50_ = dev_contents (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = g_strconcat (_tmp42_, _tmp51_, NULL);
					_g_free0 (line);
					line = _tmp52_;
					_g_free0 (_tmp51_);
					_g_free0 (_tmp49_);
					_g_free0 (_tmp47_);
					_g_free0 (_tmp45_);
				}
				_tmp53_ = stdout;
				_tmp54_ = line;
				fputs (_tmp54_, _tmp53_);
				_tmp55_ = stdout;
				fputc ('\n', _tmp55_);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp56_ = dev;
	_tmp57_ = string_contains (_tmp56_, "tegra");
	if (_tmp57_) {
		FILE* _tmp58_;
		_tmp58_ = stdout;
		fputc ('\n', _tmp58_);
		_g_free0 (u_err);
		_g_free0 (u_out);
		return;
	}
	_tmp59_ = dev;
	print_device_attributes (_tmp59_, "");
	_tmp60_ = stdout;
	fputc ('\n', _tmp60_);
	_g_free0 (u_err);
	_g_free0 (u_out);
}


void dump_devices (gchar** devices, int devices_length1) {
	GHashTable* seen = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	seen = _tmp2_;
	_tmp3_ = devices;
	_tmp3__length1 = devices_length1;
	{
		gchar** device_collection = NULL;
		gint device_collection_length1 = 0;
		gint _device_collection_size_ = 0;
		gint device_it = 0;
		device_collection = _tmp3_;
		device_collection_length1 = _tmp3__length1;
		for (device_it = 0; device_it < _tmp3__length1; device_it = device_it + 1) {
			gchar* _tmp4_;
			gchar* device = NULL;
			_tmp4_ = g_strdup (device_collection[device_it]);
			device = _tmp4_;
			{
				while (TRUE) {
					const gchar* _tmp5_;
					GHashTable* _tmp6_;
					const gchar* _tmp7_;
					gboolean _tmp8_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp5_ = device;
					if (!(_tmp5_ != NULL)) {
						break;
					}
					_tmp6_ = seen;
					_tmp7_ = device;
					_tmp8_ = g_hash_table_contains (_tmp6_, _tmp7_);
					if (!_tmp8_) {
						GHashTable* _tmp9_;
						const gchar* _tmp10_;
						gchar* _tmp11_;
						const gchar* _tmp12_;
						_tmp9_ = seen;
						_tmp10_ = device;
						_tmp11_ = g_strdup (_tmp10_);
						g_hash_table_add (_tmp9_, _tmp11_);
						_tmp12_ = device;
						record_device (_tmp12_);
					}
					_tmp13_ = device;
					_tmp14_ = parent (_tmp13_);
					_g_free0 (device);
					device = _tmp14_;
				}
				_g_free0 (device);
			}
		}
	}
	_g_hash_table_unref0 (seen);
}


void split_devfile_arg (const gchar* arg, gchar* * dev, gchar* * devnum, gchar* * fname) {
	gchar* _vala_dev = NULL;
	gchar* _vala_devnum = NULL;
	gchar* _vala_fname = NULL;
	gchar** parts = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	struct stat st = {0};
	const gchar* _tmp10_;
	struct stat _tmp11_ = {0};
	gint _tmp12_;
	gboolean _tmp16_ = FALSE;
	struct stat _tmp17_;
	mode_t _tmp18_;
	gboolean _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (arg != NULL);
	_tmp0_ = arg;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "=", 2);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = parts;
	_tmp3__length1 = parts_length1;
	if (_tmp3__length1 != 2) {
		exit_error ("--ioctl argument must be devname=filename", NULL);
	}
	_tmp4_ = parts;
	_tmp4__length1 = parts_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_vala_dev);
	_vala_dev = _tmp6_;
	_tmp7_ = parts;
	_tmp7__length1 = parts_length1;
	_tmp8_ = _tmp7_[1];
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (_vala_fname);
	_vala_fname = _tmp9_;
	_tmp10_ = _vala_dev;
	_tmp12_ = stat (_tmp10_, &_tmp11_);
	st = _tmp11_;
	if (_tmp12_ != 0) {
		const gchar* _tmp13_;
		gint _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = _vala_dev;
		_tmp14_ = errno;
		_tmp15_ = g_strerror (_tmp14_);
		exit_error ("Cannot access device %s: %s", _tmp13_, _tmp15_, NULL);
	}
	_tmp17_ = st;
	_tmp18_ = _tmp17_.st_mode;
	_tmp19_ = S_ISCHR (_tmp18_);
	if (_tmp19_) {
		_tmp16_ = TRUE;
	} else {
		struct stat _tmp20_;
		mode_t _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = st;
		_tmp21_ = _tmp20_.st_mode;
		_tmp22_ = S_ISBLK (_tmp21_);
		_tmp16_ = _tmp22_;
	}
	if (_tmp16_) {
		struct stat _tmp23_;
		dev_t _tmp24_;
		guint _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		struct stat _tmp30_;
		dev_t _tmp31_;
		guint _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp23_ = st;
		_tmp24_ = _tmp23_.st_rdev;
		_tmp25_ = major (_tmp24_);
		_tmp26_ = g_strdup_printf ("%u", _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, ":", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = st;
		_tmp31_ = _tmp30_.st_rdev;
		_tmp32_ = minor (_tmp31_);
		_tmp33_ = g_strdup_printf ("%u", _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
		_g_free0 (_vala_devnum);
		_vala_devnum = _tmp35_;
		_g_free0 (_tmp34_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
	} else {
		struct stat _tmp36_;
		mode_t _tmp37_;
		gboolean _tmp38_;
		_tmp36_ = st;
		_tmp37_ = _tmp36_.st_mode;
		_tmp38_ = S_ISSOCK (_tmp37_);
		if (_tmp38_) {
			const gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp39_ = _vala_dev;
			_tmp40_ = g_strdup (_tmp39_);
			_g_free0 (_vala_devnum);
			_vala_devnum = _tmp40_;
		} else {
			{
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_ = NULL;
				_tmp41_ = _vala_dev;
				_tmp42_ = g_build_filename (_tmp41_, "dev", NULL);
				_tmp43_ = _tmp42_;
				g_file_get_contents (_tmp43_, &_tmp44_, NULL, &_inner_error_);
				_g_free0 (_vala_devnum);
				_vala_devnum = _tmp44_;
				_g_free0 (_tmp43_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch5_g_error;
				}
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp45_;
				GError* _tmp46_;
				const gchar* _tmp47_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp45_ = _vala_dev;
				_tmp46_ = e;
				_tmp47_ = _tmp46_->message;
				exit_error ("Cannot open %s/dev: %s", _tmp45_, _tmp47_, NULL);
				_g_error_free0 (e);
			}
			__finally5:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (dev) {
		*dev = _vala_dev;
	} else {
		_g_free0 (_vala_dev);
	}
	if (devnum) {
		*devnum = _vala_devnum;
	} else {
		_g_free0 (_vala_devnum);
	}
	if (fname) {
		*fname = _vala_fname;
	} else {
		_g_free0 (_vala_fname);
	}
}


void record_ioctl (const gchar* arg) {
	gchar* dev = NULL;
	gchar* devnum = NULL;
	gchar* outfile = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (arg != NULL);
	_tmp0_ = arg;
	split_devfile_arg (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (dev);
	dev = _tmp1_;
	_g_free0 (devnum);
	devnum = _tmp2_;
	_g_free0 (outfile);
	outfile = _tmp3_;
	g_setenv ("UMOCKDEV_IOCTL_RECORD_FILE", outfile, TRUE);
	g_setenv ("UMOCKDEV_IOCTL_RECORD_DEV", devnum, TRUE);
	g_setenv ("UMOCKDEV_IOCTL_RECORD_DEVICE_PATH", dev, TRUE);
	_g_free0 (outfile);
	_g_free0 (devnum);
	_g_free0 (dev);
}


void record_script (const gchar* arg, const gchar* format) {
	gchar* dev = NULL;
	gchar* devnum = NULL;
	gchar* outfile = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* c = NULL;
	guint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	guint _tmp15_;
	g_return_if_fail (arg != NULL);
	g_return_if_fail (format != NULL);
	_tmp0_ = arg;
	split_devfile_arg (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (dev);
	dev = _tmp1_;
	_g_free0 (devnum);
	devnum = _tmp2_;
	_g_free0 (outfile);
	outfile = _tmp3_;
	_tmp4_ = record_script_counter;
	_tmp5_ = g_strdup_printf ("%u", _tmp4_);
	c = _tmp5_;
	_tmp6_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_FILE_", c, NULL);
	_tmp7_ = _tmp6_;
	g_setenv (_tmp7_, outfile, TRUE);
	_g_free0 (_tmp7_);
	_tmp8_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_DEV_", c, NULL);
	_tmp9_ = _tmp8_;
	g_setenv (_tmp9_, devnum, TRUE);
	_g_free0 (_tmp9_);
	_tmp10_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_DEVICE_PATH_", c, NULL);
	_tmp11_ = _tmp10_;
	g_setenv (_tmp11_, dev, TRUE);
	_g_free0 (_tmp11_);
	_tmp12_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_FORMAT_", c, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = format;
	g_setenv (_tmp13_, _tmp14_, TRUE);
	_g_free0 (_tmp13_);
	_tmp15_ = record_script_counter;
	record_script_counter = _tmp15_ + 1;
	_g_free0 (c);
	_g_free0 (outfile);
	_g_free0 (devnum);
	_g_free0 (dev);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* oc = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	gboolean _tmp9_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	gchar* preload = NULL;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar** _tmp57_;
	gint _tmp57__length1;
	gchar** _tmp60_;
	gint _tmp60__length1;
	gchar** _tmp63_;
	gint _tmp63__length1;
	const gchar* _tmp64_;
	gchar** _tmp65_;
	gint _tmp65__length1;
	gchar** _tmp66_;
	gint _tmp66__length1;
	const gchar* _tmp67_;
	gint _tmp68_;
	const gchar* _tmp69_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("");
	oc = _tmp0_;
	_tmp1_ = oc;
	g_option_context_set_summary (_tmp1_, "Record Linux devices and their ancestors from sysfs/udev, or record io" \
"ctls for a device.");
	_tmp2_ = oc;
	g_option_context_add_main_entries (_tmp2_, options, NULL);
	{
		GOptionContext* _tmp3_;
		_tmp3_ = oc;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		exit_error ("Error: %s\nRun %s --help for how to use this program", _tmp5_, _tmp7_, NULL);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp8_ = 0;
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp8_;
	}
	_tmp9_ = opt_version;
	if (_tmp9_) {
		FILE* _tmp10_;
		_tmp10_ = stdout;
		fprintf (_tmp10_, "%s\n", VERSION);
		result = 0;
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp12_ = opt_all;
	if (_tmp12_) {
		gchar** _tmp13_;
		gint _tmp13__length1;
		_tmp13_ = opt_devices;
		_tmp13__length1 = _vala_array_length (opt_devices);
		_tmp11_ = _tmp13__length1 > 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		exit_error ("Specifying a device list together with --all is invalid.", NULL);
	}
	_tmp15_ = opt_all;
	if (!_tmp15_) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = opt_devices;
		_tmp16__length1 = _vala_array_length (opt_devices);
		_tmp14_ = _tmp16__length1 == 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		exit_error ("Need to specify at least one device or --all.", NULL);
	}
	_tmp20_ = opt_ioctl;
	if (_tmp20_ != NULL) {
		_tmp19_ = TRUE;
	} else {
		gchar** _tmp21_;
		gint _tmp21__length1;
		_tmp21_ = opt_script;
		_tmp21__length1 = _vala_array_length (opt_script);
		_tmp19_ = _tmp21__length1 > 0;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gchar** _tmp22_;
		gint _tmp22__length1;
		_tmp22_ = opt_evemu_events;
		_tmp22__length1 = _vala_array_length (opt_evemu_events);
		_tmp18_ = _tmp22__length1 > 0;
	}
	if (_tmp18_) {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
		_tmp24_ = opt_all;
		if (_tmp24_) {
			_tmp23_ = TRUE;
		} else {
			gchar** _tmp25_;
			gint _tmp25__length1;
			_tmp25_ = opt_devices;
			_tmp25__length1 = _vala_array_length (opt_devices);
			_tmp23_ = _tmp25__length1 < 1;
		}
		_tmp17_ = _tmp23_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		exit_error ("For recording ioctls or scripts you have to specify a command to run", NULL);
	}
	_tmp28_ = opt_ioctl;
	if (_tmp28_ == NULL) {
		gchar** _tmp29_;
		gint _tmp29__length1;
		_tmp29_ = opt_script;
		_tmp29__length1 = _vala_array_length (opt_script);
		_tmp27_ = _tmp29__length1 == 0;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		_tmp30_ = opt_evemu_events;
		_tmp30__length1 = _vala_array_length (opt_evemu_events);
		_tmp26_ = _tmp30__length1 == 0;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		gboolean _tmp31_;
		gchar** _tmp45_;
		gint _tmp45__length1;
		_tmp31_ = opt_all;
		if (_tmp31_) {
			gchar** _tmp32_;
			gchar** _tmp33_;
			_tmp33_ = _tmp32_ = all_devices ();
			opt_devices = (_vala_array_free (opt_devices, _vala_array_length (opt_devices), (GDestroyNotify) g_free), NULL);
			opt_devices = _tmp33_;
		} else {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp34_ = FALSE;
					_tmp34_ = TRUE;
					while (TRUE) {
						gint _tmp36_;
						gchar** _tmp37_;
						gint _tmp37__length1;
						gchar** _tmp38_;
						gint _tmp38__length1;
						gint _tmp39_;
						gchar** _tmp40_;
						gint _tmp40__length1;
						gint _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						if (!_tmp34_) {
							gint _tmp35_;
							_tmp35_ = i;
							i = _tmp35_ + 1;
						}
						_tmp34_ = FALSE;
						_tmp36_ = i;
						_tmp37_ = opt_devices;
						_tmp37__length1 = _vala_array_length (opt_devices);
						if (!(_tmp36_ < _tmp37__length1)) {
							break;
						}
						_tmp38_ = opt_devices;
						_tmp38__length1 = _vala_array_length (opt_devices);
						_tmp39_ = i;
						_tmp40_ = opt_devices;
						_tmp40__length1 = _vala_array_length (opt_devices);
						_tmp41_ = i;
						_tmp42_ = _tmp40_[_tmp41_];
						_tmp43_ = resolve (_tmp42_);
						_g_free0 (_tmp38_[_tmp39_]);
						_tmp38_[_tmp39_] = _tmp43_;
						_tmp44_ = _tmp38_[_tmp39_];
					}
				}
			}
		}
		_tmp45_ = opt_devices;
		_tmp45__length1 = _vala_array_length (opt_devices);
		dump_devices (_tmp45_, _tmp45__length1);
		result = 0;
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp46_ = g_getenv ("LD_PRELOAD");
	_tmp47_ = g_strdup (_tmp46_);
	preload = _tmp47_;
	_tmp48_ = preload;
	if (_tmp48_ == NULL) {
		gchar* _tmp49_;
		_tmp49_ = g_strdup ("");
		_g_free0 (preload);
		preload = _tmp49_;
	} else {
		const gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = preload;
		_tmp51_ = g_strconcat (_tmp50_, ":", NULL);
		_g_free0 (preload);
		preload = _tmp51_;
	}
	_tmp52_ = preload;
	_tmp53_ = g_strconcat (_tmp52_, "libumockdev-preload.so.0", NULL);
	_tmp54_ = _tmp53_;
	g_setenv ("LD_PRELOAD", _tmp54_, TRUE);
	_g_free0 (_tmp54_);
	_tmp55_ = opt_ioctl;
	if (_tmp55_ != NULL) {
		const gchar* _tmp56_;
		_tmp56_ = opt_ioctl;
		record_ioctl (_tmp56_);
	}
	_tmp57_ = opt_script;
	_tmp57__length1 = _vala_array_length (opt_script);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp57_;
		s_collection_length1 = _tmp57__length1;
		for (s_it = 0; s_it < _tmp57__length1; s_it = s_it + 1) {
			gchar* _tmp58_;
			gchar* s = NULL;
			_tmp58_ = g_strdup (s_collection[s_it]);
			s = _tmp58_;
			{
				const gchar* _tmp59_;
				_tmp59_ = s;
				record_script (_tmp59_, "default");
				_g_free0 (s);
			}
		}
	}
	_tmp60_ = opt_evemu_events;
	_tmp60__length1 = _vala_array_length (opt_evemu_events);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp60_;
		s_collection_length1 = _tmp60__length1;
		for (s_it = 0; s_it < _tmp60__length1; s_it = s_it + 1) {
			gchar* _tmp61_;
			gchar* s = NULL;
			_tmp61_ = g_strdup (s_collection[s_it]);
			s = _tmp61_;
			{
				const gchar* _tmp62_;
				_tmp62_ = s;
				record_script (_tmp62_, "evemu");
				_g_free0 (s);
			}
		}
	}
	_tmp63_ = opt_devices;
	_tmp63__length1 = _vala_array_length (opt_devices);
	_tmp64_ = _tmp63_[0];
	_tmp65_ = opt_devices;
	_tmp65__length1 = _vala_array_length (opt_devices);
	execvp (_tmp64_, _tmp65_);
	_tmp66_ = opt_devices;
	_tmp66__length1 = _vala_array_length (opt_devices);
	_tmp67_ = _tmp66_[0];
	_tmp68_ = errno;
	_tmp69_ = g_strerror (_tmp68_);
	exit_error ("Cannot run program %s: %s", _tmp67_, _tmp69_, NULL);
	result = 0;
	_g_free0 (preload);
	_g_option_context_free0 (oc);
	return result;
}


int main (int argc, char ** argv) {
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



