/***************************************************************************
                                  Ewindow.cpp
                              -------------------

     Begin        : Sat Oct 20 2007 20:20 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the constructor and the methode of the error window

****************************************************************************/

#include <QtGui>

#include "spaceWindow.h"
#include "env.h"

/** \brief Initiate the error window

Create the error window, setup too the action and menu
\param parent The parent of the window
*/
spaceWindowDialog::spaceWindowDialog(QWidget *parent)
    : QDialog(parent)
{
	//setup the interface
	setupUi(this);
	layout()->setSizeConstraint(QLayout::SetFixedSize);
	
	//connect the action
	connect(pushButtonForce, SIGNAL(clicked()), this, SLOT(forceAction()));
	connect(pushButtonCancel, SIGNAL(clicked()), this, SLOT(cancelAction()));
	
	//update the style
	this->UpdateStyle();
}

/** \brief Set the text and value
\param listShouldBeReplace The list what should be remplace, should have 5 item, need replace: %number%, %needed%, %mount%, %freespace%, %required%
*/
void spaceWindowDialog::replaceText(const QStringList& listShouldBeReplace)
{
	if(listShouldBeReplace.size()==5)
	{
		QString textDisplayed=textEditOfInformations->toPlainText();
		textDisplayed=textDisplayed.replace("%number%",listShouldBeReplace.at(0));
		textDisplayed=textDisplayed.replace("%needed%",listShouldBeReplace.at(1));
		textDisplayed=textDisplayed.replace("%mount%",listShouldBeReplace.at(2));
		textDisplayed=textDisplayed.replace("%freespace%",listShouldBeReplace.at(3));
		textDisplayed=textDisplayed.replace("%required%",listShouldBeReplace.at(4));
		textEditOfInformations->setText(textDisplayed);
	}
}

void spaceWindowDialog::forceAction()
{
	emit ActionClicked(SPACE_DIAL_FORCE);
	this->close();
}

void spaceWindowDialog::cancelAction()
{
	emit ActionClicked(SPACE_DIAL_CANCEL);
	this->close();
}

/// \brief Update the style
void spaceWindowDialog::UpdateStyle()
{
	//update style here
	labelMainIcon->setPixmap(loadImagePixmap("big/error.png"));
	pushButtonForce->setIcon(loadImage("reload.png"));
	pushButtonCancel->setIcon(loadImage("cancel.png"));
	this->setWindowIcon(loadImage("error.png"));
}

/// \brief The destructor
spaceWindowDialog::~spaceWindowDialog()
{
}
