/***************************************************************************
				   main.cpp
			      -------------------

     Begin	: Sat Oct 20 2007 20:20 alpha_one_x86
     Project      : Ultracopier
     Email	: ultracopier@first-world.info
     Note	 : See README for copyright and developer
     Target       : Create the main windows and create the entry point

****************************************************************************/

#include "env.h"
#include "var.h"
#include "UIcon.h"
#include "structDef.h"

#include <QSettings>
#include <QTranslator>
#include <QLocale>
#include <QLibraryInfo>
#include <QFile>
#include <QDir>
#include <QFileInfo>
#include <QLocalSocket>
#include <QList>
#include <QFileInfo>
#include <QFileInfoList>

#ifndef Q_OS_WINCE
#include <sys/stat.h>
#endif
#ifdef Q_OS_UNIX
#include <sys/statvfs.h>
#include <unistd.h>
#include <sys/types.h>
#define PATHSOCKET "advanced-copier-"+QString::number(getuid())
#endif

#if defined (Q_OS_WIN32) || defined (Q_OS_WINCE)
#include <windows.h>
#define PATHSOCKET "advanced-copier-"+UltracopierWindowsGetUserName()
#endif

#ifdef Q_CC_MSVC
#include <winbase.h>
#include <winnt.h>
#pragma comment(lib,"Advapi32.lib")
#endif

#ifdef ULTRACOPIER_MODE_KDE4
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kaboutdata.h>
#else
#include <QApplication>
#endif

#ifdef ULTRACOPIER_MODE_WINDOWS
#include "register.h"
#endif

#if (DEBUG_ULTRACOPIER>0)
#include <QMutexLocker>
#include <QMutex>
#include <QTime>
static QMutex	mutex;			///< The mutex for thread safe of the debug fonction
QTime		*theTimeProcess;	///< The time for the debug fonction
QString		theLogPath;		///< Where is located the log file
#endif
#ifdef ULTRACOPIER_MODE_KDE4
KApplication	*app;			///< Pointer on the application
#else
QApplication	*app;			///< Pointer on the application
#endif
QString		*style;			///< Pointer on the style
QSettings	*theSettings;		///< Pointer the settings file
QFile		*theLogFile;		///< Pointer on the log file
QString		htmlFormat;		///< Temp variable for html generating
QString		Stime;			///< The time in string
QTranslator	*translator2;		///< The Translator
QStringList	mountSysPoint;		///< List of mount point of the system
QStringList	pathOfResource;		///< List path for search resources
QList<QIcon>	cacheOfStyleIcons;	///< List of QIcon for cache
QList<QPixmap>	cacheOfPixmaps;		///< List of pixmap for cache
QStringList	ScacheOfStyleIcons;	///< List of string QIcon for cache
QStringList	ScacheOfPixmaps;	///< List of string pixmap for cache
QString		StartParamLang;		///< List of start param lang
UIcon		*thisIcon;		///< Instance of UIcon
bool		dllIsRegistred;		///< Store if dll is registred
QList<translatorLang>	theTranslations;

#ifdef ULTRACOPIER_MODE_KDE4
/// \brief Little description
static const char description[] =
        I18N_NOOP("Advanced copier for KDE");

/// \brief Version
static const char version[] = VERSION;
#endif

void initTheTranslations()
{
	for (int i = 0; i < pathOfResource.size(); ++i) {
		QDir dir(pathOfResource.at(i)+"lang/");
		QFileInfoList list = dir.entryInfoList();
		for (int j=0;j< list.size();++j)
		{
			QFileInfo fileInfo=list.at(j);
			if(fileInfo.isFile() &&  fileInfo.absoluteFilePath().contains(QRegExp("\\.lang$")))
			{
				QSettings lang(fileInfo.absoluteFilePath(),QSettings::IniFormat);
				if(lang.status()==QSettings::NoError)
				{
					if(lang.contains("TranslationFile") && lang.contains("Image") && lang.contains("FullName") && lang.contains("ShortName"))
					{
						if(!QFile::exists(pathOfResource.at(i)+"lang/"+lang.value("Image").toString()))
							DEBUGCONSOLE(50,"initTheTranslations","Image for this lang not found: "+pathOfResource.at(i)+"lang/"+lang.value("Image").toString());
						else
						{
							translatorLang newEntry;
							newEntry.file=		pathOfResource.at(i)+"lang/"+lang.value("TranslationFile").toString();
							newEntry.image=		QIcon(pathOfResource.at(i)+"lang/"+lang.value("Image").toString());
							newEntry.fullName=	lang.value("FullName").toString();
							newEntry.shortName=	lang.value("ShortName").toStringList();
							if(newEntry.file.isEmpty() || newEntry.image.isNull() || newEntry.fullName.isEmpty() || newEntry.shortName.size()<1)
								DEBUGCONSOLE(50,"initTheTranslations","Lang config file found with this name: "+newEntry.fullName);
							else
							{

								theTranslations<<newEntry;
								#if (DEBUG_ULTRACOPIER>0)
								QString tempDebug;
								tempDebug="Lang config file found with this name: "+newEntry.fullName+", suport this flag:";
								for (int k = 0; k < newEntry.shortName.size(); ++k) {
									tempDebug+=' '+newEntry.shortName.at(k);
								}
								DEBUGCONSOLE(90,"initTheTranslations",tempDebug);
								#endif
							}
						}
					}
					else
					{
						DEBUGCONSOLE(50,"initTheTranslations","missing value in the config file");
					}
				}
				else
				{
					DEBUGCONSOLE(50,"initTheTranslations","lang file found but format error: "+fileInfo.absoluteFilePath());
				}
			}
		}
	}
}

bool theTranslationExists(QString lang)
{
	for (int i = 0; i < theTranslations.size(); ++i) {
		for (int j = 0; j < theTranslations.at(i).shortName.size(); ++j) {
			if(theTranslations.at(i).shortName.at(j).contains('*'))
			{
				QString temp_string=theTranslations.at(i).shortName.at(j);
				temp_string.replace("*","[a-zA-Z]{2}");
				if(lang.contains(QRegExp("^"+temp_string+"$")))
					return true;
			}
			else
			{
				if(theTranslations.at(i).shortName.at(j)==lang)
					return true;
			}
		}
	}
	return false;
}

QList<translatorLang> getTheTranslations()
{
	return theTranslations;
}

translatorLang getTheTranslation(QString lang)
{
	for (int i = 0; i < theTranslations.size(); ++i) {
		for (int j = 0; j < theTranslations.at(i).shortName.size(); ++j) {
			if(theTranslations.at(i).shortName.at(j)==lang)
				return theTranslations.at(i);
		}
	}
	translatorLang newEntry;
	return newEntry;
}

//return the settings resources
QSettings * getSettingsRes()
{
	return theSettings;
}

/// \brief Reset style as default
void resetStyle()
{
}

//return the location of the settings of the application
QString giveWritablePath(const QString& name)
{
	QString theFile;
	#ifdef Q_OS_WIN32
		#ifdef ULTRACOPIER_VERSION_PORTABLE
			#ifdef ULTRACOPIER_VERSION_PORTABLEAPPS
				QDir dir(QApplication::applicationDirPath());
				dir.cdUp();
				dir.cdUp();
				theFile=dir.absolutePath()+"\\Data\\"+name;
			#else
				theFile=QApplication::applicationDirPath()+'\\'+name;
			#endif
		#else
			DEBUGCONSOLE(30,"giveWritablePath","QFSFileEngine::homePath(): "+QFSFileEngine::homePath());
			theFile=QFSFileEngine::homePath()+"\\ultracopier\\"+name;
		#endif
	#else
		QString homePath=QFSFileEngine::homePath();
		if(homePath!="/")
		{
			#ifdef ULTRACOPIER_MODE_KDE4
				theFile=homePath+"/.kde/share/apps/ultracopier/"+name;
			#else
				theFile=homePath+"/.ultracopier/"+name;
			#endif
		}
		else
			return QApplication::applicationDirPath()+'/'+name;
	#endif
	QString folderOfFile=QFileInfo(theFile).absolutePath()+'/';
	QDir theDir(folderOfFile);
	if(!theDir.exists())
	{
		if(!theDir.mkpath(folderOfFile))
		{
			DEBUGCONSOLE(10,"giveWritablePath","Unable to create this dir: "+folderOfFile);
		}
	}
	return theFile;
}


#if (DEBUG_ULTRACOPIER>0)
/** \brief If error occured at socket
\param theErrorDefine The error define */
void mainErrorUI(QLocalSocket::LocalSocketError theErrorDefine)
{
	DEBUGCONSOLE(70,"mainErrorUI","Value:"+theErrorDefine);
}
#endif

//give the external name with full path or return the internal name
QString giveResourcePath(const QString& url)
{
	QString tempUrl;
	for (int i = 0; i < pathOfResource.size(); ++i) {
		tempUrl=pathOfResource.at(i)+url;
		if(QFile(tempUrl).exists())
			return tempUrl;
	}
	return ":/"+url;
}

/** \brief Return list of ressource path
\return the list of path of resources */
QStringList getPathOfResource()
{
	return pathOfResource;
}

//return the file in the style if exists else return the internal path in the default style
QString loadFilePathIntheStyle(const QString& path)
{
	QString tempUrl;
	for (int i = 0; i < pathOfResource.size(); ++i) {
		tempUrl=pathOfResource.at(i)+"styles/"+*style+'/'+path;
		if(QFile(tempUrl).exists())
			return tempUrl;
	}
	return QString(":/styles/")+ULTRACOPIER_DEFAULT_STYLE+'/'+path;
}

//load the style in the setting file
void loadStyle()
{
	*style=ULTRACOPIER_DEFAULT_STYLE;
	theSettings->beginGroup("Interface");
	//load the style new
	if(theSettings->contains("comboBoxStyle"))
	{
		for (int i = 0; i < pathOfResource.size(); ++i) {
			QString stylePath=pathOfResource.at(i)+"styles/"+theSettings->value("comboBoxStyle").toString()+'/';
			if(QFileInfo(stylePath).isDir())
			{
				DEBUGCONSOLE(50,"loadStyle","Found: "+stylePath);
				*style=theSettings->value("comboBoxStyle").toString();
			}
		}
	}
	theSettings->endGroup();
	QFile theStyleFile(loadFilePathIntheStyle("style.css"));
	theStyleFile.open(QIODevice::ReadOnly);
	QByteArray theData(theStyleFile.readAll());
	QString theStringStyle(theData);
	app->setStyleSheet(theStringStyle.replace(QRegExp("url\\(([\"']{0,1})([0-9a-zA-Z\\-_])"),"url(\\1"+QApplication::applicationDirPath()+"/styles/"+*style+"/\\2"));
	theStyleFile.close();
}

//load bool from setting file
bool loadSetting(const QString& group,const QString& key,bool defaultValue)
{
	bool returnValue;
	theSettings->beginGroup(group);
	if(theSettings->contains(key))
		returnValue=theSettings->value(key).toBool();
	else
		returnValue=defaultValue;
	theSettings->endGroup();
	return returnValue;
}

/// \brief Reset QIcon cache
void resetQIconCache()
{
	cacheOfStyleIcons.clear();
	cacheOfPixmaps.clear();
	ScacheOfStyleIcons.clear();
	ScacheOfPixmaps.clear();
}

//load int from setting file
int loadSetting(const QString& group,const QString& key,int defaultValue)
{
	int returnValue;
	theSettings->beginGroup(group);
	if(theSettings->contains(key))
		returnValue=theSettings->value(key).toInt();
	else
		returnValue=defaultValue;
	theSettings->endGroup();
	return returnValue;
}

//load string from setting file
QString loadSetting(const QString& group,const QString& key,const QString& defaultValue)
{
	QString returnValue;
	theSettings->beginGroup(group);
	if(theSettings->contains(key))
		returnValue=theSettings->value(key).toString();
	else
		returnValue=defaultValue;
	theSettings->endGroup();
	return returnValue;
}

#if (DEBUG_ULTRACOPIER>0)
/** \brief Convert a boolean to readable string
\return Return "true" if value is at true else return "false"
*/
QString boolToQString(bool value)
{
	if(value)
	    return "true";
	else
	    return "false";
}
#endif

//Load a style icon
QIcon loadImage(const QString& fileName)
{
	for (int i = 0; i < cacheOfStyleIcons.size(); ++i) {
		if(ScacheOfStyleIcons.at(i)==fileName)
			return cacheOfStyleIcons.at(i);
	}
	QString fullPath=loadFilePathIntheStyle(fileName);
	if(!QFile::exists(fullPath))
	{
		DEBUGCONSOLE(10,"loadImage",fullPath+" not found.");
	}
	else
	{
		QIcon theReturnedImage(fullPath);
		if(theReturnedImage.isNull())
		{
			DEBUGCONSOLE(10,"loadImage",fullPath+" can't be opened.");
		}
		else
		{
			cacheOfStyleIcons.append(theReturnedImage);
			ScacheOfStyleIcons.append(fileName);
		}
		return theReturnedImage;
	}
	return QIcon();
}

//Load a style icon as a pixmap
QPixmap loadImagePixmap(const QString& fileName)
{
	for (int i = 0; i < cacheOfPixmaps.size(); ++i) {
		if(ScacheOfPixmaps.at(i)==fileName)
			return cacheOfPixmaps.at(i);
	}
	QString fullPath=loadFilePathIntheStyle(fileName);
	if(!QFile::exists(fullPath))
	{
		DEBUGCONSOLE(10,"loadImagePixmap",fileName+" not found.");
	}
	else
	{
		QPixmap theReturnedImage(fullPath);
		if(theReturnedImage.isNull())
		{
			DEBUGCONSOLE(10,"loadImagePixmap",fileName+" can't be opened.");
		}
		else
		{
			cacheOfPixmaps.append(theReturnedImage);
			ScacheOfPixmaps.append(fileName);
		}
		return theReturnedImage;
	}
	return QPixmap();
}

//Return if ultracopier catch the copy's system
bool getSystemCopyCatched()
{
	#ifdef ULTRACOPIER_MODE_WINDOWS
	return dllIsRegistred;
	#else
	DEBUGCONSOLE(30,"getSystemCopyCatched","Not writen");
	return false;
	#endif
}

#ifdef ULTRACOPIER_MODE_WINDOWS
/* \brief Write reg key
\param hKey A handle to an open registry key
\param lpSubKey The name of a subkey that this function opens or creates
\param KeyReg The entry name
\param KeyValue The entry value
\param lenght The lenght
\return true if succes
*/
bool newRegQuery(HKEY hKey,LPCTSTR lpSubKey,LPCTSTR KeyReg,const QString& KeyValue)
{
	WCHAR temp[255];
	int l=KeyValue.toWCharArray(temp)*2;
	LONG returnVar;
	HKEY ultracopier_regkey;
	RegCreateKeyEx(hKey, lpSubKey, 0, 0, REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS, 0, &ultracopier_regkey, 0);
	returnVar=RegSetValueEx(ultracopier_regkey, KeyReg, 0, REG_SZ, (BYTE*)temp, l);
	RegCloseKey(ultracopier_regkey);
	if(returnVar==ERROR_SUCCESS)
		return true;
	else
	{
		DEBUGCONSOLE(10,"newRegQuery","error num: "+QString::number(returnVar));
		return false;
	}
}
#endif

/* Set the default copier
\param theOrder True if ultracopier should be the default copier
\return Return empty QString if no error append */
QString setSystemCopyCatched(bool theOrder, bool quiet)
{
	DEBUGCONSOLE(90,"setSystemCopyCatched","start");
	#ifdef ULTRACOPIER_MODE_WINDOWS
	QString errorString;
	QString basePath=QDir::convertSeparators(QApplication::applicationDirPath())+QDir::separator();
	#ifdef ULTRACOPIER_VERSION_PORTABLEAPPS
	basePath+=QString("App")+QDir::separator()+QString("CatchCopy")+QDir::separator();
	DEBUGCONSOLE(90,"setSystemCopyCatched","append basePath: "+QString("App")+QDir::separator()+QString("CatchCopy")+QDir::separator());
	#endif
	DEBUGCONSOLE(90,"setSystemCopyCatched","basePath: "+basePath);
	bool returnCode;
	#if defined (ULTRACOPIER_VERSION_PORTABLE) || defined (_WIN64)
		DEBUGCONSOLE(90,"setSystemCopyCatched","64Bits dll is requiered");
		#if defined (ULTRACOPIER_VERSION_PORTABLE)
			DEBUGCONSOLE(90,"setSystemCopyCatched","auto dectection if need, in version portable");
			bool dll64BitsIsRequiered=QDir(QString(getenv("windir"))+QDir::separator()+"SysWOW64").exists();
		#else
			DEBUGCONSOLE(90,"setSystemCopyCatched","depand of catchcopy64.dll forced, because it version is full 64Bits, then it will lunch on 64Bits OS");
			bool dll64BitsIsRequiered=true;
		#endif
	#else
		DEBUGCONSOLE(90,"setSystemCopyCatched","64Bits dll not requiered");
		bool dll64BitsIsRequiered=false;
	#endif
	DEBUGCONSOLE(90,"setSystemCopyCatched","dll64BitsIsRequiered: "+QString::number(dll64BitsIsRequiered));
	if(!QFile::exists(basePath+"catchcopy32.dll") || (dll64BitsIsRequiered && !QFile::exists(basePath+"catchcopy64.dll")))
	{
		if(dll64BitsIsRequiered)
			return "The file catchcopy32.dll or catchcopy64.dll is not found. Unable to catch the copy and paste from the system";
		else
			return "The file catchcopy32.dll is not found. Unable to catch the copy and paste from the system";
	}
	else
	{
		if(theOrder)
		{
			returnCode=RegisterShellExtDll(basePath+"catchcopy32.dll",true,quiet);
			if(returnCode)
			{
				//try load 64Bits version of catchcopy
				if(dll64BitsIsRequiered)
				{
					returnCode=RegisterShellExtDll(basePath+"catchcopy64.dll",true,quiet);
					if(!returnCode)
					{
						RegisterShellExtDll(basePath+"catchcopy32.dll",false,quiet);
						RegisterShellExtDll(basePath+"catchcopy64.dll",false,quiet);
					}
				}
			}
			else
				RegisterShellExtDll(basePath+"catchcopy32.dll",false,quiet);
		}
		else
		{
			RegisterShellExtDll(basePath+"catchcopy32.dll",false,quiet);
			if(dll64BitsIsRequiered)
				RegisterShellExtDll(basePath+"catchcopy64.dll",false,quiet);
			returnCode=true;
		}
	}
	if(!returnCode && theOrder)
		errorString="Error during inject dll";
	dllIsRegistred=(returnCode && theOrder);

	return errorString;
	#else
	theOrder=theOrder;
	quiet=quiet;
	return "Not implemented for this system";
	#endif
}

/** \brief Get mount point
\param fileName The full path
\return Return getMountPoint, or empty string if failed */
QString getMountPoint(const QString& fileName)
{
	DEBUGCONSOLE(90,"getMountPoint","start");
	//load windows drive
	#ifdef Q_OS_WIN32
	QFileInfoList temp=QDir::drives();
	for (int i = 0; i < temp.size(); ++i) {
		mountSysPoint<<temp.at(i).filePath();
	}
	#endif
	//check if local file
	for (int i = 0; i < mountSysPoint.size(); ++i) {
		if(fileName.startsWith(mountSysPoint.at(i)))
			return mountSysPoint.at(i);
	}
	//check if samba share on windows
	#ifdef Q_OS_WIN32
	if(fileName.startsWith("//"))
		return fileName.section(QRegExp("//[^/]+/[^/]+/"),0);
	#endif
	//check if protocol
	if(fileName.indexOf(QRegExp("[a-zA-Z0-9_\\-+]+://([^:@]+(:[^:@]+)?@)?[a-zA-Z0-9.]+/"))==0)
		return fileName.section(QRegExp("[a-zA-Z0-9_\\-+]+://([^:@]+(:[^:@]+)?@)?[a-zA-Z0-9.]+/"),0);
	
	return "";
}


/** \brief Get on with mount point type is located the file
\param fileName The full path
\return Return getMountPoint, or error type */
QString getMountType(const QString& fileName)
{
	if(fileName!="")
	{
		//check if local file
		for (int i = 0; i < mountSysPoint.size(); ++i) {
			if(fileName.startsWith(mountSysPoint.at(i)))
				return "na";
		}
		//check if samba share on windows
		#ifdef Q_OS_WIN32
		if(fileName.startsWith("//"))
			return "protocol";
		#endif
		//check if protocol
		if(fileName.indexOf(QRegExp("[a-zA-Z0-9_\\-+]+://([^:@]+(:[^:@]+)?@)?[a-zA-Z0-9.]+/"))==0)
			return "protocol";
		
		return "na";
	}
	else
		return "na";
}

/** \brief Load new translator
\param lang The lang of load
\return Return true if succes */
bool reloadTheTranslator(const QString& lang)
{
	DEBUGCONSOLE(90,"reloadTheTranslator","lang: "+lang);
	app->removeTranslator(translator2);
	QString Path=QDir::convertSeparators(QApplication::applicationDirPath())+"/lang/"+lang.toLower().left(2);
	if(QFile::exists(Path))
		translator2->load(Path);
	else
		translator2->load(":/lang/"+lang.toLower().left(2));
	app->installTranslator(translator2);
	return true;
}

#ifdef Q_CC_MSVC
void UnixTimeToFileTime(time_t t, LPFILETIME pft)
{
	// Note that LONGLONG is a 64-bit value
	LONGLONG ll;

	ll = Int32x32To64(t, 10000000) + 116444736000000000;
	pft->dwLowDateTime = (DWORD)ll;
	pft->dwHighDateTime = ll >> 32;
}
#endif

/** \brief change file time with system time
\param file File name
\param actime Access time
\param ctime Creation time
\param modtime Modification time
\return Return true if succes */
bool changeFileDateTime(QString const& file,time_t ctime,time_t actime,time_t modtime)
{
	#ifdef Q_CC_GNU
	//this function avalaible on unix and mingw
	utimbuf butime;
	butime.actime=actime;
	butime.modtime=modtime;
	ctime=modtime;
	return utime(file.toLatin1().data(),&butime)==0;
	#else
	#ifdef Q_CC_MSVC
	wchar_t tempChar[255];
	file.toWCharArray(tempChar);
	HANDLE hfl=CreateFile(tempChar, GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, 0, 0);
	if(hfl == INVALID_HANDLE_VALUE)
		return false;
	FILETIME lpCreationTime;
	FILETIME lpLastAccessTime;
	FILETIME lpLastWriteTime;
	UnixTimeToFileTime(ctime, &lpCreationTime);
	UnixTimeToFileTime(actime, &lpLastAccessTime);
	UnixTimeToFileTime(modtime, &lpLastWriteTime);
	bool setTimeResult=SetFileTime(hfl,
	&lpCreationTime,
	&lpLastAccessTime,
	&lpLastWriteTime);
	CloseHandle(hfl);
	DEBUGCONSOLE(70,"changeFileDateTime","error at set date for the file "+file+": "+QString::number(GetLastError()));
	return setTimeResult;
	#else
	return false;
	#endif
	#endif
}

/** \brief change file time with Qt File Information time
\param file File name on wich the size need be edited
\param file2 Model file time
\return Return true if succes */
bool changeFileDateTime(QString const& file,QString const& file2)
{
	QFileInfo const& fileInfo(file2);
	return changeFileDateTime(file
		,fileInfo.created().toTime_t()
		,fileInfo.lastRead().toTime_t()
		,fileInfo.lastModified().toTime_t());
}

/** \brief Return the free space
\note Check space only if local file
\param mountPoint The mount point who check the free space
\return Return the free space on the drive */
qint64 freeSpaceDrive(const QString& mountPoint)
{
	QString type=getMountType(mountPoint);
	if(type=="protocol")
	{
		DEBUGCONSOLE(30,"freeSpaceDrive","File or folder is not valid of protocol");
		return -1;
	}
	#ifdef Q_OS_UNIX
	struct statvfs fiData;
	//Lets loopyloop through the argvs
	if((statvfs(mountPoint.toAscii().data(),&fiData)) < 0 )
	{
		DEBUGCONSOLE(10,"freeSpaceDrive","Unable stat this mount point: "+mountPoint);
		return -1;
	}
	else
	{
		DEBUGCONSOLE(70,"freeSpaceDrive","Free space on: "+mountPoint+" = "+QString::number(fiData.f_bfree));
		return fiData.f_bfree;
	}
	#else
	ULARGE_INTEGER uFreeBytesAvailable;
	ULARGE_INTEGER uTotalNumberOfBytes;
	ULARGE_INTEGER uTotalNumberOfFreeBytes;
	WCHAR lpDirectoryName[255];
	int tempLen;
	lpDirectoryName[0]='\0';
	tempLen=mountPoint.toLower().toWCharArray(lpDirectoryName);
	lpDirectoryName[mountPoint.size()]='\0';
	if(GetDiskFreeSpaceEx(lpDirectoryName,&uFreeBytesAvailable, &uTotalNumberOfBytes, &uTotalNumberOfFreeBytes)==0)
	{
		DEBUGCONSOLE(10,"freeSpaceDrive","Unable stat this mount point: "+QString().fromWCharArray(lpDirectoryName)+", for len: "+QString::number(tempLen)+", error number: "+QString::number(GetLastError()));
		return -1;
	}
	else
	{
		/*DEBUGCONSOLE(70,"freeSpaceDrive","lpFreeBytesAvailable: "+QString::number((qint64)lpFreeBytesAvailable->QuadPart));
		DEBUGCONSOLE(70,"freeSpaceDrive","lpTotalNumberOfBytes: "+QString::number((qint64)lpTotalNumberOfBytes->QuadPart));
		DEBUGCONSOLE(70,"freeSpaceDrive","lpTotalNumberOfFreeBytes: "+QString::number((qint64)lpTotalNumberOfFreeBytes->QuadPart));*/
		//lpFreeBytesAvailable->QuadPart=0;
		return uFreeBytesAvailable.QuadPart;
	}
	return -1;
	#endif
}

/** \brief Return the optimal block size
\note Check space only if local file
\param mountPoint The mount point to detect the optimal block size
\return Return the optimal block size or -1 if failed */
int optimalBlockSize(const QString& mountPoint)
{
	QString type=getMountType(mountPoint);
	if(type=="na" || type=="protocol")
	{
		DEBUGCONSOLE(10,"optimalBlockSize","File or folder is not valid: "+type);
		return -1;
	}
	#ifdef Q_OS_UNIX
	struct stat sts;
	int errno;
	errno=stat(mountPoint.toAscii().data(),&sts);
	if(errno!=0)
	{
		DEBUGCONSOLE(10,"optimalBlockSize","Error number: "+QString::number(errno));
		return -1;
	}
	DEBUGCONSOLE(90,"optimalBlockSize","Block size: "+QString::number(sts.st_blksize));
	return sts.st_blksize;
	#else
	return -1;
	#endif
}

/// \brief Entry point program
int main(int argc, char *argv[])
{
	dllIsRegistred=false;
	theLogFile=NULL;
	thisIcon=NULL;
	//for the debug for show the time elapsed
	#if (DEBUG_ULTRACOPIER>0)
	theTimeProcess = new QTime();
	theTimeProcess->start();
	#endif
	
	#ifdef ULTRACOPIER_MODE_KDE4
	KAboutData aboutData( "ultracopier", 0, ki18n("Ultracopier"),
		VERSION, ki18n("Copier for KDE/Qt"), KAboutData::License_GPL,
		ki18n("(c) 2007-2009, BRULE Herman"), KLocalizedString(),
		"http://ultracopier.first-world.info/");
	aboutData.addAuthor(ki18n("BRULE Herman"), ki18n("Main developper, author"), "ultracopier@first-world.info");
	//aboutData.addCredit(ki18n(""),ki18n("Coding help"), "kde@.org");

	KCmdLineArgs::init( argc, argv, &aboutData );

	KCmdLineOptions options;
	KCmdLineArgs::addCmdLineOptions( options );
	app = new KApplication();
	#else
	app = new QApplication(argc, argv);
	app->setApplicationVersion(VERSION);
	#endif
	
	QLocalSocket *localSocket = NULL;
	#if (DEBUG_ULTRACOPIER>0)
		localSocket = new QLocalSocket();
		localSocket->connectToServer(PATHSOCKET);
		if(localSocket->waitForConnected())
		{
			//if other session is runnning log should be with the pid
			theLogPath=giveWritablePath("log/stdout-"+QString::number(QCoreApplication::applicationPid())+".log.html");
		}
		else
		{
			//if no other session is runnning
			QFile::rename(giveWritablePath("log/stdout.log.html"),giveWritablePath("log/stdout.log.html.crash"));
			theLogPath=giveWritablePath("log/stdout.log.html");
		}
		theLogFile = new QFile(theLogPath);
		if(theLogFile->open(QIODevice::WriteOnly|QIODevice::Truncate|QIODevice::Unbuffered))
			theLogFile->write(QString("<pre>").toLocal8Bit());
		else
			theLogFile = NULL;

		//////////////////// Version define ///////////////////////
		#ifdef _MSC_FULL_VER
			DEBUGCONSOLE(30,"Infos",QString("Msvc version: ")+QString::number(_MSC_FULL_VER));
		#endif
		#ifdef KDE_VERSION
			DEBUGCONSOLE(30,"Infos","KDE "+QString::number(KDE_VERSION)+" version");
		#endif
		#ifdef QT_VERSION_STR
			DEBUGCONSOLE(30,"Infos",QString("Qt ")+QT_VERSION_STR+" version");
		#endif
		#ifdef __GNUC__
		#ifdef __GNUC_MINOR__
		#ifdef __GNUC_PATCHLEVEL__
		DEBUGCONSOLE(30,"Infos","Gcc version: "+QString::number(__GNUC__)+'.'+QString::number(__GNUC_MINOR__)+'.'+QString::number(__GNUC_PATCHLEVEL__));
		#endif
		#endif
		#endif

		//////////////////// Os define ///////////////////////
		#ifdef ULTRACOPIER_MODE_WINDOWS
			DEBUGCONSOLE(30,"Infos","Windows version");
		#endif
		#ifdef ULTRACOPIER_MODE_KDE4
			DEBUGCONSOLE(30,"Infos","KDE4 version");
		#endif
		#ifdef ULTRACOPIER_VERSION_PORTABLE
			DEBUGCONSOLE(30,"Infos","Portable edition");
		#endif
		#ifdef ULTRACOPIER_VERSION_PORTABLEAPPS
			DEBUGCONSOLE(30,"Infos","Portable application special portable edition");
		#endif

		////////////////// Ultracopier var ///////////////////
		DEBUGCONSOLE(30,"Infos","MAXWRITETHREAD: " +		QString::number(MAXWRITETHREAD));
		DEBUGCONSOLE(30,"Infos","COMM_PROTOCOL_VERSION: " +	QString::number(COMM_PROTOCOL_VERSION));
		DEBUGCONSOLE(30,"Infos","UPDATEINTERVAL: " +		QString::number(UPDATEINTERVAL));
		DEBUGCONSOLE(30,"Infos","LISTBLOCKSIZE: " +		QString::number(LISTBLOCKSIZE));
		DEBUGCONSOLE(30,"Infos","MINTIMERINTERVAL: " +		QString::number(MINTIMERINTERVAL));
		DEBUGCONSOLE(30,"Infos","MAXTIMERINTERVAL: " +		QString::number(MAXTIMERINTERVAL));
		DEBUGCONSOLE(30,"Infos","NUMSEMSPEEDMANAGEMENT: " +	QString::number(NUMSEMSPEEDMANAGEMENT));

		//////////////////// Qt define ///////////////////////
		#ifdef Q_OS_MAC
			DEBUGCONSOLE(30,"Infos","Q_OS_MAC defined");
		#endif
		#ifdef Q_OS_WIN32
			DEBUGCONSOLE(30,"Infos","Q_OS_WIN32 defined");
		#endif
		#ifdef Q_OS_LINUX
			DEBUGCONSOLE(30,"Infos","Q_OS_LINUX defined");
		#endif

		/////////////////// Msvc define //////////////////////
		#ifdef _M_X64
			DEBUGCONSOLE(30,"Infos","Msvc: x64 processors");
		#endif
		#ifdef _WIN64
			DEBUGCONSOLE(30,"Infos","Msvc: applications for Win64");
		#endif
		#ifdef _M_IX86_FP
			DEBUGCONSOLE(30,"Infos",QString("Msvc arch: ")+QString::number(_M_IX86_FP));
		#endif

		/////////////////// Other infos //////////////////////
		DEBUGCONSOLE(30,"Infos","Pid: "+QString::number(QCoreApplication::applicationPid()));
		DEBUGCONSOLE(30,"Infos","The log file is here: "+theLogPath);
		DEBUGCONSOLE(30,"Infos","Version: "+QString(VERSION));
		DEBUGCONSOLE(30,"Infos","Build date: "+QString(__DATE__));
	#endif
	
	QStringList argumentsUltracopier=QApplication::arguments();
	argumentsUltracopier.removeFirst();
	
	if(localSocket==NULL)
	{
		localSocket = new QLocalSocket();
		localSocket->connectToServer(PATHSOCKET);
	}
	if(localSocket->waitForConnected())
	{
		DEBUGCONSOLE(30,"main","connection succes, number arguments given: "+QString::number(argumentsUltracopier.size()));
		DEBUGCONSOLE(30,"main","number of argument: "+QString::number(argumentsUltracopier.size()));
		for (int i = 0; i < argumentsUltracopier.size(); ++i) {
			if(getMountType(argumentsUltracopier.at(i))!="protocol" && i!=0)
				argumentsUltracopier[i]=QFileInfo(argumentsUltracopier.at(i)).absoluteFilePath();
			DEBUGCONSOLE(30,"main","argument["+QString::number(i)+"]: "+argumentsUltracopier.at(i));
		}
		if(argumentsUltracopier.size()<=1)
		{
			argumentsUltracopier=(QStringList() << "Running");
			DEBUGCONSOLE(50,"main","no arguments given");
		}
		QByteArray block;
		QDataStream out(&block, QIODevice::WriteOnly);
		out.setVersion(QDataStream::Qt_4_4);
		//for total size
		out << quint32(0);
		//for copy id, here 0 because it's useless, because the application is directly closed without wait the return
		out << quint32(0);
		//send the protocol version used
		out << quint32(COMM_PROTOCOL_VERSION);
		//send the application name for the client (here ultracopier)
		out << QString("Ultracopier ")+VERSION;
		//send the arguments
		out << argumentsUltracopier;
		out.device()->seek(0);
		out << quint32(block.size());
		#if (DEBUG_ULTRACOPIER>0)
		DEBUGCONSOLE(90,"main","argumentsUltracopier, number of argument: "+QString::number(argumentsUltracopier.size()));
		for (int i = 0; i < argumentsUltracopier.size(); ++i) {
			DEBUGCONSOLE(90,"main","argumentsUltracopier, argument["+QString::number(i)+"]: "+argumentsUltracopier.at(i));
		}
		#endif
		do
		{
			QByteArray blockToSend;
			int byteWriten;
			blockToSend=block.left(32*1024);//32KB
			block.remove(0,blockToSend.size());
			byteWriten = localSocket->write(blockToSend);
			DEBUGCONSOLE(70,"main","blockToSend: "+QString(blockToSend.toHex()));
			DEBUGCONSOLE(70,"main","byteWriten: "+QString::number(byteWriten));
			#if (DEBUG_ULTRACOPIER>0)
			if(!localSocket->isValid())
				DEBUGCONSOLE(10,"main","localSocket is not valid!");
			if(localSocket->errorString()!="Unknown error" && localSocket->errorString()!="")
				DEBUGCONSOLE(10,"main","localSocket->errorString(): "+localSocket->errorString());
			#endif
			if(localSocket->waitForBytesWritten(5000))
			{
				DEBUGCONSOLE(90,"main","localSocket->waitForBytesWritten()==true");
			}
			else
			{
				QMessageBox::critical(NULL,"Alert","No arguments send because time out of 5s detected!");
				DEBUGCONSOLE(10,"main","localSocket->waitForBytesWritten()==false");
			}
			DEBUGCONSOLE(30,"main","size sending: "+QString::number(blockToSend.size()));
		}
		while(block.size());
		
		DEBUGCONSOLE(70,"main","localSocket disconnect From Server");
		localSocket->disconnectFromServer();
		localSocket->deleteLater();
		return 0;
	}
	else
	{
		DEBUGCONSOLE(90,"main","connection failed, continu...");
		localSocket->deleteLater();
	}
	
	QCoreApplication::addLibraryPath(QCoreApplication::applicationDirPath());
	#ifdef ULTRACOPIER_VERSION_PORTABLE
		#ifdef ULTRACOPIER_VERSION_PORTABLEAPPS
			theSettings = new QSettings("../../Data/settings.conf",QSettings::IniFormat);
		#else
			theSettings = new QSettings(QCoreApplication::applicationDirPath()+QDir::separator()+"settings.conf",QSettings::IniFormat);
		#endif
	#else
		theSettings = new QSettings("Ultracopier","Ultracopier");
	#endif
	#if (DEBUG_ULTRACOPIER>0)
		DEBUGCONSOLE(90,"main","number of argument: "+QString::number(argumentsUltracopier.size()));
		for (int i = 0; i < argumentsUltracopier.size(); ++i) {
			DEBUGCONSOLE(90,"main","argument["+QString::number(i)+"]: "+argumentsUltracopier.at(i));
		}
	#endif
	
	//search where is located the application
	#ifdef Q_OS_MAC
        QDir binaryResourcesPath(QApplication::applicationDirPath()+QDir::separator());
        binaryResourcesPath.cdUp();
 	pathOfResource<<QDir::convertSeparators(binaryResourcesPath.absolutePath())+QDir::separator()+"Resources"+QDir::separator();
	#else
	pathOfResource<<QApplication::applicationDirPath()+QDir::separator();
	#endif
	//search in /usr/share/ultracopier/ for unix
	#ifdef Q_OS_LINUX
	pathOfResource<<"/usr/share/ultracopier/";
	#endif
	//search in writable space if not registred
	if(pathOfResource.indexOf(giveWritablePath())==-1)
		pathOfResource<<giveWritablePath();
	//search in internal space
	pathOfResource<<":/";
	
	#if (DEBUG_ULTRACOPIER>0)
	DEBUGCONSOLE(90,"main","number of argument of pathOfResource: "+QString::number(pathOfResource.size()));
	for (int i = 0; i < pathOfResource.size(); ++i) {
		DEBUGCONSOLE(30,"main","argument["+QString::number(i)+"]: "+pathOfResource.at(i));
	}
	#endif

	initTheTranslations();
	
	style = new QString("");
	//for stay on system tray icon
	app->setQuitOnLastWindowClosed(false);
	app->setApplicationName("ultracopier");
	QCoreApplication::addLibraryPath(QCoreApplication::applicationDirPath());
	
	//load KDE style if found
	QStringList environementVar=QProcess::systemEnvironment();
	for (int i = 0; i < environementVar.size(); ++i) {
		QString tempString=environementVar.at(i);
		//if kde directorie found
		if(tempString.startsWith("KDEDIR="))
		{
			DEBUGCONSOLE(90,"main","environementVar["+QString::number(i)+"]: "+tempString);
			tempString=tempString.right(tempString.size()-7);
			DEBUGCONSOLE(70,"main","KDE dir: "+tempString);
		}
	}
	
	DEBUGCONSOLE(90,"main","start");
	//local current system language
	QString locale = QLocale::system().name();
	
	//custom dialog
	translator2 = new QTranslator();
	theSettings->beginGroup("Interface");
	if(theSettings->status()==QSettings::NoError)
	{
		//language translator
		if(!theSettings->contains("checkBoxLang") || theSettings->value("checkBoxLang").toBool())
		{
			DEBUGCONSOLE(70,"main","QLocale::system().name(): "+QLocale::system().name());
			DEBUGCONSOLE(70,"main","QLocale::languageToString(QLocale::system().language()): "+QLocale::languageToString(QLocale::system().language()));
			StartParamLang=QLocale::languageToString(QLocale::system().language());
			if(!theTranslationExists(StartParamLang))
			{
				StartParamLang=QLocale::system().name();
				if(!theTranslationExists(StartParamLang))
				{
					DEBUGCONSOLE(70,"main","Autodetection of the language failed");
					StartParamLang="en";
				}
			}
		}
		else
		{
			if(theSettings->contains("comboBoxLang"))
			{
				StartParamLang=theSettings->value("comboBoxLang").toString();
				if(!theTranslationExists(StartParamLang))
				{
					DEBUGCONSOLE(70,"main","Language loaded is wrong");
					StartParamLang="en";
				}
			}
			else
			{
				DEBUGCONSOLE(70,"main","No language loaded");
				StartParamLang="en";
			}
		}
	}
	else
		StartParamLang="en";

	translatorLang newLang=getTheTranslation(StartParamLang);
	if(newLang.fullName!="English")
	{
		translator2->load(newLang.file);
		DEBUGCONSOLE(90,"main","translating file: "+newLang.file);
		DEBUGCONSOLE(90,"main","translating lang: "+newLang.fullName);
	}

	theSettings->endGroup();
	app->installTranslator(translator2);

	//custom style
	loadStyle();

	//dialog system
	QTranslator translator;
	translator.load(QString("qt_")+locale, QLibraryInfo::location(QLibraryInfo::TranslationsPath));
	app->installTranslator(&translator);

	DEBUGCONSOLE(90,"main","path: "+app->applicationDirPath());
	//create the systray icon
	thisIcon = new UIcon();
	thisIcon->saveApp(app);

	if(argumentsUltracopier.size()>1)
		thisIcon->dispatchParam(argumentsUltracopier);
	#if (DEBUG_ULTRACOPIER>0)
	else
		DEBUGCONSOLE(90,"main","argumentsUltracopier.size()<1");
	#endif

        int returnValue=0;
	if(thisIcon!=NULL)
		if(thisIcon->is_listen())
			returnValue=app->exec();
	if(theLogFile!=NULL)
	{
		theLogFile->write(QString("</pre>").toLocal8Bit());
		theLogFile->close();
	}

	#if (DEBUG_ULTRACOPIER>0)
	QFile newFile(giveWritablePath("log/stdout.log.html"));
	QFile oldFile(giveWritablePath("log/stdout.old.html"));
	if(oldFile.exists())
	{
		if(!oldFile.remove())
		{
			DEBUGCONSOLE(90,"main","Remove the old file: "+oldFile.errorString());
			newFile.remove();
		}
	}
	if(!newFile.rename(giveWritablePath("log/stdout.old.html")))
	{
		DEBUGCONSOLE(90,"main","Move the new file: "+newFile.errorString());
	}
	QFile::remove(giveWritablePath("log/stdout.log.html"));
	#endif
	return returnValue;
}

#if (DEBUG_ULTRACOPIER>0)
/** \brief Fill the string by a char
\param theText the text what sould be copied
\param number How many theText is copied
\return Return the string result
*/
QString debug_multiple_QString(const QString& theText,int number)
{
	QString result;
	int i=0;
	while(i<number)
	{
		result+=theText;
		i++;
	}
	return result;
}

QString htmlEntities(QString text)
{
	text=text.replace("&","&amp;");
	text=text.replace("<","&lt;");
	text=text.replace(">","&gt;");
	return text;
}

//show in the console and write in the file the debug log, see env.h for the debug level
#if defined (__FILE__) && defined (__LINE__)
void debug_console_fonction(int number,const QString& fonction,const QString& text,QString file,const int& ligne)
#else
void debug_console_fonction(int number,const QString& fonction,const QString& text)
#endif
{
	if(number<=DEBUG_ULTRACOPIER)
	{
		#if defined (__FILE__) && defined (__LINE__)
		file=file.remove(QRegExp("\\.[/\\\\]"));
		QString lignestring=QString::number(ligne);
		#define FILESOURCEDEFINE_ULTRACOPIER file+":"+lignestring+":<span style=\"color: white;\">"+debug_multiple_QString("_",(20-(file.length()+lignestring.length())))+"</span>"+" "
		#else
		#define FILESOURCEDEFINE_ULTRACOPIER ""
		#endif
		QMutexLocker lock_mutex(&mutex);
		Stime = QString::number(theTimeProcess->elapsed());
		if(theLogFile!=NULL)
		{
			if(theLogFile->size()>100*1024*1024) // greater than 100MB
				cout << "File log greater to 100MB, stop to record it!\n";
			else
			{
				if(number<10)
					htmlFormat="<span style=\"color: #ff0c00;\"><b>(<span style=\"color: white;\">"+debug_multiple_QString("_",(8-Stime.length()))+"</span>"+Stime+")</b> "+FILESOURCEDEFINE_ULTRACOPIER+"<i><u>"+fonction+"()</u></i>: "+htmlEntities(text)+"</span>\n";
				else if(number<20)
					htmlFormat="<span style=\"color: #ff0c00;\"><b>(<span style=\"color: white;\">"+debug_multiple_QString("_",(8-Stime.length()))+"</span>"+Stime+")</b> "+FILESOURCEDEFINE_ULTRACOPIER+"<i><u>"+fonction+"()</u></i>: "+htmlEntities(text)+"</span>\n";
				else if(number<40)
					htmlFormat="<span style=\"color: #94a5ff;\"><b>(<span style=\"color: white;\">"+debug_multiple_QString("_",(8-Stime.length()))+"</span>"+Stime+")</b> "+FILESOURCEDEFINE_ULTRACOPIER+"<i><u>"+fonction+"()</u></i>: "+htmlEntities(text)+"</span>\n";
				else if(number<60)
					htmlFormat="<span style=\"color: #009d0b;\"><b>(<span style=\"color: white;\">"+debug_multiple_QString("_",(8-Stime.length()))+"</span>"+Stime+")</b> "+FILESOURCEDEFINE_ULTRACOPIER+"<i><u>"+fonction+"()</u></i>: "+htmlEntities(text)+"</span>\n";
				else if(number<80)
					htmlFormat="<span style=\"color: #cc00ff;\"><b>(<span style=\"color: white;\">"+debug_multiple_QString("_",(8-Stime.length()))+"</span>"+Stime+")</b> "+FILESOURCEDEFINE_ULTRACOPIER+"<i><u>"+fonction+"()</u></i>: "+htmlEntities(text)+"</span>\n";
				else
					htmlFormat="<span style=\"color: #ffd200;\"><b>(<span style=\"color: white;\">"+debug_multiple_QString("_",(8-Stime.length()))+"</span>"+Stime+")</b> "+FILESOURCEDEFINE_ULTRACOPIER+"<i><u>"+fonction+"()</u></i>: "+htmlEntities(text)+"</span>\n";
				theLogFile->write(htmlFormat.toLocal8Bit());
				theLogFile->flush();
				if(thisIcon!=NULL)
					thisIcon->appendLog(htmlFormat);
			}
		}
		else
			cout << "NULL log File ERROR ERROR ERROR!\n";
		#if defined (__FILE__) && defined (__LINE__)
		cout << "(" << qPrintable(Stime.rightJustified(8,' ')) << ") " << qPrintable(file+":"+lignestring+":"+debug_multiple_QString(" ",(20-(file.length()+lignestring.length())))+" ") << qPrintable(fonction) << "(): " << qPrintable(text) << "\n";
		#else
		cout << "(" << qPrintable(Stime.rightJustified(8,' ')) << ") " << qPrintable(fonction) << "(): " << qPrintable(text) << "\n";
		#endif

	}
	if(thisIcon!=NULL)
		if(number<=20)
			#if defined (__FILE__) && defined (__LINE__)
			thisIcon->showDelayedPopupThreadSafe(file+":"+QString::number(ligne)+": "+fonction+"():\n"+text);
			#else
			thisIcon->showDelayedPopupThreadSafe(fonction+"():\n"+text);
			#endif
}
#endif

/** \brief Return the starting language
\return The 2 letters code */
QString ReturnStartLang()
{
	return StartParamLang;
}

/** \brief set if need start when session is open
  \param needBySetup True if need be open with session */
void setOpenWithSession(bool needBySetup)
{
	#ifdef ULTRACOPIER_MODE_WINDOWS
	HKEY	ultracopier_regkey;///< For connect to reg key
	//for autostart
	QString runStringApp = "\"" + QApplication::applicationFilePath() + "\"";
	runStringApp.replace( "/", "\\" );
	wchar_t windowsString[255];
	runStringApp.toWCharArray(windowsString);
	RegCreateKeyEx(HKEY_CURRENT_USER, TEXT("Software\\Microsoft\\Windows\\CurrentVersion\\Run"), 0, 0, REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS, 0, &ultracopier_regkey, 0);
	if(needBySetup)
		RegSetValueEx(ultracopier_regkey, TEXT("ultracopier"), 0, REG_SZ, (BYTE*)windowsString, runStringApp.length()*2);
	else
		RegDeleteValue(ultracopier_regkey, TEXT("ultracopier"));
	RegCloseKey(ultracopier_regkey);
	#else
	needBySetup=false;
	#endif
}

/** \brief Return if need by open with session
  \return Return if need by open with session */
bool getOpenWithSession()
{
	#ifdef ULTRACOPIER_MODE_WINDOWS
	HKEY	ultracopier_regkey;///< For connect to reg key
	bool temp=false;
	RegCreateKeyEx(HKEY_CURRENT_USER, TEXT("Software\\Microsoft\\Windows\\CurrentVersion\\Run"), 0, 0, REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS, 0, &ultracopier_regkey, 0);
	DWORD kSize=254;
	if(RegQueryValueEx(ultracopier_regkey,TEXT("ultracopier"),NULL,NULL,(LPBYTE)0,&kSize) == ERROR_SUCCESS)
		temp=true;
	RegCloseKey(ultracopier_regkey);
	return temp;
	#else
	return false;
	#endif
}

#if defined (Q_OS_WIN32) || defined (Q_OS_WINCE)
/** \brief Return the encoded user name
\return Return the encoded user name open with session */
QString UltracopierWindowsGetUserName()
{
	QString userName;
	DWORD size=0;
	if(GetUserName(NULL,&size) || (GetLastError()!=ERROR_INSUFFICIENT_BUFFER))
	{
	}
	else
	{
		WCHAR * userNameW=new WCHAR[size];
		if(GetUserName(userNameW,&size)){
			userName.fromWCharArray(userNameW,size*2);
			userName=QString(QByteArray((char*)userNameW,size*2-2).toHex());
		}
		delete userNameW;
	}
	DEBUGCONSOLE(90,"UltracopierWindowsGetUserName","userName: \""+userName+"\"");
	return userName;
}
#endif

QString fromPercentEncodingLocal(QString text)
{
	return QString::fromLocal8Bit(QByteArray::fromPercentEncoding(text.toLocal8Bit()));
}
