#ifndef HELPDIALOG_H
#define HELPDIALOG_H

#include <QtGui/QDialog>
#include <QStringList>
#include <QFileDialog>
#include <QMessageBox>
#include <QCloseEvent>

#include "env.h"

#if (DEBUG_ULTRACOPIER>0)
#include <QTextEdit>
#include <QTimer>
#endif

namespace Ui {
    class helpDialog;
}

/** \brief Show the help dialog, licence and the version of ultracopier.

Show the help dialog, licence and the version of ultracopier. In debug mode it show too the debug level, compiler used, and the debug console.
*/

class helpDialog : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(helpDialog)
public:
    explicit helpDialog(QWidget *parent = 0);
    virtual ~helpDialog();
    void SetText(QString url,QString version_type,QString version,int debug_level=0);

private:
    Ui::helpDialog *m_ui;
    #if (DEBUG_ULTRACOPIER>0)
    QTextEdit *textEditDebug;
    QString source;
    QTimer onShot;
    #endif

private slots:
    #if (DEBUG_ULTRACOPIER>0)
    void on_pushButtonSaveAdvancedRepport_clicked();
    void updateTextEditDebug();
    #endif
    void on_pushButton_clicked();
    void closeEvent(QCloseEvent * event);
public slots:
    #if (DEBUG_ULTRACOPIER>0)
    void new_html_log(QString theNewHtml);
    void show_debug_console();
    #endif
    //update the style
    void UpdateStyle();
};

#endif // HELPDIALOG_H
