/***************************************************************************
				  WriteThread.h
			      -------------------

     Begin        : Web May 6 2009 19:11 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class of the writeThread

****************************************************************************/

#include <QObject>
#include <QThread>
#include <QByteArray>
#include <QFile>
#include <QObject>
#include <QList>
#include <QMutex>
#include <QWaitCondition>
#include <QFileInfo>
#include <QSemaphore>
#include "structDef.h"

#ifndef WRITETHREAD_H
#define WRITETHREAD_H

#include "CopyThread.h"

class copyThread;

class WriteThread : public QThread
{
	Q_OBJECT
	public:
		WriteThread(QObject * parent = 0);
		~WriteThread();
		QString errorString();
		void setFiles(QString source,QString destination,copyItemInternal theItem);
		bool openDestination();
		void stop();
		void addNewBlock(QByteArray newBlock);
		void setKeepDate(bool keepDate);
		void setPreallocation(bool preallocation);
		void skipTheCurrentFile();
		enum currentStat {
		Stopped,
		PausedInError,
		Running
		};
		/// \brief set action on error
		void errorAction(int action);
		/// \brief set if is moving mode or not
		void setMovingMode(bool movingMode);
		/// \brief end of source detected
		void endOfSourceDetected();
		#if (DEBUG_ULTRACOPIER>0)
		void setId(int id);
		#endif
		void stopWhenIsFinish(bool stopThreadWhenFinish);
		/// \brief get the current stat
		currentStat getTheCurrentStat();
		/// \brief get the current error
		writeThreadError getTheCurrentError();
		/// \brief get the current copyItemInternal item
		copyItemInternal getCopyItemInternal();
	protected:
		void run();
	private:
		volatile bool		stopIt;			///< For store the stop query
		volatile bool		movingMode;		///< Set if is in moving mode
		volatile int		actionAfterUnlock;	///< For action after unlock the mutex
		volatile bool		keepDate;		///< For store if date need be keep
		volatile bool		endOfSource;		///< For store if end os source
		volatile bool		copyHadBegin;		///< For store if copy had begin
		volatile bool		preallocation;		///< For store if preallocation is needed
		volatile bool		stopThreadWhenFinish;	///< For stop thread when the thread is finish
		volatile bool		needSkipTheCurrentFile;	///< For stop thread when the thread is finish
		QMutex                  accessList;		///< For use the list
		QSemaphore		*freeBlock;
		QSemaphore		usedBlock;
		QSemaphore		waitOneFile;
		QSemaphore		waitOneAction;
		currentStat		theCurrentStat;		///< The current stat
		QFile			source;			///< For have global copie progression
		QFile			destination;		///< For have global copie progression
		QList<QByteArray>	theBlockList;		///< Store the block list
		copyItemInternal	theItem;		///< Store current item for put at end if needed
		int			sizeList;
		#if (DEBUG_ULTRACOPIER>0)
		qint64			debugRcount;
		qint64			debugWcount;
		int			id;
		bool			haveBeenStarted;
		#endif
		QString			errorStringDef;
		quint64			CurentCopiedSize;
		writeThreadError	theCurrentError;
		/// \brief error on file or folder, bouton enable, file path, error message
		void errorOnFile(int,QString,QString,quint64);
		QString			translationErrorResize;
		QString			translationErrorWriting;
		QString			translationErrorDate;
		QString			translationErrorRemove;
	signals:
		void haveFinishFileOperation();
};

#endif // WRITETHREAD_H
