/***************************************************************************
                                   FEwindow.h
                              -------------------
 
     Begin        : Sat Oct 20 2007 20:20 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class of the file exists window
 
****************************************************************************/

#ifndef INCLUDE_FEWINDOW_H
#define INCLUDE_FEWINDOW_H

#include <QDialog>
#include "env.h"

#include "ui_copyFileExists.h"

/** \brief The file exists window

This window show what file exists, and ask what to do.
*/
class CopyFileExistsWindow : public QDialog, public Ui::copyFileExists
{
	Q_OBJECT
public:
	CopyFileExistsWindow(QWidget *parent);
	~CopyFileExistsWindow();
	//set text if source and destination is same, with custom text
	void SourceAndDestinationIsSame(const QString& dest,const QString& text);
	//set text if source and destination is same
	void SourceAndDestinationIsSame(const QString& dest);
	//set the text if the window have show if the file already exists
	void AlreadyExists(QString path,QString source,QString dest);
signals:
	//send the query action
	void ActionOnFileExists(int action);
private slots:
	void cancelButton();
	void overwriteButton();
	void renameButton();
	void skipButton();
	void renameAllways();
	void skipAllways();
	void overwriteAllways();
	void slotOverwriteIfNotSame();
	void slotOverwriteAllwaysIfNotSame();
	void slotOverwriteIfNewer();
	void slotOverwriteAllwaysIfNewer();
private:
	QMenu	*menuOverwrite;			///< Menu on the "overwrite" button
	QAction *alwaysOverwrite;		///< Action on the "overwrite" button
	QAction *overwriteIfNotSame;		///< Action on the "overwrite if not same" button
	QAction *overwriteIfNewer;		///< Action on the "overwrite if newer" button
	QAction *alwaysOverwriteIfNotSame;	///< Action on the "always overwrite if not same" button
	QAction *alwaysOverwriteIfNewer;	///< Action on the "always overwrite if newer" button
	QMenu	*menuRename;			///< Menu on the "rename" button
	QAction *alwaysRename;			///< Action on the "rename" button
	QMenu	*menuSkip;			///< Menu on the "skip" button
	QAction *alwaysSkip;			///< Action on the "skip" button
public slots:
	//set or update the style
	void UpdateStyle();
};

#endif
