#!/usr/bin/env gosh

(use test.unit)

(require "test/uim-test-utils")

(define-uim-test-case "test macro"
  ("test normal-let"
   (assert-equal '(-1 "b" (c) d)
                 (uim '(let ((a -1)
                             (b "b")
                             (c '(c))
                             (d 'd))
                         (list a b c d))))
   (assert-equal '() (uim '(let (a) a))))
  ("test named-let"
   (assert-equal -1 (uim '(let - ((x -)) (x 1))))
   (assert-equal '(4 3 2 1 0)
                 (uim '(let count-down ((lst '())
                                        (i 0))
                         (if (< i 5)
                           (count-down (cons i lst) (+ i 1))
                           lst))))
   (assert-equal '((6 1 3) (-5 -2))
                 (uim '(let loop ((numbers '(3 -2 1 6 -5))
                                  (nonneg '())
                                  (neg '()))
                         (cond ((null? numbers) (list nonneg neg))
                               ((> 0 (car numbers))
                                (loop (cdr numbers)
                                      nonneg
                                      (cons (car numbers) neg)))
                               (else
                                (loop (cdr numbers)
                                      (cons (car numbers) nonneg)
                                      neg))))))))
