/*

  Copyright (c) 2003,2004 uim Project http://uim.freedesktop.org/

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <uim/gettext.h>
#include <gtk/gtk.h>

GtkWidget *uim_helper_toolbar_new(void);

static void
delete_event(GtkWidget *widget, gpointer data)
{
  gtk_main_quit ();
}

static gboolean
button_press_event(GtkWidget *window, GdkEventButton *event, gpointer data)
{
  int x,y;
  gtk_window_get_position (GTK_WINDOW(window), &x, &y);

  gtk_window_begin_move_drag(GTK_WINDOW(window), event->button,
			     x + event->x, y + event->y, event->time);
  return FALSE;
}

int 
main (int argc, char *argv[])
{
  GtkWidget *toolbar;
  GtkWidget *window;

  gtk_set_locale();
  
  gtk_init( &argc, &argv );

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_window_set_type_hint(GTK_WINDOW(window), GDK_WINDOW_TYPE_HINT_DOCK);

  gtk_window_set_skip_taskbar_hint(GTK_WINDOW(window), TRUE);
  gtk_window_set_decorated (GTK_WINDOW(window), FALSE);
  gtk_window_stick(GTK_WINDOW(window));

  gtk_widget_add_events (window, GDK_BUTTON_PRESS_MASK);

  g_signal_connect (G_OBJECT (window), "delete_event",
		    G_CALLBACK (delete_event), NULL);

  g_signal_connect (G_OBJECT (window), "button-press-event",
		    G_CALLBACK (button_press_event), NULL);
  
  toolbar = (GtkWidget*)uim_helper_toolbar_new();

  gtk_container_add (GTK_CONTAINER (window), toolbar);  

  if (argc > 1) {
    if (!gtk_window_parse_geometry (GTK_WINDOW (window), argv[1])) {
      g_warning (_("Unable to parse the geometry string '%s'"), argv[1]);
    }
  }
  
  gtk_widget_show_all (GTK_WIDGET (window));

  gtk_main ();
  return 0;
}

