/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ProjectViewDocTree.h"

#include <U2Core/GObject.h>
#include <U2Core/DocumentModel.h>
#include <U2Gui/ProjectTreeController.h>

namespace U2 {

ProjectViewDocTree::ProjectViewDocTree(QWidget* w) : QTreeWidget(w) 
{
    setDragDropMode(QAbstractItemView::DragDrop);
}

QMimeData * ProjectViewDocTree::mimeData( const QList<QTreeWidgetItem *> items ) const {
    if (items.size() != 1) {
        return NULL;
    }
    QMimeData * mime = NULL;
    ProjViewItem* item = (ProjViewItem*)items.first();
    if (item->isObjectItem()) {
        ProjViewObjectItem* objItem = (ProjViewObjectItem*)item;
        mime = new GObjectMimeData(objItem->obj);
    } else if (item->isDocumentItem()) {
        mime = new DocumentMimeData(static_cast<ProjViewDocumentItem*>(item)->doc);

    }
    return mime;
}


}//namespace
