/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _MUSCLE_SCHEMA_TASK_H_
#define _MUSCLE_SCHEMA_TASK_H_

#include <U2Core/DocumentModel.h>
#include <U2Core/Task.h>
#include <U2Remote/RemoteWorkflowRunTask.h>
#include <U2Core/MAlignmentObject.h>
#include <U2Core/LoadDocumentTask.h>
#include <U2Core/SaveDocumentTask.h>
#include <U2Lang/RunSchemaForTask.h>

#include "MuscleTask.h"

namespace U2
{

class MuscleSchemaTask: public Task
{
    Q_OBJECT

public:
    MuscleSchemaTask(MAlignmentObject *mao, const MuscleTaskSettings &muscleSettings);
    virtual ~MuscleSchemaTask();

protected:
    virtual RunSchemaForTask* prepareRunSchemaTask();
    LoadDocumentTask* prepareOpenResultFileTask();

    virtual void prepare();
    virtual QList<Task*> onSubTaskFinished(Task *subTask);

private:
    Document* createInputDocument();
    QVariantMap convertMuscleSettings(const MuscleTaskSettings &muscleSettings);

protected:
    static const QString SCHEMA_NAME;
    const DocumentFormatId IO_FORMATID;

protected:
    QVariantMap schemaParameters;
    QString tempSubDir;
    QString inFile, outFile;

private:
    MAlignmentObject *mao;
    MuscleTaskSettings muscleSettings;

    RunSchemaForTask *runTask;
    SaveDocumentTask *saveInputFileTask;
    LoadDocumentTask *openResultFileTask;

};	// class MuscleSchemaTask

class MuscleSchemaRemoteTask : public MuscleSchemaTask
{
public:
    MuscleSchemaRemoteTask(RemoteMachineSettings *rms_, MAlignmentObject *mao, const MuscleTaskSettings &muscleSettings) :
        MuscleSchemaTask(mao, muscleSettings), rms(rms_)
    {}

protected:
    virtual RunSchemaForTask* prepareRunSchemaTask()
    {
        return new RemoteRunSchemaForTask(rms, SCHEMA_NAME, schemaParameters, inFile, outFile);
    }

private:
    RemoteMachineSettings *rms;
};  // class MuscleSchemaRemoteTask

}   // namespace U2

#endif	// #ifndef _MUSCLE_SCHEMA_TASK_H_
