/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_BOWTIE_ADAPTER_H_
#define _U2_BOWTIE_ADAPTER_H_

#include <QtCore/QObject>
#include <U2Core/GUrl.h>



namespace U2 {

class MAlignment;
class TaskStateInfo;
class BowtieReadsReader;
class BowtieReadsWriter;

class BowtieAdapter : public QObject {
Q_OBJECT
public:
	static void doBowtie(const QString& ebwtFileName, BowtieReadsReader* reader, BowtieReadsWriter* writer, const U2::GUrl& resultUrl, TaskStateInfo& ti);
	static void doBowtieWorker(int id, TaskStateInfo& ti);
	static void doBowtieBuild(const QString& infile, const QString& outfile, TaskStateInfo& ti );
};

}//namespace

#endif
