/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_WCFG_SCHEMA_ALIASES_DIALOG_CONTROLLER_H_
#define _U2_WCFG_SCHEMA_ALIASES_DIALOG_CONTROLLER_H_

#include <U2Lang/Schema.h>
#include <ui/ui_SchemaAliasesConfigurationDialog.h>

namespace U2 {
namespace Workflow {

typedef QMap<ActorId, QMap<Descriptor, QString> > SchemaAliasesCfgDlgModel;

class SchemaAliasesConfigurationDialogImpl : public QDialog, public Ui_SchemaAliasesConfigurationDialog {
    Q_OBJECT
public:
    SchemaAliasesConfigurationDialogImpl( const Schema & sc, QWidget * p = NULL );
    
    // remove empty aliases from model
    SchemaAliasesCfgDlgModel getModel() const;
    // aliases for schema should be different
    bool validateModel() const;
    
private:
    void initializeModel( const Schema & schema );
    void clearAliasTable();
    
private slots:
    void sl_procSelected( int row );
    void sl_aliasChanged( int row, int col );
    
private:
    SchemaAliasesCfgDlgModel    model;
    QMap<int, ActorId>          procListMap; // pairs (row, actorId)
    
}; // SchemaAliasesConfigurationDialogImpl

} // Workflow
} // U2

#endif // _U2_WCFG_SCHEMA_ALIASES_DIALOG_CONTROLLER_H_
