/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_GENOME_ALIGNER_TASK_H_
#define _U2_GENOME_ALIGNER_TASK_H_

#include <U2Algorithm/DnaAssemblyTask.h>
#include <U2Formats/StreamSequenceReader.h>
#include <U2Formats/StreamSequenceWriter.h>

namespace U2 {

class DNASequenceObject;
class DNATranslation;
class LoadDocumentTask;
class CreateSArrayIndexTask;
class GenomeAlignerFindTask;
class SArrayIndex;

class GenomeAlignerTask : public DnaAssemblyToReferenceTask {
    Q_OBJECT
public:
    GenomeAlignerTask(const DnaAssemblyToRefTaskSettings& settings, bool justBuildIndex = false);
    virtual void prepare();
    virtual void run();
    virtual ReportResult report();
    virtual QList<Task*> onSubTaskFinished(Task* subTask);
    QList<Task*> onJustBuildSubTaskFinished(Task* subTask);
    static const QString OPTION_ALIGN_REVERSED; 
    static const QString OPTION_IF_ABS_MISMATCHES;
    static const QString OPTION_MISMATCHES;
    static const QString OPTION_PERCENTAGE_MISMATCHES;
    static const QString OPTION_MAX_BUNCH_SIZE;
    static const QString OPTION_PREBUILT_INDEX;
    static const QString OPTION_INDEX_URL;
    static const QString OPTION_QUAL_THRESHOLD;
    static const QString OPTION_IF_ONLY_FIRST_MATCH;
    static const QString INDEX_EXTENSION;
    static const int MIN_SHORT_READ_LENGTH = 30;

    DNA_ASSEMBLEY_TO_REF_TASK_FACTORY(GenomeAlignerTask)
private:
    LoadDocumentTask* loadRefTask;
    CreateSArrayIndexTask* createIndexTask;
    DNASequenceObject* refSeqObj;
    DNATranslation* transl;
    QList<DNASequence> shortReads;
    StreamSequenceReader seqReader;
    StreamContigWriter seqWriter;
    bool justBuildIndex;
    uint windowSize, bunchSize, nMismatches, ptMismatches;
    bool absMismatches;
    bool prebuiltIdx;
    bool onlyFirstMatch;
    QString indexFileName;
    bool alignReversed, initFindSubtasks;
    // reads are compared by bunches of this size.
    // after the bunch is processed, next bunch is read
    // this continues while all short reads are processed
    uint maxBunchSize; 
    uint numFoundResults;
    int qualityThreshold;
    QList<GenomeAlignerFindTask*> findTasks;
    void readShortReadsBunch();
    void writeResults();
    void setupCreateIndexTask();
    bool isOneOfFindSubtasks(Task* task);
    void calculateWindowSize();
};

} //namespace

#endif // _U2_GENOME_ALIGNER_TASK_H_
