/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "BlastTaskSettings.h"

namespace U2 {

BlastTaskSettings::BlastTaskSettings() {
    offsInGlobalSeq=0;
    aobj=NULL;
    alphabet=NULL;
    isNucleotideSeq=false;
    numberOfHits=0;
    isDefaultMatrix=true;
    isDefautScores=true;
    isDefaultCosts=true;
    reset();
}

void BlastTaskSettings::reset() {
    programName="";
    databaseNameAndPath="";
    expectValue=10.0;
    megablast=false;
    wordSize=11;
    gapOpenCost=0;
    gapExtendCost=0;
    mismatchPenalty=0;
    matchReward=0;
    matrix="";
    queryFile="";
    outputResFile="";
    numberOfProcessors=1;
    needCreateAnnotations=true;
    filter="";
}

}//namespace
