/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _DELETE_GAPS_DIALOG_
#define _DELETE_GAPS_DIALOG_

#include "ui/ui_DeleteGapsDialog.h"


namespace U2 {

enum DeleteMode {
    DeleteByAbsoluteVal,
    DeleteByRelativeVal,
    DeleteAll
};

class DeleteGapsDialog: public QDialog, public Ui_DeleteGapsDialog {
    Q_OBJECT
public:
    DeleteGapsDialog(QWidget* parent, int alignmentLen);
    DeleteMode getDeleteMode() const {return deleteMode;}
    int getValue() const {return value;}
private slots:
    void sl_onOkClicked();
    void sl_onCancelClicked();

private:
    DeleteMode deleteMode;
    int value;
};

}

#endif