/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_CREATE_RULER_DIALOG_CONTROLLER_H_
#define _U2_CREATE_RULER_DIALOG_CONTROLLER_H_


#include <ui/ui_CreateRulerDialog.h>

#include <U2Core/LRegion.h>

#include <QtCore/QSet>
#include <QtGui/QDialog>

namespace U2 {

class U2VIEW_EXPORT CreateRulerDialogController : public QDialog, public Ui_CreateRulerDialog {
    Q_OBJECT
public:
    CreateRulerDialogController(const QSet<QString>& namesToFilter, const LRegion& range, int offset = -1, QWidget* p=NULL);
    
    virtual void accept ();

private slots:
    void sl_colorButtonClicked();

private:
    void updateColorSample();

public:
    QString         name;
    int             offset;
    QColor          color;
    QSet<QString>   filter;

};


}// namespace

#endif
