/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_ANNOTATED_DNA_VIEW_STATE_H_
#define _U2_ANNOTATED_DNA_VIEW_STATE_H_

#include <U2Core/LRegion.h>
#include <U2Core/GObject.h>
#include <QtCore/QVariant>

namespace U2 {

class AnnotatedDNAView;

class U2VIEW_EXPORT AnnotatedDNAViewState {
public:
    AnnotatedDNAViewState();
    AnnotatedDNAViewState(const QVariantMap& _stateData) : stateData(_stateData){}

    static QVariantMap saveState(AnnotatedDNAView* v);

    bool isValid() const;

    void setSequenceObjects(const QList<GObjectReference>& objs, const QList<LRegion>& selections);

    QList<GObjectReference> getSequenceObjects() const;

    QList<LRegion> getSequenceSelections() const;

    QList<GObjectReference> getAnnotationObjects() const;

    void setAnnotationObjects(const QList<GObjectReference>& objs);

    QVariantMap stateData;
};




} // namespace

#endif
