/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_FLOWTASK_H_
#define _U2_FLOWTASK_H_

#include <U2Core/Task.h>
#include <U2Lang/Schema.h>
#include <U2Lang/WorkflowManager.h>
#include <U2Lang/WorkflowIOTasks.h>
#include <U2Lang/CoreLibConstants.h>

#include <QtCore/QUrl>

namespace U2 {

namespace Workflow {
    class CommunicationChannel;
}
using namespace Workflow;

class U2LANG_EXPORT WorkflowRunTask : public Task {
    Q_OBJECT
public:
    WorkflowRunTask(const Schema&, QList<Iteration>);
    virtual QString generateReport() const;
    virtual ReportResult report(); 

signals:
    void si_ticked();
public:
    QList<WorkerState> getState(Actor*);
    int getMsgNum(Link*);
    int getMsgPassed(Link*);
};

class WorkflowIterationRunTask : public Task {
    Q_OBJECT
public:
    WorkflowIterationRunTask(const Schema&, const Iteration&);
    ~WorkflowIterationRunTask();
    virtual void prepare();
    virtual ReportResult report();

signals:
    void si_ticked();
public:
    WorkerState getState(Actor*);
    int getMsgNum(Link*);
    int getMsgPassed(Link*);
    QStringList getFiles() const;

protected:
    virtual QList<Task*> onSubTaskFinished(Task* subTask);

private:
    Schema* schema;
    Scheduler* scheduler;
    QMap<ActorId, ActorId> rmap;
    QMap<QString, CommunicationChannel*> lmap;
    QStringList fileLinks;
};

} //namespace

#endif
