/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <U2Lang/SchemaSerializer.h>
#include "WorkflowEnv.h"

namespace U2 {
namespace Workflow {

WorkflowEnv* WorkflowEnv::instance;

bool WorkflowEnv::init(WorkflowEnv* env) {
    if (instance) {
        assert(0);// Duplicate initialization;
        return false;
    }
    
    env->data = env->initDataRegistry();
    env->proto = env->initProtoRegistry();
    env->domain = env->initDomainRegistry();
    env->dvfReg = env->initDataTypeValueFactoryRegistry();
    instance = env;
    return true;
}

}// namespace Workflow
}//namespace U2
