/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_QUERY_DESIGNER_REGISTRY_H_
#define _U2_QUERY_DESIGNER_REGISTRY_H_

#include "QDScheme.h"

#include <U2Core/IdRegistry.h>


namespace U2 {
    
class U2LANG_EXPORT QDActorPrototypeRegistry : public QObject, public IdRegistry<QDActorPrototype> {
    Q_OBJECT
public:
    void registerProto(QDActorPrototype* _factory);
    QDActorPrototype* unregisterProto(const QString& id);
    QList<QDActorPrototype*> getProtos() { return IdRegistry<QDActorPrototype>::getAllEntries(); }
    QDActorPrototype* getProto(const QString& id) { return IdRegistry<QDActorPrototype>::getById(id); }
signals:
    void si_registryModified();
};

}//namespace

#endif
