/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_WORKFLOW_BASE_LIB_H_
#define _U2_WORKFLOW_BASE_LIB_H_

#include <U2Lang/Datatype.h>

namespace U2 {
namespace Workflow {

class U2LANG_EXPORT BioActorLibrary : public QObject {
    Q_OBJECT
public:
    static const Descriptor CATEGORY_DATASRC(){return Descriptor("a", tr("Data sources"), "");}
    static const Descriptor CATEGORY_DATASINK(){return Descriptor("b", tr("Data sinks"), "");}
    static const Descriptor CATEGORY_CONVERTERS() {return Descriptor("bc", tr("Data converters"), "");}
    //static const Descriptor CATEGORY_OTHER(){return Descriptor("z", tr("Other"), "");}
    static const Descriptor CATEGORY_BASIC(){return Descriptor("c", tr("Basic analysis"), "");}
    static const Descriptor CATEGORY_ALIGNMENT(){return Descriptor("d", tr("Multiple sequence alignment"), "");}
    static const Descriptor CATEGORY_ASSEMBLY() {return Descriptor("asm", tr("DNA assembly"), ""); }  
    static const Descriptor CATEGORY_TRANSCRIPTION() {return Descriptor("tr", tr("Transcription factor"), ""); }
    static const Descriptor CATEGORY_SCRIPT() {return Descriptor("sa", tr("Custom elements"), "");}

    static const Descriptor SEQ_SLOT();
    static const Descriptor MA_SLOT();
    static const Descriptor FEATURE_TABLE_SLOT();

    static const QString FILE_MODE_ATTR_ID;
    static const Descriptor FILE_MODE_ATTR();

    static void init();
};

}//Workflow namespace
}//GB2 namespace

#endif
