/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_PDB_FORMAT_H_
#define _U2_PDB_FORMAT_H_

#include <U2Core/BaseDocumentFormats.h>
#include <U2Core/DocumentModel.h>
#include <QtCore/QSharedDataPointer>

namespace U2 {

class IOAdapter;
class BioStruct3D;
class AnnotationTableObject;
class DNASequenceObject;
class AtomData;
typedef QSharedDataPointer<AtomData> SharedAtom;


class U2FORMATS_EXPORT  PDBFormat : public DocumentFormat {
    Q_OBJECT
public:
    PDBFormat(QObject* p);
    virtual DocumentFormatId getFormatId() const {return BaseDocumentFormats::PLAIN_PDB;}
    virtual const QString& getFormatName() const {return formatName;}

    virtual Document* loadDocument(IOAdapter* io, TaskStateInfo& ti, const QVariantMap& fs, DocumentLoadMode mode = DocumentLoadMode_Whole);

    virtual FormatDetectionResult checkRawData(const QByteArray& rawData) const;
    static int getElementNumberByName(const QByteArray& elementName);
    static char getAcronymByName(const QByteArray& name);
    static QHash<QByteArray, int> createAtomNumMap();
    static void calculateBonds(BioStruct3D& bioStruct);
    static Document* createDocumentFromBioStruct3D(BioStruct3D &bioStruct, DocumentFormat* format, IOAdapterFactory* iof, const GUrl& url, TaskStateInfo& ti, const QVariantMap& fs );


private:
    
    QString formatName;
    static QHash<QByteArray,int> atomNumMap;
    static QHash<QByteArray, char> acronymNameMap;
    
    void initUtilityMaps();
    void updateSecStructChainIndexes(BioStruct3D& biostruc);
    void fillBioStruct3DAnnotationTable(AnnotationTableObject* ao, const BioStruct3D& bioStruct);


    class PDBParser {
    private:
        // Data
        IOAdapter *io;
        QString currentPDBLine;
        int currentChainIndex;
        int currentModelIndex;
        bool flagMultipleModels, flagAtomRecordPresent;
        QHash<char, int> chainIndexMap;
        QHash<char, QByteArray> seqResMap;
        //QMap<int, int> residueStartIndexMap;
        //QMap<int, int> unreferencedResidueStartIndexMap;
        //QVariantMap currentMoleculeDescr;

        // Methods
        QByteArray getSpecValue(const QByteArray& specLine, const QByteArray& valueName);
        void parseHeader(BioStruct3D& biostruct, TaskStateInfo& ti);
        void parseCompound(BioStruct3D& biostruct, TaskStateInfo& ti);
        void parseDBRef(BioStruct3D& biostruct, TaskStateInfo& ti);
        void parseSequence(BioStruct3D& biostruct, TaskStateInfo& ti);
        void parseSecondaryStructure(BioStruct3D& biostruct, TaskStateInfo& ti);
        void parseHet(BioStruct3D& biostruct, TaskStateInfo& ti);
        void parseAtomConnections(BioStruct3D& biostruct, TaskStateInfo& ti);
        void parseAtom(BioStruct3D& biostruct, TaskStateInfo& ti);
        void parseModel(BioStruct3D& biostruct, TaskStateInfo& ti);
        void updateSecStructChainIndexes( BioStruct3D& biostruc );
        bool seqResContains(char chainIdentier, int residueIndex, char acronym);
        QByteArray getNextSpecLine();
    public:
        PDBParser(IOAdapter* io);
        void parseBioStruct3D(BioStruct3D& biostruct, TaskStateInfo& ts);
    };

};

}//namespace

#endif
