/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_SEQUENCE_UTILS_H_
#define _U2_SEQUENCE_UTILS_H_

#include <U2Core/global.h>
#include <U2Core/DNASequence.h>
#include <U2Core/LRegion.h>

namespace U2 {

class DNATranslation;

class U2CORE_EXPORT SequenceUtils : public QObject {
    Q_OBJECT
public:
    
    /** 
        Extracts sequences regions
        If 'complTT' != NULL - reverse & complements regions. 
        (Note: the order of complemented regions is also reversed)
    */
    static QList<QByteArray> extractRegions(const QByteArray& seq, const QList<LRegion>& regions, DNATranslation* complTT);
    
    /** Joins sequence parts into a single sequence */
    static QByteArray joinRegions(const QList<QByteArray>& parts);


    /** Translates sequence parts, if  join == true -> joins parts before translation is started
    */
    static QList<QByteArray> translateRegions(const QList<QByteArray>& origParts, DNATranslation* aminoTT, bool join);

    
    /** Extract sequence parts marked by the regions*/
    static QList<QByteArray> extractSequence(const QByteArray& seq, const QList<LRegion>& regions, 
                                            DNATranslation* complTT, DNATranslation* aminoTT, bool join, bool circular);


    /** Returns regions locations as if they were joined */
    static QList<LRegion> toJoinedRegions(const QList<QByteArray>& seqParts);
};


}//namespace

#endif
