/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _OLD_ANNOTATION_UTILS_H_
#define _OLD_ANNOTATION_UTILS_H_

#include <U2Core/LRegion.h>

namespace U2 {

class U2CORE_EXPORT AnnotationUtils {
public:


    // returns translation frame the region is placed on
    static int getRegionFrame(int sequenceLen, bool complement, bool order, int region, const QList<LRegion>& location);

    /////////////////////////////////////////////////////////////////////////////////////////
    ///////// Below is copy-pasted code for old data model. See U2AnnotationUtils. ///////////
    /////////////////////////////////////////////////////////////////////////////////////////

    enum AnnotationStrategyForResize{
        AnnotationStrategyForResize_Resize, 
        AnnotationStrategyForResize_Remove,
        AnnotationStrategyForResize_Split
    };

    /** Corrects annotation locations for a sequence. The passed list is updated with new locations, 
    the returned list contains removed locations if any.
    If specified strategy is 'remove', removes all locations which intersect the removed region or fall inside it.
    */
    static QList<LRegion> fixLocationsForRemovedRegion(const LRegion& regionToDelete, QList<LRegion>& loc, AnnotationStrategyForResize s);

    /** Corrects annotation locations for a sequence. The passed list is updated with new locations, 
    the returned list contains removed locations if any.
    If specified strategy is 'remove', removes all locations which contain the insert position inside them.
    Note, if a region starts at the insert position, it is just moved to the right.
    */
    static QList<LRegion> fixLocationsForInsertedRegion(int insertPos, int len, QList<LRegion>& loc, AnnotationStrategyForResize s);

    /** Corrects annotation locations for a sequence. The passed list is updated with new locations, 
    the returned list contains removed locations if any.
    If specified strategy is 'remove', removes all locations which intersect the modified region or fall inside it.
    */
    static QList<LRegion> fixLocationsForReplacedRegion(const LRegion& regionToDelete, int newLen, QList<LRegion>& loc, AnnotationStrategyForResize s);

};


} //namespace

#endif
