/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "MultiTask.h"

namespace U2
{

MultiTask::MultiTask( const QString & name, const QList<Task *>& taskz ) : 
Task(name, TaskFlags_NR_FOSCOE)
{
    setMaxParallelSubtasks(1);
    if( taskz.empty() ) {
        assert( false ); 
        return;
    }

    foreach( Task * t, taskz ) {
        addSubTask(t);
    }
}

} //namespace
