/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_LOAD_REMOTE_DOCUMENT_TASK_H_
#define _U2_LOAD_REMOTE_DOCUMENT_TASK_H_

#include <U2Core/Task.h>
#include <U2Core/GUrl.h>

#include <QtCore/QEventLoop>
#include <QtCore/QUrl>

#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>

#include <QtXml/QXmlDefaultHandler>
#include <QtXml/QXmlSimpleReader>

namespace U2 {

class Document;
class CopyDataTask;
class LoadDocumentTask;
class LoadDataFromEntrezTask;

class U2CORE_EXPORT RemoteDBRegistry {
    RemoteDBRegistry(); 
    QMap<QString,QString> queryDBs;
    QMap<QString,QString> httpDBs;
    QMap<QString,QString> hints;
public:
    QString getURL(const QString& accId, const QString& dbName);
    QString getDbEntrezName(const QString& dbName);
    QList<QString> getDBs();
    QString getHint(const QString& dbName);
    //TODO: move this to AppContext
    static RemoteDBRegistry& getRemoteDBRegistry();
};


class U2CORE_EXPORT RecentlyDownloadedCache : public QObject {
    Q_OBJECT
    QMap<QString, QString> urlMap;
    void loadCacheFromSettings();
    void saveCacheToSettings();
public:
    RecentlyDownloadedCache();
    ~RecentlyDownloadedCache();
    bool contains(const QString& fileName);
    void append(const QString& fullPath);
    void remove(const QString& fullPath);
    QString getFullPath(const QString& fileName);
    void clear() { urlMap.clear(); }

};


class U2CORE_EXPORT LoadRemoteDocumentTask : public Task {
    Q_OBJECT
public:
    static QString getFileFormat(const QString & dbName);

    bool prepareDownloadDirectory(QString &path);
    static QString getDefaultDownloadDirectory();
    
public:
    LoadRemoteDocumentTask(const GUrl& url);
    LoadRemoteDocumentTask(const QString& accId, const QString& dbName);
    LoadRemoteDocumentTask(const QString & accId, const QString & dbName, const QString & fullPathDir);
    virtual void prepare();
    virtual ReportResult report();
    QString getLocalUrl(){ return fullPath; }
    Document* getDocument();

    QString getAccNumber() const { return accNumber; }
    QString getDBName() const { return dbName; }

protected:
    QList<Task*> onSubTaskFinished(Task* subTask);
private:
    bool openView;
    bool initLoadDocumentTask(); 
    DocumentFormatId formatId;
    CopyDataTask* copyDataTask;
    LoadDocumentTask* loadDocumentTask;
    Document* doc;
    LoadDataFromEntrezTask* loadDataFromEntrezTask;
    GUrl    sourceUrl;
    QString accNumber, dbName, format;
    QString fileName, fullPath;
};

// This task makes queries to NCBI Entrez search engine, using eTools
// First step: query eSearch to get global Entrez index
// Second step: query eFetch to download file by index
// About eTools: http://www.ncbi.nlm.nih.gov/bookshelf/br.fcgi?book=coursework&part=eutils

class U2CORE_EXPORT LoadDataFromEntrezTask : public Task {
    Q_OBJECT
public:
    LoadDataFromEntrezTask(const QString& dbId, const QString& accNumber, const QString& retType, const QString& fullPath);
    virtual void run();
public slots:
    void sl_replyFinished(QNetworkReply* reply);
    void sl_onError(QNetworkReply::NetworkError error);
    void sl_uploadProgress( qint64 bytesSent, qint64 bytesTotal);
    //void sl_readyRead();
private:
    QEventLoop* loop;
    QNetworkReply* searchReply;
    QNetworkReply* downloadReply;
    QNetworkAccessManager* networkManager;
    QXmlSimpleReader xmlReader;
    QString db, accNumber;
    QString resultIndex;
    QString fullPath, format;
};


// Helper class to parse NCBI Entrez eSearch results
class ESearchResultHandler : public QXmlDefaultHandler {
    bool metESearchResult;
    QString errorStr;
    QString curText;
    QString index;
public:
    ESearchResultHandler();
    bool startElement(const QString &namespaceURI, const QString &localName,
        const QString &qName, const QXmlAttributes &attributes);
    bool endElement(const QString &namespaceURI, const QString &localName,
        const QString &qName);
    bool characters(const QString &str);
    bool fatalError(const QXmlParseException &exception);
    QString errorString() const { return errorStr; }
    QString getResultIndex() const { return index; }
};

} //namespace

#endif // _U2_LOAD_REMOTE_DOCUMENT_TASK_H_
