/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef __EXTRACT_ANNOTATED_REGION_TASK_H__
#define __EXTRACT_ANNOTATED_REGION_TASK_H__

#include <U2Core/Task.h>
#include <U2Core/DNASequence.h>
#include <U2Core/AnnotationData.h>

#include <U2Core/DNATranslation.h>

namespace U2 {

struct U2CORE_EXPORT ExtractAnnotatedRegionTaskSettings {
    ExtractAnnotatedRegionTaskSettings() : gapSym('-'), gapLength(0), translate(true), complement(true), extLeft(0), extRight(0) {}
    char    gapSym;
    int     gapLength;
    bool    translate;
    bool    complement;
    int     extLeft; 
    int     extRight;
};

class U2CORE_EXPORT ExtractAnnotatedRegionTask : public Task {
    Q_OBJECT
public:
    ExtractAnnotatedRegionTask( const DNASequence & sequence, SharedAnnotationData sd, const ExtractAnnotatedRegionTaskSettings & cfg);
    void prepare();
    void run();
    DNASequence getResultedSequence() const {return resultedSeq;}
    SharedAnnotationData getResultedAnnotation() {return resultedAnn;}
private:
    void prepareTranslations();
    void extractLocations(QList<QByteArray>& resParts, QList<LRegion>& resLocation, const QList<LRegion>& origLocation);
    
    DNASequence inputSeq;
    SharedAnnotationData inputAnn;
    ExtractAnnotatedRegionTaskSettings cfg;

    QList<LRegion> extendedRegions;
    DNATranslation * complT;
    DNATranslation * aminoT;

    SharedAnnotationData resultedAnn;
    DNASequence resultedSeq;
};

}// ns

#endif 
