/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_DOCUMENT_UTILS_H_
#define _U2_DOCUMENT_UTILS_H_

#include <U2Core/global.h>
#include <U2Core/IOAdapter.h>

#include "DocumentModel.h"

namespace U2 {

class U2CORE_EXPORT DocumentUtils: public QObject    {
public:
    /* returns set with document urls */
    static QSet<QString> getURLs(const QList<Document*>& docs);
        
    /*  The set of urls that should not be used for new documents
        returns list of loaded urls. Gets them from the active project 
    */
    static QSet<QString> getNewDocFileNameExcludesHint();

    // the best match goes first in the returned list
    static QList<DocumentFormat*> detectFormat(const GUrl& url);

    // io - opened io adapter
    static QList<DocumentFormat*> detectFormat( IOAdapter* io );

    static QList<DocumentFormat*> detectFormat(const QByteArray& rawData, const QString& ext = QString());
};

}//namespace

#endif

