/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include "UIndexObject.h"

namespace U2 {

const QString UIndexObject::OBJ_NAME = "Index";

UIndexObject::UIndexObject( const UIndex& a_ind, const QString& name ) : GObject( GObjectTypes::UINDEX, name ),
                                                                         ind( a_ind ){}

UIndex UIndexObject::getIndex() const {
    return ind;
}

GObject* UIndexObject::clone() const {
    UIndexObject* cln = new UIndexObject( ind, getGObjectName() );
    cln->setIndexInfo(getIndexInfo());
    return cln;
}

} // U2
