/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_USER_APPLICATIONS_SETTINGS_H_
#define _U2_USER_APPLICATIONS_SETTINGS_H_

#include <U2Core/global.h>

namespace U2 {

class U2CORE_EXPORT UserAppsSettings : public QObject {
    Q_OBJECT
public:
    QString getWebBrowserURL() const;
    void setWebBrowserURL(const QString& url);

    bool useDefaultWebBrowser() const;
    void setUseDefaultWebBrowser(bool state);

    QString getTranslationFile() const;
    void setTranslationFile(const QString& fn);

    bool openLastProjectAtStartup() const;
    void setOpenLastProjectAtStartup(bool v);

    //a style selected by user
    QString getVisualStyle() const;
    void setVisualStyle(const QString& newStyle);
    
    // specify dir for downloaded files
    QString getDownloadDirPath() const;
    void setDownloadDirPath(const QString& newPath) const;

    // recently downloaded file names
    QStringList getRecentlyDownloadedFileNames() const;
    void setRecentlyDownloadedFileNames(const QStringList& fileNames) const;

    // specify dir for downloaded files
    QString getTemporaryDirPath() const;
    void setTemporaryDirPath(const QString& newPath);

    bool enableCollectingStatistics() const;
    void setEnableCollectingStatistics(bool b);
signals:
    void si_temporaryPathCanged();
};

}//namespace

#endif
