/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_RESOURCE_TRACKER_H_
#define _U2_RESOURCE_TRACKER_H_

#include <U2Core/global.h>

#include <QtCore/QList>
#include <QtCore/QMap>

namespace U2 {


class Task;

class U2CORE_EXPORT ResourceTracker : public QObject {
    Q_OBJECT
public:
    ResourceTracker(){}
    ~ResourceTracker();

    void registerResourceUser(const QString& resourceName, Task* t);
    void unregisterResourceUser(const QString& resourceName, Task* t);

    QList<Task*> getResourceUsers(const QString& resourceName);

signals:
    void si_resourceUserRegistered(const QString& rName, Task* t);
    void si_resourceUserUnregistered(const QString& rName, Task* t);

private:
    typedef QList<Task*> TList;
    typedef QMap<QString, TList> RMap;

    RMap resMap;

};

} //namespace
#endif
