/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <U2Core/U2Region.h>

namespace U2 {

void U2Region::join(QList<U2Region>& result)  {
    qStableSort(result.begin(), result.end()); //sort by region start pos first
    for (int i = 0; i < result.length()-1;) {
        const U2Region& ri0 = result[i];
        const U2Region& ri1 = result[i+1];
        if (!ri0.intersects(ri1)) {
            i++;
            continue;
        }
        U2Region newRi = containingRegion(ri0, ri1);
        result[i] = newRi;
        result.removeAt(i+1);
    }
}

static bool _registerMeta() {
    qRegisterMetaType<U2Region>("U2Region");
    qRegisterMetaTypeStreamOperators<U2Region>("U2::U2Region");

    qRegisterMetaType<QList<U2Region> >("QList<U2::U2Region>");
    qRegisterMetaTypeStreamOperators< QList<U2Region> >("QList<U2::U2Region>");
    return true;
}

bool U2Region::registerMeta = _registerMeta();

QDataStream &operator<<(QDataStream &out, const U2Region &myObj) {
    out << myObj.startPos << myObj.length;
    return out;
}

QDataStream &operator>>(QDataStream &in, U2Region &myObj) {
    in >> myObj.startPos;
    in >> myObj.length;
    return in;
}

} //ns