/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_REPEAT_FINDER_SETTINGS_H_
#define _U2_REPEAT_FINDER_SETTINGS_H_

#include <U2Core/Task.h>

namespace U2 {

class DNAAlphabet;

enum RFAlgorithm {
    RFAlgorithm_Auto,
    RFAlgorithm_Diagonal,
    RFAlgorithm_Suffix
};

class RFResult {
public:
    RFResult() : x(0), y(0), l(0){}
    RFResult(int _x, int _y, int _len) : x(_x), y(_y), l(_len){}

    bool operator==(const RFResult& r) const {return x == r.x && y == r.y && l == r.l;}
    bool operator!=(const RFResult& r) const {return !(*this == r);}
    bool operator <(const RFResult& r) const {return (x != r.x) ? x < r.x : (y != r.y) ? y < r.y: (l < r.l);}

    int x;
    int y;
    int l;
};

class RFResultsListener {
public:
    virtual void onResult(const RFResult& r) = 0;
    virtual void onResults(const QVector<RFResult>& v) = 0;
};

struct RepeatFinderSettings {
    RepeatFinderSettings()
    :   l(NULL), seqX(NULL), sizeX(0), inverted(false),
        seqY(NULL), sizeY(0),
        al(NULL), w(0), mismatches(0),
        alg(RFAlgorithm_Auto), nThreads(0)
    {}

    RepeatFinderSettings(
        RFResultsListener* _l, const char *_seqX, int _sizeX, bool _inverted,
        const char *_seqY, int _sizeY, DNAAlphabet *_al, int _w, int _mismatches,
        RFAlgorithm _alg, int _nThreads = MAX_PARALLEL_SUBTASKS_AUTO
    )
    :   l(_l), seqX(_seqX), sizeX(_sizeX), inverted(_inverted),
        seqY(_seqY), sizeY(_sizeY),
        al(_al), w(_w), mismatches(_mismatches),
        alg(_alg), nThreads(_nThreads)
    {}

    RFResultsListener*  l;
    const char *        seqX;
    int                 sizeX;
    bool                inverted;
    const char *        seqY;
    int                 sizeY;
    DNAAlphabet *       al;
    int                 w;
    int                 mismatches;
    RFAlgorithm         alg;
    int                 nThreads;

    bool operator==(const RepeatFinderSettings& op) const {
        return  l == op.l &&
                seqX == op.seqX &&
                sizeX == op.sizeX &&
                inverted == op.inverted &&
                seqY == op.seqY &&
                sizeY == op.sizeY &&
                al == op.al &&
                w == op.w &&
                mismatches == op.mismatches &&
                alg == op.alg &&
                nThreads == op.nThreads;
    }
};

} // namespace

#endif
