/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_MUSCLE_LOCAL_TASK_H_
#define _GB2_MUSCLE_LOCAL_TASK_H_

#include <core_api/StateLockableDataModel.h>
#include <distributed_computing/LocalTask.h>
#include <distributed_computing/RemoteMachine.h>
#include <distributed_computing/RemoteTask.h>

#include "MuscleTask.h"

namespace GB2 {

class MuscleLocalTaskSettings : public LocalTaskSettings {
private:
    static const int SERIALIZED_LIST_SZ = 2;
    static const int SERIALIZED_MUSCLE_TASK_SETTINGS_LIST_SZ = 9;
    
public:
    MuscleLocalTaskSettings();
    MuscleLocalTaskSettings( const MAlignment & ma, const MuscleTaskSettings & settings );
    virtual ~MuscleLocalTaskSettings();
    
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );
    
    MAlignment getMAlignment() const;
    MuscleTaskSettings getMuscleSettings() const;
    
private:
    QVariant serializeMuscleTaskSettings() const;
    bool deserializeMuscleTaskSettings( const QVariant & data );
    
private:
    MAlignment          alignment;
    MuscleTaskSettings settings;
    
}; // MuscleLocalTaskSettings

class MuscleLocalTaskResult : public LocalTaskResult {
public:
    static const int SERIALIZED_LIST_SZ = 2;
    
public:
    MuscleLocalTaskResult();
    ~MuscleLocalTaskResult();
    MuscleLocalTaskResult( const MAlignment & ma, const MAlignment & subMa );
    
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );
    
    MAlignment getMa() const;
    MAlignment getSubMa() const;
    void setResult( const MAlignment & ma, const MAlignment & sub );
    
private:
    MAlignment ma;
    MAlignment subMa;
    
}; // MuscleLocalTaskResult

class MuscleLocalTask : public LocalTask {
    Q_OBJECT
public:
    /* MuscleLocalTask takes responsibility for settings */
    MuscleLocalTask( MuscleLocalTaskSettings * settings );
    virtual ~MuscleLocalTask();
    
    virtual void prepare();
    virtual ReportResult report();
    
    virtual const LocalTaskResult * getResult() const;
    
    virtual QString generateReport() const;

private:
    MuscleLocalTaskSettings *  settings;
    MuscleLocalTaskResult      result;
    MuscleTask *               muscleTask;
    
}; // MuscleLocalTask

class MuscleRemoteToGobjectTask : public Task {
    Q_OBJECT
public:
    MuscleRemoteToGobjectTask( MAlignmentObject * obj, const MuscleTaskSettings & settings, RemoteMachineSettings * machine );
    ~MuscleRemoteToGobjectTask();
    
    virtual void prepare();
    virtual ReportResult report();
    
    virtual QString generateReport() const;
    
private:
    QPointer< MAlignmentObject >    obj;
    StateLock *                     lock;
    RemoteTask *                    muscleTask;
    RemoteMachineSettings *         machineSettings;
    RemoteMachine *                 machine;
    MuscleTaskSettings              config;
    
}; // MuscleRemoteToGobjectTask

typedef SimpleLocalTaskFactoryImpl< MuscleLocalTaskSettings, MuscleLocalTask, MuscleLocalTaskResult > MuscleLocalTaskFactory;

} // GB2

#endif // _GB2_MUSCLE_LOCAL_TASK_H_
