/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_KALIGN_PLUGIN_H_
#define _GB2_KALIGN_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/AppContext.h>
#include <core_api/ObjectViewModel.h>

#include <QtGui/QMenu>

//#include <kalign_local_task/KalignLocalTask.h> //TODO

namespace GB2 {

class MSAEditor;
class KalignMSAEditorContext;
class XMLTestFactory;

class KalignPlugin : public Plugin {
	Q_OBJECT
public:
	KalignPlugin();
	~KalignPlugin();

private:
	KalignMSAEditorContext* ctx;
	//KalignLocalTaskFactory  kalignLocalTaskFactory; //TODO

};


class KalignMSAEditorContext: public GObjectViewWindowContext {
	Q_OBJECT
public:
	KalignMSAEditorContext(QObject* p);

	protected slots:
		void sl_align();

protected:
	virtual void initViewContext(GObjectView* view);
	virtual void buildMenu(GObjectView* v, QMenu* m);
};

class KalignAction : public GObjectViewAction {
	Q_OBJECT
public:
	KalignAction(QObject* p, GObjectView* v, const QString& text, int order) 
		: GObjectViewAction(p,v,text,order) {}
	MSAEditor*  getMSAEditor() const;

	private slots:
		void sl_lockedStateChanged();
};

} //namespace

#endif
