/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "KalignException.h"
#include <assert.h>
#include <memory>
#include <string.h>

extern "C" void throwKalignException(char *message) {
	throw GB2::KalignException(message);
}

namespace GB2 {

KalignException::KalignException(const char* _str) {
	int len = strlen(_str);
	assert(len < 4096);
	memcpy(str, _str, len);
	str[len] = '\0';
}

KalignException::KalignException() {
	memset(str, 4096, '\0');
}

} // namespace GB2
