/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_CMDLINE_TASKS_H_
#define _GB2_WORKFLOW_CMDLINE_TASKS_H_

#include <core_api/Task.h>
#include <workflow_support/WorkflowRunTask.h>
#include <distributed_computing/RemoteMachine.h>

namespace GB2 {

class WorkflowRunFromCMDLineBase : public Task {
    Q_OBJECT
public:
    WorkflowRunFromCMDLineBase();
    virtual ~WorkflowRunFromCMDLineBase();
    QList<Task*> onSubTaskFinished( Task* subTask );

protected:
    virtual Task * getWorkflowRunTask() const = 0;
    
private:
    QString getPathToSchemaFile( const QString & name ) const;
    LoadWorkflowTask * prepareLoadSchemaTask( const QString & schemaName );
    void processLoadSchemaTask( const QString & schemaName, int optionIdx );

protected:
    Schema*             schema;
    int                 optionsStartAt;
    LoadWorkflowTask *  loadTask;

}; // WorkflowRunFromCMDLineBase

class WorkflowRunFromCMDLineTask : public WorkflowRunFromCMDLineBase {
    Q_OBJECT
public:
    virtual Task * getWorkflowRunTask() const;
}; // WorkflowRunFromCMDLineTask

class WorkflowRemoteRunFromCMDLineTask : public WorkflowRunFromCMDLineBase {
    Q_OBJECT
public:
    WorkflowRemoteRunFromCMDLineTask();
    virtual Task * getWorkflowRunTask() const;
    
private:
    RemoteMachineSettings * settings;
    
}; // WorkflowRemoteRunFromCMDLineTask

} // GB2

#endif // _GB2_WORKFLOW_CMDLINE_TASKS_H_
